/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.rpc;

import com.alipay.sofa.rpc.config.ProviderConfig;
import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.hugegraph.rpc.RpcServiceConfig4Server;
import org.apache.hugegraph.util.E;

public class RpcProviderConfig
implements RpcServiceConfig4Server {
    private final Map<String, ProviderConfig<?>> configs = Maps.newHashMap();

    @Override
    public <T, S extends T> String addService(Class<T> clazz, S serviceImpl) {
        return this.addService(null, clazz.getName(), serviceImpl);
    }

    @Override
    public <T, S extends T> String addService(String graph, Class<T> clazz, S serviceImpl) {
        return this.addService(graph, clazz.getName(), serviceImpl);
    }

    private <T, S extends T> String addService(String graph, String interfaceId, S serviceImpl) {
        String serviceId;
        ProviderConfig providerConfig = new ProviderConfig();
        if (graph != null) {
            serviceId = interfaceId + ":" + graph;
            ((ProviderConfig)providerConfig.setId(serviceId)).setUniqueId(graph);
        } else {
            serviceId = interfaceId;
        }
        ((ProviderConfig)providerConfig.setInterfaceId(interfaceId)).setRef(serviceImpl);
        E.checkArgument((!this.configs.containsKey(serviceId) ? 1 : 0) != 0, (String)"Not allowed to add service already exist: '%s'", (Object[])new Object[]{serviceId});
        this.configs.put(serviceId, providerConfig);
        return serviceId;
    }

    @Override
    public void removeService(String serviceId) {
        ProviderConfig<?> config = this.configs.remove(serviceId);
        E.checkArgument((config != null ? 1 : 0) != 0, (String)"The service '%s' doesn't exist", (Object[])new Object[]{serviceId});
        config.unExport();
    }

    @Override
    public void removeAllService() {
        for (ProviderConfig<?> config : this.configs.values()) {
            config.unExport();
        }
        this.configs.clear();
    }

    public Map<String, ProviderConfig<?>> configs() {
        return this.configs;
    }
}

