/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.client;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.stub.StreamObserver;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.hugegraph.pd.client.AbstractClient;
import org.apache.hugegraph.pd.client.Channels;
import org.apache.hugegraph.pd.client.PDConfig;
import org.apache.hugegraph.pd.client.PDWatch;
import org.apache.hugegraph.pd.grpc.watch.HgPdWatchGrpc;
import org.apache.hugegraph.pd.grpc.watch.WatchCreateRequest;
import org.apache.hugegraph.pd.grpc.watch.WatchNodeResponse;
import org.apache.hugegraph.pd.grpc.watch.WatchPartitionResponse;
import org.apache.hugegraph.pd.grpc.watch.WatchRequest;
import org.apache.hugegraph.pd.grpc.watch.WatchResponse;
import org.apache.hugegraph.pd.grpc.watch.WatchType;
import org.apache.hugegraph.pd.watch.NodeEvent;
import org.apache.hugegraph.pd.watch.PartitionEvent;

final class PDWatchImpl
implements PDWatch {
    private HgPdWatchGrpc.HgPdWatchStub stub;
    private String pdServerAddress;
    private static ConcurrentHashMap<String, ManagedChannel> chs = new ConcurrentHashMap();

    PDWatchImpl(String pdServerAddress, PDConfig config) {
        this.pdServerAddress = pdServerAddress;
        this.stub = AbstractClient.setAsyncParams(HgPdWatchGrpc.newStub((Channel)Channels.getChannel(pdServerAddress)), config);
    }

    @Override
    public String getCurrentHost() {
        return this.pdServerAddress;
    }

    @Override
    public boolean checkChannel() {
        return this.stub != null && !Channels.getChannel(this.pdServerAddress).isShutdown();
    }

    @Override
    public PDWatch.Watcher watchPartition(PDWatch.Listener<PartitionEvent> listener) {
        return new PartitionWatcher(listener);
    }

    @Override
    public PDWatch.Watcher watchNode(PDWatch.Listener<NodeEvent> listener) {
        return new NodeWatcher(listener);
    }

    @Override
    public PDWatch.Watcher watchGraph(PDWatch.Listener<WatchResponse> listener) {
        return new GraphWatcher(listener);
    }

    @Override
    public PDWatch.Watcher watchShardGroup(PDWatch.Listener<WatchResponse> listener) {
        return new ShardGroupWatcher(listener);
    }

    private abstract class AbstractWatcher<T>
    implements PDWatch.Watcher,
    StreamObserver<WatchResponse> {
        PDWatch.Listener<T> listener;
        StreamObserver<WatchRequest> reqStream;
        Supplier<WatchCreateRequest> requestSupplier;

        private AbstractWatcher(PDWatch.Listener<T> listener, Supplier<WatchCreateRequest> requestSupplier) {
            this.listener = listener;
            this.requestSupplier = requestSupplier;
            this.init();
        }

        void init() {
            this.reqStream = PDWatchImpl.this.stub.watch((StreamObserver)this);
            this.reqStream.onNext((Object)WatchRequest.newBuilder().setCreateRequest(this.requestSupplier.get()).build());
        }

        @Override
        public void close() {
            this.reqStream.onCompleted();
        }

        public abstract void onNext(WatchResponse var1);

        public void onError(Throwable throwable) {
            this.listener.onError(throwable);
        }

        public void onCompleted() {
            this.listener.onCompleted();
        }
    }

    private class NodeWatcher
    extends AbstractWatcher<NodeEvent> {
        private NodeWatcher(PDWatch.Listener listener) {
            super(listener, () -> WatchCreateRequest.newBuilder().setWatchType(WatchType.WATCH_TYPE_STORE_NODE_CHANGE).build());
        }

        @Override
        public void onNext(WatchResponse watchResponse) {
            WatchNodeResponse res = watchResponse.getNodeResponse();
            NodeEvent event = new NodeEvent(res.getGraph(), res.getNodeId(), NodeEvent.EventType.grpcTypeOf(res.getNodeEventType()));
            this.listener.onNext(event);
        }
    }

    private class PartitionWatcher
    extends AbstractWatcher<PartitionEvent> {
        private PartitionWatcher(PDWatch.Listener listener) {
            super(listener, () -> WatchCreateRequest.newBuilder().setWatchType(WatchType.WATCH_TYPE_PARTITION_CHANGE).build());
        }

        @Override
        public void onNext(WatchResponse watchResponse) {
            WatchPartitionResponse res = watchResponse.getPartitionResponse();
            PartitionEvent event = new PartitionEvent(res.getGraph(), res.getPartitionId(), PartitionEvent.ChangeType.grpcTypeOf(res.getChangeType()));
            this.listener.onNext(event);
        }
    }

    private class ShardGroupWatcher
    extends AbstractWatcher<WatchResponse> {
        private ShardGroupWatcher(PDWatch.Listener listener) {
            super(listener, () -> WatchCreateRequest.newBuilder().setWatchType(WatchType.WATCH_TYPE_SHARD_GROUP_CHANGE).build());
        }

        @Override
        public void onNext(WatchResponse watchResponse) {
            this.listener.onNext(watchResponse);
        }
    }

    private class GraphWatcher
    extends AbstractWatcher<WatchResponse> {
        private GraphWatcher(PDWatch.Listener listener) {
            super(listener, () -> WatchCreateRequest.newBuilder().setWatchType(WatchType.WATCH_TYPE_GRAPH_CHANGE).build());
        }

        @Override
        public void onNext(WatchResponse watchResponse) {
            this.listener.onNext(watchResponse);
        }
    }
}

