/*
 * Decompiled with CFR 0.152.
 */
package org.apdplat.word.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoubleArrayGenericTrie {
    private static final Logger LOGGER = LoggerFactory.getLogger(DoubleArrayGenericTrie.class);
    private int size = 65000;
    private int[] check;
    private int[] base;
    private boolean[] used;
    private int nextCheckPos;

    public DoubleArrayGenericTrie(int n) {
        this.size = n;
    }

    public DoubleArrayGenericTrie() {
        LOGGER.info("\u521d\u59cb\u5316\u53cc\u6570\u7ec4\u524d\u7f00\u6811\uff1a" + this.getClass().getName());
    }

    private List<Node> toTree(Node node2, List<String> list, Map<String, Integer> map) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        char c = '\u0000';
        for (int i = node2.left; i < node2.right; ++i) {
            if (list.get(i).length() < node2.depth) continue;
            String string = list.get(i);
            char c2 = '\u0000';
            if (string.length() != node2.depth) {
                c2 = string.charAt(node2.depth);
            }
            if (c2 != c || arrayList.isEmpty()) {
                Node node3 = new Node();
                node3.depth = node2.depth + 1;
                node3.code = c2;
                node3.left = i;
                if ((c2 == '\u0000' || c2 == string.charAt(string.length() - 1)) && map.get(string) != null) {
                    node3.value = map.get(string);
                }
                if (!arrayList.isEmpty()) {
                    ((Node)arrayList.get(arrayList.size() - 1)).right = i;
                }
                arrayList.add(node3);
            }
            c = c2;
        }
        if (!arrayList.isEmpty()) {
            ((Node)arrayList.get(arrayList.size() - 1)).right = node2.right;
            if (LOGGER.isDebugEnabled() && list.size() < 10) {
                LOGGER.debug("************************************************");
                LOGGER.debug("\u6811\u4fe1\u606f\uff1a");
                arrayList.forEach(node -> LOGGER.debug(node.toString()));
                LOGGER.debug("************************************************");
            }
        }
        return arrayList;
    }

    private int toDoubleArray(List<Node> list, List<String> list2, Map<String, Integer> map) {
        int n;
        int n2 = 0;
        int n3 = list.get(0).code > this.nextCheckPos ? list.get(0).code : this.nextCheckPos;
        boolean bl = true;
        block0: while (true) {
            if (this.check[++n3] != 0) {
                continue;
            }
            if (bl) {
                this.nextCheckPos = n3;
                bl = false;
            }
            if (this.used[n2 = n3 - list.get(0).code]) continue;
            for (n = 1; n < list.size(); ++n) {
                if (this.check[n2 + list.get(n).code] == 0) continue;
                continue block0;
            }
            break;
        }
        this.used[n2] = true;
        for (n = 0; n < list.size(); ++n) {
            this.check[n2 + ((Node)list.get((int)n)).code] = n2;
        }
        for (n = 0; n < list.size(); ++n) {
            int n4;
            List<Node> list3 = this.toTree(list.get(n), list2, map);
            if (list3.isEmpty()) {
                this.base[n2 + ((Node)list.get((int)n)).code] = -1;
                this.check[n2 + ((Node)list.get((int)n)).code] = list.get(n).value;
                continue;
            }
            this.base[n2 + ((Node)list.get((int)n)).code] = n4 = this.toDoubleArray(list3, list2, map);
        }
        return n2;
    }

    private void allocate(int n) {
        this.check = null;
        this.base = null;
        this.used = null;
        this.nextCheckPos = 0;
        this.base = new int[n];
        this.check = new int[n];
        this.used = new boolean[n];
        this.base[0] = 1;
    }

    private void init(List<String> list, Map<String, Integer> map) {
        if (list == null || list.isEmpty()) {
            return;
        }
        Node node = new Node();
        node.left = 0;
        node.right = list.size();
        node.depth = 0;
        while (true) {
            try {
                this.allocate(this.size);
                List<Node> list2 = this.toTree(node, list, map);
                this.toDoubleArray(list2, list, map);
            }
            catch (Exception exception) {
                this.size += this.size / 10;
                LOGGER.error("\u5206\u914d\u7a7a\u95f4\u4e0d\u591f\uff0c\u589e\u52a0\u81f3\uff1a " + this.size);
                continue;
            }
            break;
        }
        list.clear();
        list = null;
        map.clear();
        map = null;
        this.used = null;
    }

    public int get(String string, int n, int n2) {
        int n3;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u5f00\u59cb\u67e5\u8be2\u6570\u636e\uff1a{}", (Object)string.substring(n, n + n2));
        }
        if (this.base == null) {
            return Integer.MIN_VALUE;
        }
        int n4 = this.base[0];
        for (int i = n; i < n + n2; ++i) {
            n3 = n4 + string.charAt(i);
            if (n3 >= this.check.length || n3 < 0) {
                return Integer.MIN_VALUE;
            }
            if (n4 != this.check[n3]) {
                return Integer.MIN_VALUE;
            }
            n4 = this.base[n3];
        }
        n3 = n4;
        if (n3 >= this.check.length || n3 < 0) {
            return Integer.MIN_VALUE;
        }
        if (this.base[n3] < 0) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("\u5728\u8bcd\u5178\u4e2d\u67e5\u5230\u8bcd\uff1a{}", (Object)string.substring(n, n + n2));
            }
            return this.check[n4];
        }
        return Integer.MIN_VALUE;
    }

    public int get(String string) {
        return this.get(string, 0, string.length());
    }

    public void putAll(Map<String, Integer> map) {
        if (this.check != null) {
            throw new RuntimeException("addAll method can just be used once after clear method!");
        }
        List<String> list = map.keySet().stream().sorted().collect(Collectors.toList());
        if (LOGGER.isDebugEnabled() && list.size() < 10) {
            list.forEach(string -> LOGGER.debug(string + "=" + map.get(string)));
        }
        this.init(list, map);
    }

    public void clear() {
        this.check = null;
        this.base = null;
        this.used = null;
        this.nextCheckPos = 0;
    }

    public static void main(String[] stringArray) {
        DoubleArrayGenericTrie doubleArrayGenericTrie = new DoubleArrayGenericTrie();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("\u6768\u5c1a\u5ddd", 100);
        hashMap.put("\u7ae0\u5b50\u6021", 101);
        hashMap.put("\u5218\u4ea6\u83f2", 99);
        hashMap.put("\u5218", 11);
        hashMap.put("\u5218\u8bd7\u8bd7", -1);
        hashMap.put("\u5de9\u4fd0", 1);
        hashMap.put("\u4e2d\u56fd", 2);
        hashMap.put("\u4e3b\u6f14", 3);
        doubleArrayGenericTrie.putAll(hashMap);
        System.out.println("\u589e\u52a0\u6570\u636e");
        System.out.println("\u67e5\u627e \u6768\u5c1a\u5ddd\uff1a" + doubleArrayGenericTrie.get("\u6768\u5c1a\u5ddd"));
        System.out.println("\u67e5\u627e \u7ae0\u5b50\u6021\uff1a" + doubleArrayGenericTrie.get("\u7ae0\u5b50\u6021"));
        System.out.println("\u67e5\u627e \u5218\uff1a" + doubleArrayGenericTrie.get("\u5218"));
        System.out.println("\u67e5\u627e \u5218\u4ea6\u83f2\uff1a" + doubleArrayGenericTrie.get("\u5218\u4ea6\u83f2"));
        System.out.println("\u67e5\u627e \u5218\u8bd7\u8bd7\uff1a" + doubleArrayGenericTrie.get("\u5218\u8bd7\u8bd7"));
        System.out.println("\u67e5\u627e \u5de9\u4fd0\uff1a" + doubleArrayGenericTrie.get("\u5de9\u4fd0"));
        System.out.println("\u67e5\u627e \u4e2d\u56fd\u7684\u5de9\u4fd0\u662f\u7ea2\u9ad8\u7cb1\u7684\u4e3b\u6f14 3 2\uff1a" + doubleArrayGenericTrie.get("\u4e2d\u56fd\u7684\u5de9\u4fd0\u662f\u7ea2\u9ad8\u7cb1\u7684\u4e3b\u6f14", 3, 2));
        System.out.println("\u67e5\u627e \u4e2d\u56fd\u7684\u5de9\u4fd0\u662f\u7ea2\u9ad8\u7cb1\u7684\u4e3b\u6f14 0 2\uff1a" + doubleArrayGenericTrie.get("\u4e2d\u56fd\u7684\u5de9\u4fd0\u662f\u7ea2\u9ad8\u7cb1\u7684\u4e3b\u6f14", 0, 2));
        System.out.println("\u67e5\u627e \u4e2d\u56fd\u7684\u5de9\u4fd0\u662f\u7ea2\u9ad8\u7cb1\u7684\u4e3b\u6f14 10 2\uff1a" + doubleArrayGenericTrie.get("\u4e2d\u56fd\u7684\u5de9\u4fd0\u662f\u7ea2\u9ad8\u7cb1\u7684\u4e3b\u6f14", 10, 2));
        System.out.println("\u67e5\u627e \u590d\u4ec7\u8005\u8054\u76df2\uff1a" + doubleArrayGenericTrie.get("\u590d\u4ec7\u8005\u8054\u76df2"));
        System.out.println("\u67e5\u627e \u767d\u638c\uff1a" + doubleArrayGenericTrie.get("\u767d\u638c"));
        System.out.println("\u67e5\u627e \u7ea2\u638c\uff1a" + doubleArrayGenericTrie.get("\u7ea2\u638c"));
        doubleArrayGenericTrie.clear();
        System.out.println("\u6e05\u9664\u6240\u6709\u6570\u636e");
        System.out.println("\u67e5\u627e \u6768\u5c1a\u5ddd\uff1a" + doubleArrayGenericTrie.get("\u6768\u5c1a\u5ddd"));
        System.out.println("\u67e5\u627e \u7ae0\u5b50\u6021\uff1a" + doubleArrayGenericTrie.get("\u7ae0\u5b50\u6021"));
        hashMap.put("\u767d\u638c", 1000);
        hashMap.put("\u7ea2\u638c", 1001);
        hashMap.put("\u590d\u4ec7\u8005\u8054\u76df2", -1000);
        doubleArrayGenericTrie.putAll(hashMap);
        System.out.println("\u589e\u52a0\u6570\u636e");
        System.out.println("\u67e5\u627e \u6768\u5c1a\u5ddd\uff1a" + doubleArrayGenericTrie.get("\u6768\u5c1a\u5ddd"));
        System.out.println("\u67e5\u627e \u7ae0\u5b50\u6021\uff1a" + doubleArrayGenericTrie.get("\u7ae0\u5b50\u6021"));
        System.out.println("\u67e5\u627e \u590d\u4ec7\u8005\u8054\u76df2\uff1a" + doubleArrayGenericTrie.get("\u590d\u4ec7\u8005\u8054\u76df2"));
        System.out.println("\u67e5\u627e \u767d\u638c\uff1a" + doubleArrayGenericTrie.get("\u767d\u638c"));
        System.out.println("\u67e5\u627e \u7ea2\u638c\uff1a" + doubleArrayGenericTrie.get("\u7ea2\u638c"));
        System.out.println("\u67e5\u627e \u5218\u4ea6\u83f2\uff1a" + doubleArrayGenericTrie.get("\u5218\u4ea6\u83f2"));
        System.out.println("\u67e5\u627e \u5218\u8bd7\u8bd7\uff1a" + doubleArrayGenericTrie.get("\u5218\u8bd7\u8bd7"));
        System.out.println("\u67e5\u627e \u5de9\u4fd0\uff1a" + doubleArrayGenericTrie.get("\u5de9\u4fd0"));
        System.out.println("\u67e5\u627e \u91d1\u94b1\u6811\uff1a" + doubleArrayGenericTrie.get("\u91d1\u94b1\u6811"));
    }

    private static class Node {
        private int code;
        private int depth;
        private int left;
        private int right;
        private int value;

        private Node() {
        }

        public String toString() {
            return "Node{code=" + this.code + "[" + (char)this.code + "]" + ", depth=" + this.depth + ", left=" + this.left + ", right=" + this.right + ", value=" + this.value + '}';
        }
    }
}

