/*
 * Decompiled with CFR 0.152.
 */
package org.apdplat.word.lucene;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Queue;
import java.util.concurrent.LinkedTransferQueue;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apdplat.word.recognition.StopWord;
import org.apdplat.word.segmentation.Segmentation;
import org.apdplat.word.segmentation.SegmentationAlgorithm;
import org.apdplat.word.segmentation.SegmentationFactory;
import org.apdplat.word.segmentation.Word;
import org.apdplat.word.tagging.AntonymTagging;
import org.apdplat.word.tagging.PinyinTagging;
import org.apdplat.word.tagging.SynonymTagging;
import org.apdplat.word.util.WordConfTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChineseWordTokenizer
extends Tokenizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChineseWordTokenizer.class);
    private final CharTermAttribute charTermAttribute = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final OffsetAttribute offsetAttribute = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    private final PositionIncrementAttribute positionIncrementAttribute = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
    private static final boolean FULL_PINYIN = WordConfTools.getBoolean("tagging.pinyin.full", false);
    private static final boolean ACRONYM_PINYIN = WordConfTools.getBoolean("tagging.pinyin.acronym", false);
    private static final boolean SYNONYM = WordConfTools.getBoolean("tagging.synonym", false);
    private static final boolean ANTONYM = WordConfTools.getBoolean("tagging.antonym", false);
    private Segmentation segmentation = null;
    private BufferedReader reader = null;
    private final Queue<Word> words = new LinkedTransferQueue<Word>();
    private final Queue<String> tokens = new LinkedTransferQueue<String>();
    private int startOffset = 0;

    public ChineseWordTokenizer() {
        this.segmentation = SegmentationFactory.getSegmentation(SegmentationAlgorithm.BidirectionalMinimumMatching);
    }

    public ChineseWordTokenizer(String string) {
        try {
            SegmentationAlgorithm segmentationAlgorithm = SegmentationAlgorithm.valueOf(string);
            this.segmentation = SegmentationFactory.getSegmentation(segmentationAlgorithm);
        }
        catch (Exception exception) {
            this.segmentation = SegmentationFactory.getSegmentation(SegmentationAlgorithm.BidirectionalMinimumMatching);
        }
    }

    public ChineseWordTokenizer(SegmentationAlgorithm segmentationAlgorithm) {
        this.segmentation = SegmentationFactory.getSegmentation(segmentationAlgorithm);
    }

    public ChineseWordTokenizer(Segmentation segmentation) {
        this.segmentation = segmentation;
    }

    private Word getWord() throws IOException {
        Word word = this.words.poll();
        if (word == null) {
            String string;
            if (this.reader == null) {
                this.reader = new BufferedReader(this.input);
            }
            while ((string = this.reader.readLine()) != null) {
                this.words.addAll(this.segmentation.seg(string));
            }
            this.startOffset = 0;
            word = this.words.poll();
        }
        return word;
    }

    private String getToken() throws IOException {
        Word word2;
        String string = this.tokens.poll();
        if (string == null && (word2 = this.getWord()) != null) {
            StringBuilder stringBuilder;
            int n = 1;
            while (StopWord.is(word2.getText())) {
                ++n;
                this.startOffset += word2.getText().length();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("\u5ffd\u7565\u505c\u7528\u8bcd\uff1a" + word2.getText());
                }
                if ((word2 = this.getWord()) != null) continue;
                return null;
            }
            this.offsetAttribute.setOffset(this.startOffset, this.startOffset + word2.getText().length());
            this.positionIncrementAttribute.setPositionIncrement(n);
            this.startOffset += word2.getText().length();
            this.tokens.offer(word2.getText());
            if (FULL_PINYIN || ACRONYM_PINYIN) {
                PinyinTagging.process(Arrays.asList(word2));
                if (FULL_PINYIN && !"".equals(word2.getFullPinYin())) {
                    this.tokens.offer(word2.getFullPinYin());
                }
                if (ACRONYM_PINYIN && !"".equals(word2.getAcronymPinYin())) {
                    this.tokens.offer(word2.getAcronymPinYin());
                }
            }
            if (SYNONYM) {
                SynonymTagging.process(Arrays.asList(word2));
                stringBuilder = new StringBuilder();
                word2.getSynonym().forEach(word -> {
                    if (!"".equals(word.getText())) {
                        this.tokens.offer(word.getText());
                    }
                    stringBuilder.append(word.getText()).append(" ");
                });
            }
            if (ANTONYM) {
                AntonymTagging.process(Arrays.asList(word2));
                stringBuilder = new StringBuilder();
                word2.getAntonym().forEach(word -> {
                    if (!"".equals(word.getText())) {
                        this.tokens.offer(word.getText());
                    }
                    stringBuilder.append(word.getText()).append(" ");
                });
            }
            string = this.tokens.poll();
        }
        return string;
    }

    public final boolean incrementToken() throws IOException {
        String string = this.getToken();
        if (string != null) {
            this.charTermAttribute.setEmpty().append(string);
            return true;
        }
        return false;
    }
}

