/*
 * Decompiled with CFR 0.152.
 */
package org.apdplat.word;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apdplat.word.recognition.StopWord;
import org.apdplat.word.segmentation.SegmentationAlgorithm;
import org.apdplat.word.segmentation.SegmentationFactory;
import org.apdplat.word.segmentation.Word;
import org.apdplat.word.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WordSegmenter {
    private static final Logger LOGGER = LoggerFactory.getLogger(WordSegmenter.class);

    public static List<Word> segWithStopWords(String string, SegmentationAlgorithm segmentationAlgorithm) {
        return SegmentationFactory.getSegmentation(segmentationAlgorithm).seg(string);
    }

    public static List<Word> segWithStopWords(String string) {
        return SegmentationFactory.getSegmentation(SegmentationAlgorithm.MaxNgramScore).seg(string);
    }

    public static List<Word> seg(String string, SegmentationAlgorithm segmentationAlgorithm) {
        List<Word> list = SegmentationFactory.getSegmentation(segmentationAlgorithm).seg(string);
        StopWord.filterStopWords(list);
        return list;
    }

    public static List<Word> seg(String string) {
        List<Word> list = SegmentationFactory.getSegmentation(SegmentationAlgorithm.MaxNgramScore).seg(string);
        StopWord.filterStopWords(list);
        return list;
    }

    public static void segWithStopWords(File file, File file2, SegmentationAlgorithm segmentationAlgorithm) throws Exception {
        Utils.seg(file, file2, false, segmentationAlgorithm);
    }

    public static void segWithStopWords(File file, File file2) throws Exception {
        Utils.seg(file, file2, false, SegmentationAlgorithm.MaxNgramScore);
    }

    public static void seg(File file, File file2, SegmentationAlgorithm segmentationAlgorithm) throws Exception {
        Utils.seg(file, file2, true, segmentationAlgorithm);
    }

    public static void seg(File file, File file2) throws Exception {
        Utils.seg(file, file2, true, SegmentationAlgorithm.MaxNgramScore);
    }

    private static void demo() {
        long l = System.currentTimeMillis();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("\u6768\u5c1a\u5ddd\u662fAPDPlat\u5e94\u7528\u7ea7\u4ea7\u54c1\u5f00\u53d1\u5e73\u53f0\u7684\u4f5c\u8005");
        arrayList.add("\u4ed6\u8bf4\u7684\u786e\u5b9e\u5728\u7406");
        arrayList.add("\u63d0\u9ad8\u4eba\u6c11\u751f\u6d3b\u6c34\u5e73");
        arrayList.add("\u4ed6\u4fe9\u513f\u8c08\u604b\u7231\u662f\u4ece\u5934\u5e74\u5143\u6708\u5f00\u59cb\u7684");
        arrayList.add("\u738b\u5e9c\u996d\u5e97\u7684\u8bbe\u65bd\u548c\u670d\u52a1\u662f\u4e00\u6d41\u7684");
        arrayList.add("\u548c\u670d\u52a1\u4e8e\u4e09\u65e5\u540e\u88c1\u5236\u5b8c\u6bd5\uff0c\u5e76\u5448\u9001\u5c06\u519b\u5e9c\u4e2d");
        arrayList.add("\u7814\u7a76\u751f\u547d\u7684\u8d77\u6e90");
        arrayList.add("\u4ed6\u660e\u5929\u8d77\u8eab\u53bb\u5317\u4eac");
        arrayList.add("\u5728\u8fd9\u4e9b\u4f01\u4e1a\u4e2d\u56fd\u6709\u4f01\u4e1a\u6709\u5341\u4e2a");
        arrayList.add("\u4ed6\u7ad9\u8d77\u8eab\u6765");
        arrayList.add("\u4ed6\u4eec\u662f\u6765\u67e5\u91d1\u6cf0\u649e\u4eba\u90a3\u4ef6\u4e8b\u7684");
        arrayList.add("\u884c\u4fa0\u4ed7\u4e49\u7684\u67e5\u91d1\u6cf0\u8fdc\u8fd1\u95fb\u540d");
        arrayList.add("\u957f\u6625\u5e02\u957f\u6625\u8282\u81f4\u8f9e");
        arrayList.add("\u4ed6\u4ece\u9a6c\u4e0a\u6454\u4e0b\u6765\u4e86,\u4f60\u9a6c\u4e0a\u4e0b\u6765\u4e00\u4e0b");
        arrayList.add("\u4e52\u4e53\u7403\u62cd\u5356\u5b8c\u4e86");
        arrayList.add("\u54ac\u6b7b\u730e\u4eba\u7684\u72d7");
        arrayList.add("\u5730\u9762\u79ef\u4e86\u539a\u539a\u7684\u96ea");
        arrayList.add("\u8fd9\u51e0\u5757\u5730\u9762\u79ef\u8fd8\u771f\u4e0d\u5c0f");
        arrayList.add("\u5927\u5b66\u751f\u6d3b\u8c61\u767d\u7eb8");
        arrayList.add("\u7ed3\u5408\u6210\u5206\u5b50\u5f0f");
        arrayList.add("\u6709\u610f\u89c1\u5206\u6b67");
        arrayList.add("\u53d1\u5c55\u4e2d\u56fd\u5bb6\u5154\u7684\u8ba1\u5212");
        arrayList.add("\u660e\u5929\u4ed6\u5c06\u6765\u5317\u4eac");
        arrayList.add("\u7a0e\u6536\u5236\u5ea6\u5c06\u6765\u4f1a\u66f4\u5b8c\u5584");
        arrayList.add("\u4f9d\u9760\u7fa4\u4f17\u624d\u80fd\u505a\u597d\u5de5\u4f5c");
        arrayList.add("\u73b0\u5728\u662f\u65bd\u5c55\u624d\u80fd\u7684\u597d\u673a\u4f1a");
        arrayList.add("\u628a\u624b\u4e3e\u8d77\u6765");
        arrayList.add("\u8bf7\u628a\u624b\u62ff\u5f00");
        arrayList.add("\u8fd9\u4e2a\u95e8\u628a\u624b\u574f\u4e86");
        arrayList.add("\u8336\u676f\u7684\u628a\u624b\u65ad\u4e86");
        arrayList.add("\u5c06\u519b\u4efb\u547d\u4e86\u4e00\u540d\u4e2d\u5c06");
        arrayList.add("\u4ea7\u91cf\u4e09\u5e74\u4e2d\u5c06\u589e\u957f\u4e24\u500d");
        arrayList.add("\u4ee5\u65b0\u7684\u59ff\u6001\u51fa\u73b0\u5728\u4e16\u754c\u4e1c\u65b9");
        arrayList.add("\u4f7f\u8282\u7ea6\u7cae\u98df\u8fdb\u4e00\u6b65\u5f62\u6210\u98ce\u6c14");
        arrayList.add("\u53cd\u6620\u4e86\u4e00\u4e2a\u4eba\u7684\u7cbe\u795e\u9762\u8c8c");
        arrayList.add("\u7f8e\u56fd\u52a0\u5dde\u5927\u5b66\u7684\u79d1\u5b66\u5bb6\u53d1\u73b0");
        arrayList.add("\u6211\u597d\u4e0d\u633a\u597d");
        arrayList.add("\u6728\u6709");
        arrayList.add("\u4e0b\u96e8\u5929\u7559\u5ba2\u5929\u5929\u7559\u6211\u4e0d\u7559");
        arrayList.add("\u53d4\u53d4\u4eb2\u4e86\u6211\u5988\u5988\u4e5f\u4eb2\u4e86\u6211");
        arrayList.add("\u767d\u9a6c\u975e\u9a6c");
        arrayList.add("\u5b66\u751f\u4f1a\u5199\u6587\u7ae0");
        arrayList.add("\u5f20\u6396\u5e02\u6c11\u9648\u519b");
        arrayList.add("\u5f20\u6396\u5e02\u660e\u4e50\u53bf");
        arrayList.add("\u4e2d\u534e\u4eba\u6c11\u5171\u548c\u56fd\u4e07\u5c81\u4e07\u5c81\u4e07\u4e07\u5c81");
        arrayList.add("word\u662f\u4e00\u4e2a\u4e2d\u6587\u5206\u8bcd\u9879\u76ee\uff0c\u4f5c\u8005\u662f\u6768\u5c1a\u5ddd\uff0c\u6768\u5c1a\u5ddd\u7684\u82f1\u6587\u540d\u53ebysc");
        arrayList.add("\u6c5f\u9634\u6bdb\u7eba\u5382\u6210\u7acb\u4e86\u4fdd\u6301\u515a\u5458\u5148\u8fdb\u6027\u7231\u56fd\u4e3b\u4e49\u5b66\u4e60\u5c0f\u7ec4,\u5728\u6c5f\u9634\u9053\u8def\u7ba1\u7406\u5c40\u534f\u52a9\u4e0b,\u901a\u8fc7\u5b9d\u9e21\u5df4\u58eb\u516c\u53f8,\u4e0e\u8499\u725b\u9178\u9178\u4e73\u623f\u5c71\u5206\u9500\u70b9\u7ec4\u6210\u4e86\u5f00\u653e\u6027\u4ea4\u4e92\u5f0f\u7684\u8ba8\u8bba\u7ec4, \u8ba4\u4e3agoogle\u9000\u51fa\u4e2d\u56fd\u4e8b\u4ef6\u8d64\u88f8\u88f8\u4f53\u73b0\u4e86\u5e1d\u56fd\u4e3b\u4e49\u7684\u6587\u5316\u4fb5\u7565,\u6380\u8d77\u4e86\u7231\u56fd\u4e3b\u4e49\u7684\u7fa4\u4f17\u6027\u9ad8\u6f6e\u3002");
        arrayList.add("\u5de5\u4fe1\u5904\u5973\u5e72\u4e8b\u6bcf\u6708\u7ecf\u8fc7\u4e0b\u5c5e\u79d1\u5ba4\u90fd\u8981\u4eb2\u53e3\u4ea4\u4ee324\u53e3\u4ea4\u6362\u673a\u7b49\u6280\u672f\u6027\u5668\u4ef6\u7684\u5b89\u88c5\u5de5\u4f5c");
        arrayList.add("\u5546\u54c1\u548c\u670d\u52a1");
        arrayList.add("\u7ed3\u5a5a\u7684\u548c\u5c1a\u672a\u7ed3\u5a5a\u7684");
        arrayList.add("\u4e70\u6c34\u679c\u7136\u540e\u6765\u4e16\u535a\u56ed");
        arrayList.add("\u4e2d\u56fd\u7684\u9996\u90fd\u662f\u5317\u4eac");
        arrayList.add("\u8001\u5e08\u8bf4\u660e\u5929\u4e0b\u5348\u4f11\u606f");
        arrayList.add("\u4eca\u5929\u4e0b\u96e8");
        int n = 1;
        for (String string : arrayList) {
            List<Word> list = WordSegmenter.segWithStopWords(string);
            LOGGER.info(n++ + "\u3001\u5207\u5206\u53e5\u5b50: " + string);
            LOGGER.info("    \u5207\u5206\u7ed3\u679c\uff1a" + list);
        }
        long l2 = System.currentTimeMillis() - l;
        LOGGER.info("\u8017\u65f6: " + l2 + " \u6beb\u79d2");
    }

    public static void processCommand(String ... stringArray) {
        if (stringArray == null || stringArray.length < 1) {
            LOGGER.info("\u547d\u4ee4\u4e0d\u6b63\u786e");
            return;
        }
        try {
            switch (stringArray[0].trim().charAt(0)) {
                case 'd': {
                    WordSegmenter.demo();
                    break;
                }
                case 't': {
                    if (stringArray.length < 2) {
                        WordSegmenter.showUsage();
                        break;
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    for (int i = 1; i < stringArray.length; ++i) {
                        stringBuilder.append(stringArray[i]).append(" ");
                    }
                    List<Word> list = WordSegmenter.segWithStopWords(stringBuilder.toString());
                    LOGGER.info("\u5207\u5206\u53e5\u5b50\uff1a" + stringBuilder.toString());
                    LOGGER.info("\u5207\u5206\u7ed3\u679c\uff1a" + list.toString());
                    break;
                }
                case 'f': {
                    if (stringArray.length != 3) {
                        WordSegmenter.showUsage();
                        break;
                    }
                    WordSegmenter.segWithStopWords(new File(stringArray[1]), new File(stringArray[2]));
                    break;
                }
                default: {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (String string : stringArray) {
                        stringBuilder.append(string).append(" ");
                    }
                    List<Word> list = WordSegmenter.segWithStopWords(stringBuilder.toString());
                    LOGGER.info("\u5207\u5206\u53e5\u5b50\uff1a" + stringBuilder.toString());
                    LOGGER.info("\u5207\u5206\u7ed3\u679c\uff1a" + list.toString());
                    break;
                }
            }
        }
        catch (Exception exception) {
            WordSegmenter.showUsage();
        }
    }

    private static void run(String string) {
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in, string));){
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                if ("exit".equals(string2)) {
                    System.exit(0);
                    LOGGER.info("\u9000\u51fa");
                    return;
                }
                if (string2.trim().equals("")) continue;
                WordSegmenter.processCommand(string2.split(" "));
                WordSegmenter.showUsage();
            }
        }
        catch (IOException iOException) {
            LOGGER.error("\u7a0b\u5e8f\u4e2d\u65ad\uff1a", (Throwable)iOException);
        }
    }

    private static void showUsage() {
        LOGGER.info("");
        LOGGER.info("********************************************");
        LOGGER.info("\u7528\u6cd5: command [text] [input] [output]");
        LOGGER.info("\u547d\u4ee4command\u7684\u53ef\u9009\u503c\u4e3a\uff1ademo\u3001text\u3001file");
        LOGGER.info("\u547d\u4ee4\u53ef\u4f7f\u7528\u7f29\u5199d t f\uff0c\u5982\u4e0d\u6307\u5b9a\u547d\u4ee4\uff0c\u5219\u9ed8\u8ba4\u4e3atext\u547d\u4ee4\uff0c\u5bf9\u8f93\u5165\u7684\u6587\u672c\u5206\u8bcd");
        LOGGER.info("demo");
        LOGGER.info("text \u6768\u5c1a\u5ddd\u662fAPDPlat\u5e94\u7528\u7ea7\u4ea7\u54c1\u5f00\u53d1\u5e73\u53f0\u7684\u4f5c\u8005");
        LOGGER.info("file d:/text.txt d:/word.txt");
        LOGGER.info("exit");
        LOGGER.info("********************************************");
        LOGGER.info("\u8f93\u5165\u547d\u4ee4\u540e\u56de\u8f66\u786e\u8ba4\uff1a");
    }

    public static void main(String[] stringArray) {
        String string = "utf-8";
        if (stringArray == null || stringArray.length == 0) {
            WordSegmenter.showUsage();
            WordSegmenter.run(string);
        } else if (Charset.isSupported(stringArray[0])) {
            WordSegmenter.showUsage();
            WordSegmenter.run(stringArray[0]);
        } else {
            WordSegmenter.processCommand(stringArray);
            System.exit(0);
        }
    }
}

