/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.filter;

import com.google.common.collect.ImmutableSet;
import jakarta.inject.Singleton;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.PreMatching;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.PathSegment;
import jakarta.ws.rs.core.UriInfo;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Set;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.config.ServerOptions;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

@Provider
@Singleton
@PreMatching
public class PathFilter
implements ContainerRequestFilter {
    private static final Logger LOG = Log.logger(PathFilter.class);
    private static final String GRAPH_SPACE = "graphspaces";
    private static final String ARTHAS_START = "arthas";
    public static final String REQUEST_TIME = "request_time";
    public static final String REQUEST_PARAMS_JSON = "request_params_json";
    private static final String DELIMITER = "/";
    private static final Set<String> WHITE_API_LIST = ImmutableSet.of((Object)"", (Object)"apis", (Object)"metrics", (Object)"versions", (Object)"health", (Object)"gremlin", (Object[])new String[]{"graphs/auth", "graphs/auth/users", "auth/users", "auth/managers", "auth", "hstore", "pd", "kafka", "whiteiplist", "vermeer", "store", "expiredclear", "department", "saas", "trade", "kvstore", "openapi.json"});
    @Context
    private jakarta.inject.Provider<HugeConfig> configProvider;

    public static boolean isWhiteAPI(String rootPath) {
        return WHITE_API_LIST.contains(rootPath);
    }

    public void filter(ContainerRequestContext context) throws IOException {
        context.setProperty(REQUEST_TIME, (Object)System.currentTimeMillis());
        List segments = context.getUriInfo().getPathSegments();
        E.checkArgument((segments.size() > 0 ? 1 : 0) != 0, (String)"Invalid request uri '%s'", (Object[])new Object[]{context.getUriInfo().getPath()});
        String rootPath = ((PathSegment)segments.get(0)).getPath();
        if (PathFilter.isWhiteAPI(rootPath) || GRAPH_SPACE.equals(rootPath) || ARTHAS_START.equals(rootPath)) {
            return;
        }
        UriInfo uriInfo = context.getUriInfo();
        String defaultPathSpace = (String)((HugeConfig)this.configProvider.get()).get(ServerOptions.PATH_GRAPH_SPACE);
        Object path = uriInfo.getBaseUri().getPath() + String.join((CharSequence)DELIMITER, GRAPH_SPACE, defaultPathSpace);
        for (PathSegment segment : segments) {
            path = String.join((CharSequence)DELIMITER, new CharSequence[]{path, segment.getPath()});
        }
        LOG.debug("Redirect request uri from {} to {}", (Object)uriInfo.getRequestUri().getPath(), path);
        URI requestUri = uriInfo.getRequestUriBuilder().uri((String)path).build(new Object[0]);
        context.setRequestUri(uriInfo.getBaseUri(), requestUri);
    }
}

