/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.cypher;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.configuration2.Configuration;
import org.apache.hugegraph.api.cypher.CypherModel;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.apache.tinkerpop.gremlin.driver.Client;
import org.apache.tinkerpop.gremlin.driver.Cluster;
import org.apache.tinkerpop.gremlin.driver.Result;
import org.apache.tinkerpop.gremlin.driver.ResultSet;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.slf4j.Logger;

@ThreadSafe
public final class CypherClient {
    private static final Logger LOG = Log.logger(CypherClient.class);
    private final Supplier<Configuration> configurationSupplier;
    private String userName;
    private String password;
    private String token;

    CypherClient(String userName, String password, Supplier<Configuration> configurationSupplier) {
        this.userName = userName;
        this.password = password;
        this.configurationSupplier = configurationSupplier;
    }

    CypherClient(String token, Supplier<Configuration> configurationSupplier) {
        this.token = token;
        this.configurationSupplier = configurationSupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CypherModel submitQuery(String cypherQuery, @Nullable Map<String, String> aliases) {
        CypherModel res;
        E.checkArgument((cypherQuery != null && !cypherQuery.isEmpty() ? 1 : 0) != 0, (String)"The cypher-query parameter can't be null or empty", (Object[])new Object[0]);
        Cluster cluster = Cluster.open((Configuration)this.getConfig());
        Client client = cluster.connect();
        if (aliases != null && !aliases.isEmpty()) {
            client = client.alias(aliases);
        }
        RequestMessage request = this.createRequest(cypherQuery);
        try {
            List<Object> list = this.doQueryList(client, request);
            res = CypherModel.dataOf(request.getRequestId().toString(), list);
        }
        catch (Exception e) {
            LOG.error(String.format("Failed to submit cypher-query: [ %s ], caused by:", cypherQuery), (Throwable)e);
            res = CypherModel.failOf(request.getRequestId().toString(), e.getMessage());
        }
        finally {
            client.close();
            cluster.close();
        }
        return res;
    }

    private RequestMessage createRequest(String cypherQuery) {
        return RequestMessage.build((String)"eval").processor("cypher").add(new Object[]{"gremlin", cypherQuery}).create();
    }

    private List<Object> doQueryList(Client client, RequestMessage request) throws ExecutionException, InterruptedException {
        ResultSet results = (ResultSet)client.submitAsync(request).get();
        Iterator iter = results.iterator();
        LinkedList<Object> list = new LinkedList<Object>();
        while (iter.hasNext()) {
            Result data = (Result)iter.next();
            list.add(data.getObject());
        }
        return list;
    }

    private Configuration getConfig() {
        Configuration conf = this.configurationSupplier.get();
        conf.addProperty("username", (Object)(this.token == null ? this.userName : this.token));
        conf.addProperty("password", (Object)(this.token == null ? this.password : ""));
        return conf;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CypherClient that = (CypherClient)o;
        return Objects.equals(this.userName, that.userName) && Objects.equals(this.password, that.password) && Objects.equals(this.token, that.token);
    }

    public int hashCode() {
        return Objects.hash(this.userName, this.password, this.token);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("CypherClient{");
        builder.append("userName='").append(this.userName).append('\'').append(", token='").append(this.token).append('\'').append('}');
        return builder.toString();
    }
}

