/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.auth;

import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.NotAuthorizedException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import java.util.Map;
import javax.security.sasl.AuthenticationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.api.filter.StatusFilter;
import org.apache.hugegraph.auth.UserWithRole;
import org.apache.hugegraph.core.GraphManager;
import org.apache.hugegraph.define.Checkable;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

@Path(value="/auth")
@Singleton
@Tag(name="LoginAPI")
public class LoginAPI
extends API {
    private static final Logger LOG = Log.logger(LoginAPI.class);

    @POST
    @Timed
    @Path(value="login")
    @StatusFilter.Status(value=200)
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    public String login(@Context GraphManager manager, JsonLogin jsonLogin) {
        LOG.debug("user login: {}", (Object)jsonLogin);
        LoginAPI.checkCreatingBody(jsonLogin);
        try {
            String token = manager.authManager().loginUser(jsonLogin.name, jsonLogin.password, jsonLogin.expire);
            return manager.serializer().writeMap((Map<?, ?>)ImmutableMap.of((Object)"token", (Object)token));
        }
        catch (AuthenticationException e) {
            throw new NotAuthorizedException(e.getMessage(), (Object)e, new Object[0]);
        }
    }

    @DELETE
    @Timed
    @Path(value="logout")
    @StatusFilter.Status(value=200)
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    public void logout(@Context GraphManager manager, @HeaderParam(value="Authorization") String auth) {
        E.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)auth), (String)"Request header Authorization must not be null", (Object[])new Object[0]);
        LOG.debug("user logout: {}", (Object)auth);
        if (!auth.startsWith("Bearer ")) {
            throw new BadRequestException("Only HTTP Bearer authentication is supported");
        }
        String token = auth.substring("Bearer ".length());
        manager.authManager().logoutUser(token);
    }

    @GET
    @Timed
    @Path(value="verify")
    @StatusFilter.Status(value=200)
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    public String verifyToken(@Context GraphManager manager, @HeaderParam(value="Authorization") String token) {
        E.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)token), (String)"Request header Authorization must not be null", (Object[])new Object[0]);
        LOG.debug("get user: {}", (Object)token);
        if (!token.startsWith("Bearer ")) {
            throw new BadRequestException("Only HTTP Bearer authentication is supported");
        }
        token = token.substring("Bearer ".length());
        UserWithRole userWithRole = manager.authManager().validateUser(token);
        return manager.serializer().writeMap((Map<?, ?>)ImmutableMap.of((Object)"user_name", (Object)userWithRole.username(), (Object)"user_id", (Object)userWithRole.userId()));
    }

    private static class JsonLogin
    implements Checkable {
        @JsonProperty(value="user_name")
        private String name;
        @JsonProperty(value="user_password")
        private String password;
        @JsonProperty(value="token_expire")
        private long expire;

        private JsonLogin() {
        }

        @Override
        public void checkCreate(boolean isBatch) {
            E.checkArgument((!StringUtils.isEmpty((CharSequence)this.name) ? 1 : 0) != 0, (String)"The name of user can't be null", (Object[])new Object[0]);
            E.checkArgument((!StringUtils.isEmpty((CharSequence)this.password) ? 1 : 0) != 0, (String)"The password of user can't be null", (Object[])new Object[0]);
        }

        @Override
        public void checkUpdate() {
        }
    }
}

