/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.node.grpc.query.stages;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.hugegraph.store.business.itrv2.FileObjectIterator;
import org.apache.hugegraph.store.business.itrv2.TypeTransIterator;
import org.apache.hugegraph.store.business.itrv2.io.SortShuffleSerializer;
import org.apache.hugegraph.store.grpc.query.AggregationType;
import org.apache.hugegraph.store.node.grpc.query.QueryStage;
import org.apache.hugegraph.store.node.grpc.query.QueryUtil;
import org.apache.hugegraph.store.node.grpc.query.model.PipelineResult;
import org.apache.hugegraph.store.node.grpc.query.model.PipelineResultType;
import org.apache.hugegraph.store.query.Tuple2;
import org.apache.hugegraph.store.query.func.AggregationFunction;
import org.apache.hugegraph.store.query.func.AggregationFunctions;
import org.apache.hugegraph.store.util.MultiKv;
import org.apache.hugegraph.store.util.SortShuffle;

public class AggStage
implements QueryStage {
    private static final Integer MAP_SIZE = 10000;
    private final Map<List<Object>, List<AggregationFunction>> maps = new ConcurrentHashMap();
    private List<Tuple2<AggregationType, String>> funcMetas = new ArrayList();
    private Integer functionSize;
    private String file;
    private String path;

    public boolean isIterator() {
        return true;
    }

    public void init(Object ... objects) {
        this.funcMetas = (List)objects[0];
        this.functionSize = this.funcMetas.size();
        this.path = SortShuffle.getBasePath() + "agg_tmp_" + Thread.currentThread().getId() + "/";
        new File(this.path).mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<PipelineResult> handleIterator(PipelineResult result) {
        Object kv;
        if (result.getResultType() == PipelineResultType.MKV) {
            kv = result.getKv();
            if (!this.maps.containsKey(kv.getKeys())) {
                this.maps.putIfAbsent(kv.getKeys(), this.generateFunctions());
            }
            for (int i = 0; i < this.functionSize; ++i) {
                AggregationFunction function = (AggregationFunction)((List)this.maps.get(kv.getKeys())).get(i);
                Object value = kv.getValues().get(i);
                if (function instanceof AggregationFunctions.AvgFunction) {
                    AggregationFunctions.AvgFunction avgFunction = (AggregationFunctions.AvgFunction)function;
                    value = this.transValue(avgFunction.getFiledClassType(), value);
                }
                function.iterate(value);
            }
        }
        if (this.maps.size() > MAP_SIZE) {
            kv = this.maps;
            synchronized (kv) {
                if (this.maps.size() > MAP_SIZE) {
                    this.writeToFile(this.changeToList());
                }
            }
        }
        if (result.isEmpty()) {
            List list = this.changeToList();
            if (this.file == null) {
                return new TypeTransIterator(list.iterator(), PipelineResult::new, () -> PipelineResult.EMPTY).toIterator();
            }
            this.writeToFile(list);
            return new TypeTransIterator((Iterator)new FileObjectIterator(this.file, SortShuffleSerializer.ofBackendColumnSerializer()), PipelineResult::new, () -> PipelineResult.EMPTY).toIterator();
        }
        return null;
    }

    private Double transValue(Class clz, Object value) {
        Double retValue = null;
        if (clz.equals(Integer.class)) {
            retValue = (double)((Integer)value);
        } else if (clz.equals(Long.class)) {
            retValue = (double)((Long)value);
        } else if (clz.equals(Double.class)) {
            retValue = (double)((Double)value);
        } else if (clz.equals(Float.class)) {
            retValue = ((Float)value).floatValue();
        } else if (clz.equals(String.class)) {
            retValue = Double.valueOf((String)value);
        }
        return retValue;
    }

    public String getName() {
        return "AGG_STAGE";
    }

    private List<AggregationFunction> generateFunctions() {
        ArrayList<AggregationFunction> result = new ArrayList<AggregationFunction>();
        for (Tuple2 funcMeta : this.funcMetas) {
            result.add(QueryUtil.createFunc((AggregationType)((AggregationType)funcMeta.getV1()), (String)((String)funcMeta.getV2())));
        }
        return result;
    }

    private List<MultiKv> changeToList() {
        ArrayList<MultiKv> result = new ArrayList<MultiKv>();
        for (Map.Entry entry : this.maps.entrySet()) {
            result.add(new MultiKv((List)entry.getKey(), ((List)entry.getValue()).stream().map(x -> x.getBuffer()).collect(Collectors.toList())));
        }
        result.sort(MultiKv::compareTo);
        this.maps.clear();
        return result;
    }

    private void writeToFile(List<MultiKv> list) {
        if (this.file == null) {
            this.file = this.path + System.currentTimeMillis() % 10000L + ".dat";
        }
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(this.file, true));
            for (MultiKv item : list) {
                oos.writeObject(item);
            }
            this.maps.clear();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        this.maps.clear();
        this.funcMetas.clear();
    }
}

