/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.node.grpc.query.model;

import org.apache.hugegraph.rocksdb.access.RocksDBSession;
import org.apache.hugegraph.store.node.grpc.query.model.PipelineResultType;
import org.apache.hugegraph.store.util.MultiKv;
import org.apache.hugegraph.structure.BaseElement;

public class PipelineResult {
    public static final PipelineResult EMPTY = PipelineResult.nullResult();
    private PipelineResultType resultType;
    private RocksDBSession.BackendColumn column;
    private BaseElement element;
    private MultiKv kv;
    private String message;

    public PipelineResult(RocksDBSession.BackendColumn column) {
        this.resultType = PipelineResultType.BACKEND_COLUMN;
        this.column = column;
    }

    public PipelineResult(BaseElement element) {
        this.resultType = PipelineResultType.HG_ELEMENT;
        this.element = element;
    }

    public PipelineResult(MultiKv kv) {
        this.resultType = PipelineResultType.MKV;
        this.kv = kv;
    }

    private PipelineResult() {
        this.resultType = PipelineResultType.NULL;
    }

    private PipelineResult(String message) {
        this.resultType = PipelineResultType.ERROR;
        this.message = message;
    }

    public static PipelineResult nullResult() {
        return new PipelineResult();
    }

    public static PipelineResult ofError(String message) {
        return new PipelineResult(message);
    }

    public boolean isEmpty() {
        return this.resultType == PipelineResultType.NULL;
    }

    public boolean isError() {
        return this.resultType == PipelineResultType.ERROR;
    }

    public PipelineResultType getResultType() {
        return this.resultType;
    }

    public RocksDBSession.BackendColumn getColumn() {
        return this.column;
    }

    public BaseElement getElement() {
        return this.element;
    }

    public MultiKv getKv() {
        return this.kv;
    }

    public String getMessage() {
        return this.message;
    }

    public void setResultType(PipelineResultType resultType) {
        this.resultType = resultType;
    }

    public void setColumn(RocksDBSession.BackendColumn column) {
        this.column = column;
    }

    public void setElement(BaseElement element) {
        this.element = element;
    }

    public void setKv(MultiKv kv) {
        this.kv = kv;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PipelineResult)) {
            return false;
        }
        PipelineResult other = (PipelineResult)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        PipelineResultType this$resultType = this.getResultType();
        PipelineResultType other$resultType = other.getResultType();
        if (this$resultType == null ? other$resultType != null : !this$resultType.equals(other$resultType)) {
            return false;
        }
        RocksDBSession.BackendColumn this$column = this.getColumn();
        RocksDBSession.BackendColumn other$column = other.getColumn();
        if (this$column == null ? other$column != null : !this$column.equals(other$column)) {
            return false;
        }
        BaseElement this$element = this.getElement();
        BaseElement other$element = other.getElement();
        if (this$element == null ? other$element != null : !this$element.equals(other$element)) {
            return false;
        }
        MultiKv this$kv = this.getKv();
        MultiKv other$kv = other.getKv();
        if (this$kv == null ? other$kv != null : !this$kv.equals(other$kv)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PipelineResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PipelineResultType $resultType = this.getResultType();
        result = result * 59 + ($resultType == null ? 43 : $resultType.hashCode());
        RocksDBSession.BackendColumn $column = this.getColumn();
        result = result * 59 + ($column == null ? 43 : $column.hashCode());
        BaseElement $element = this.getElement();
        result = result * 59 + ($element == null ? 43 : $element.hashCode());
        MultiKv $kv = this.getKv();
        result = result * 59 + ($kv == null ? 43 : $kv.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    public String toString() {
        return "PipelineResult(resultType=" + String.valueOf(this.getResultType()) + ", column=" + String.valueOf(this.getColumn()) + ", element=" + String.valueOf(this.getElement()) + ", kv=" + String.valueOf(this.getKv()) + ", message=" + this.getMessage() + ")";
    }
}

