/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.node.grpc;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.hugegraph.store.grpc.common.ScanMethod;
import org.apache.hugegraph.store.grpc.stream.ScanCondition;
import org.apache.hugegraph.store.grpc.stream.ScanQueryRequest;
import org.apache.hugegraph.store.node.grpc.ScanQuery;
import org.apache.hugegraph.store.node.grpc.ScanQueryProducer;
import org.apache.hugegraph.store.node.util.HgAssert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
class ScanQueryProducer
implements Iterable<ScanQuery> {
    private static final Logger log = LoggerFactory.getLogger(ScanQueryProducer.class);
    private String graph;
    private String[] tables;
    private ScanMethod method;
    private int scanType;
    private byte[] query;
    private byte[] position;
    private List<ScanCondition> conditionList;

    private ScanQueryProducer() {
    }

    public static ScanQueryProducer requestOf(String graph, String[] tables, ScanQueryRequest request) {
        HgAssert.isArgumentValid((String)graph, (String)"graph");
        HgAssert.isArgumentNotNull((Object)tables, (String)"tables");
        HgAssert.isArgumentNotNull((Object)request, (String)"ScanQueryRequest");
        ScanQueryProducer res = new ScanQueryProducer();
        res.graph = graph;
        res.tables = tables;
        res.method = request.getMethod();
        res.scanType = request.getScanType();
        res.query = request.getQuery().toByteArray();
        res.position = request.getPosition().toByteArray();
        res.conditionList = request.getConditionList();
        if (res.conditionList == null) {
            res.conditionList = Collections.emptyList();
        }
        if (res.conditionList.isEmpty()) {
            log.warn("the condition-list of ScanQueryRequest is empty.");
        }
        return res;
    }

    private ScanQuery createQuery(String tableName, ScanCondition condition) {
        ScanQuery sq = ScanQuery.of();
        sq.graph = this.graph;
        sq.table = tableName;
        sq.method = this.method;
        sq.scanType = this.scanType;
        sq.query = this.query;
        sq.position = this.position;
        if (condition != null) {
            sq.keyCode = condition.getCode();
            sq.start = condition.getStart().toByteArray();
            sq.end = condition.getEnd().toByteArray();
            sq.prefix = condition.getPrefix().toByteArray();
            sq.serialNo = condition.getSerialNo();
        }
        return sq;
    }

    private String getTableName(int tableIndex) {
        if (tableIndex + 1 > this.tables.length) {
            return null;
        }
        return this.tables[tableIndex];
    }

    @Override
    public Iterator<ScanQuery> iterator() {
        if (this.conditionList.isEmpty()) {
            return new NoConditionsIterator(this);
        }
        return new ConditionsIterator(this);
    }

    public Iterator<ScanQuery[]> groupedIterator() {
        if (this.conditionList.isEmpty()) {
            return new GroupedNoConditionsIterator(this);
        }
        return new GroupedConditionsIterator(this);
    }
}

