/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.node.grpc;

import com.alipay.sofa.jraft.util.Utils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.apache.hugegraph.pd.common.KVPair;
import org.apache.hugegraph.rocksdb.access.ScanIterator;
import org.apache.hugegraph.store.grpc.common.ScanOrderType;
import org.apache.hugegraph.store.grpc.stream.ScanQueryRequest;
import org.apache.hugegraph.store.node.grpc.ParallelScanIterator;
import org.apache.hugegraph.store.node.grpc.QueryCondition;
import org.apache.hugegraph.store.node.util.HgAssert;
import org.apache.hugegraph.store.node.util.PropertyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelScanIterator
implements ScanIterator {
    private static final Logger log = LoggerFactory.getLogger(ParallelScanIterator.class);
    private static final int waitDataMaxTryTimes = 600;
    protected static int maxBodySize = PropertyUtil.getInt((String)"app.scan.stream.body.size", (int)0x100000);
    private final int batchSize = PropertyUtil.getInt((String)"app.scan.stream.entries.size", (int)20000);
    private final Supplier<KVPair<QueryCondition, ScanIterator>> batchSupplier;
    private final Supplier<Long> limitSupplier;
    private final BlockingQueue<List<KV>> queue;
    private final ReentrantLock queueLock = new ReentrantLock();
    private final ThreadPoolExecutor executor;
    private final ScanQueryRequest query;
    private final Queue<KVScanner> scanners = new LinkedList();
    private final Queue<KVScanner> pauseScanners = new LinkedList();
    private final List<KV> NO_DATA = new ArrayList();
    private final boolean orderVertex;
    private final boolean orderEdge;
    private int maxWorkThreads = Utils.cpus() / 8;
    private int maxInQueue = this.maxWorkThreads * 2;
    private volatile boolean finished;
    private List<KV> current = null;

    private ParallelScanIterator(Supplier<KVPair<QueryCondition, ScanIterator>> iteratorSupplier, Supplier<Long> limitSupplier, ScanQueryRequest query, ThreadPoolExecutor executor) {
        this.executor = executor;
        this.batchSupplier = iteratorSupplier;
        this.limitSupplier = limitSupplier;
        this.finished = false;
        this.query = query;
        this.orderVertex = query.getOrderType() == ScanOrderType.ORDER_STRICT;
        this.orderEdge = query.getOrderType() == ScanOrderType.ORDER_WITHIN_VERTEX;
        this.maxWorkThreads = this.orderVertex ? 1 : Math.max(1, Math.min(query.getConditionCount() / 16, this.maxWorkThreads));
        this.maxInQueue = this.maxWorkThreads * 2;
        this.queue = new LinkedBlockingQueue(this.maxInQueue * 2);
        this.createScanner();
    }

    public static ParallelScanIterator of(Supplier<KVPair<QueryCondition, ScanIterator>> iteratorSupplier, Supplier<Long> limitSupplier, ScanQueryRequest query, ThreadPoolExecutor executor) {
        HgAssert.isArgumentNotNull(iteratorSupplier, (String)"iteratorSupplier");
        HgAssert.isArgumentNotNull(limitSupplier, (String)"limitSupplier");
        return new ParallelScanIterator(iteratorSupplier, limitSupplier, query, executor);
    }

    public boolean hasNext() {
        int tryTimes;
        for (tryTimes = 0; this.current == null && tryTimes < 600; ++tryTimes) {
            try {
                if (this.queue.size() == 0 && this.finished) break;
                this.current = (List)this.queue.poll(100L, TimeUnit.MILLISECONDS);
                if (this.current != null || this.finished) continue;
                this.wakeUpScanner();
                continue;
            }
            catch (InterruptedException e) {
                log.error("hasNext interrupted {}", (Throwable)e);
                break;
            }
        }
        if (this.current == null && tryTimes >= 600) {
            log.error("Wait data timeout!!!, scanner is {}/{}", (Object)this.scanners.size(), (Object)this.pauseScanners.size());
        }
        return this.current != null && this.current != this.NO_DATA;
    }

    public boolean isValid() {
        throw new UnsupportedOperationException();
    }

    public List<KV> next() {
        List t = this.current;
        this.current = null;
        if (this.queue.size() < this.maxWorkThreads) {
            this.wakeUpScanner();
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.finished = true;
        Queue queue = this.scanners;
        synchronized (queue) {
            this.scanners.forEach(scanner -> scanner.close());
        }
        queue = this.pauseScanners;
        synchronized (queue) {
            this.pauseScanners.forEach(s -> s.close());
        }
        this.queue.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createScanner() {
        Queue queue = this.scanners;
        synchronized (queue) {
            for (int i = 0; i < this.maxWorkThreads; ++i) {
                this.scanners.add(new KVScanner(this));
            }
            this.scanners.forEach(scanner -> this.executor.execute(() -> scanner.scanKV()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeUpScanner() {
        Queue queue = this.pauseScanners;
        synchronized (queue) {
            KVScanner scanner;
            if (!this.pauseScanners.isEmpty() && (scanner = (KVScanner)this.pauseScanners.poll()) != null) {
                this.executor.execute(() -> scanner.scanKV());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void suspendScanner(KVScanner scanner) {
        Queue queue = this.pauseScanners;
        synchronized (queue) {
            this.pauseScanners.add(scanner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void quitScanner(KVScanner scanner) {
        Queue queue = this.scanners;
        synchronized (queue) {
            scanner.close();
            this.scanners.remove(scanner);
            if (this.scanners.size() == 0) {
                this.putData(this.NO_DATA);
                this.finished = true;
            }
        }
    }

    private boolean putData(List<KV> data) {
        try {
            this.queue.put(data);
        }
        catch (InterruptedException e) {
            log.error("exception ", (Throwable)e);
            this.finished = true;
            return false;
        }
        return this.queue.size() < this.maxInQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean putData(List<KV> data, boolean hasNext) {
        try {
            this.queueLock.lock();
            this.queue.put(data);
        }
        catch (InterruptedException e) {
            log.error("exception ", (Throwable)e);
            this.finished = true;
            boolean bl = false;
            return bl;
        }
        finally {
            if (!hasNext) {
                this.queueLock.unlock();
            }
        }
        return hasNext || this.queue.size() < this.maxInQueue;
    }

    private synchronized KVPair<QueryCondition, ScanIterator> getIterator() {
        return (KVPair)this.batchSupplier.get();
    }

    private long getLimit() {
        Long limit = (Long)this.limitSupplier.get();
        if (limit == null || limit <= 0L) {
            limit = Integer.MAX_VALUE;
        }
        return limit;
    }
}

