/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.traversal.optimize;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hugegraph.HugeException;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.backend.BackendException;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.page.PageInfo;
import org.apache.hugegraph.backend.page.PageState;
import org.apache.hugegraph.backend.query.Aggregate;
import org.apache.hugegraph.backend.query.Condition;
import org.apache.hugegraph.backend.query.ConditionQuery;
import org.apache.hugegraph.backend.query.Query;
import org.apache.hugegraph.exception.NotSupportException;
import org.apache.hugegraph.iterator.FilterIterator;
import org.apache.hugegraph.schema.PropertyKey;
import org.apache.hugegraph.schema.SchemaLabel;
import org.apache.hugegraph.structure.HugeElement;
import org.apache.hugegraph.structure.HugeProperty;
import org.apache.hugegraph.traversal.optimize.ConditionP;
import org.apache.hugegraph.traversal.optimize.HugeGraphStep;
import org.apache.hugegraph.traversal.optimize.HugeVertexStep;
import org.apache.hugegraph.traversal.optimize.QueryHolder;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.type.define.Directions;
import org.apache.hugegraph.type.define.HugeKeys;
import org.apache.hugegraph.util.CollectionUtil;
import org.apache.hugegraph.util.DateUtil;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.JsonUtil;
import org.apache.tinkerpop.gremlin.process.traversal.Compare;
import org.apache.tinkerpop.gremlin.process.traversal.Contains;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.HasContainerHolder;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.FilterStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.HasStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.RangeGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.CountGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.MaxGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.MeanGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.MinGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.NoOpBarrierStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.OrderGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.PropertiesStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.SumGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.IdentityStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.ElementValueComparator;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.ReducingBarrierStep;
import org.apache.tinkerpop.gremlin.process.traversal.util.AndP;
import org.apache.tinkerpop.gremlin.process.traversal.util.ConnectiveP;
import org.apache.tinkerpop.gremlin.process.traversal.util.OrP;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.PropertyType;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.empty.EmptyGraph;

public final class TraversalUtil {
    public static final String P_CALL = "P.";

    public static HugeGraph getGraph(Step<?, ?> step) {
        HugeGraph graph = TraversalUtil.tryGetGraph(step);
        if (graph != null) {
            return graph;
        }
        throw new IllegalArgumentException("There is no graph in step: " + String.valueOf(step));
    }

    public static HugeGraph tryGetGraph(Step<?, ?> step) {
        Optional<Graph> graph = step.getTraversal().getGraph().filter(g -> !(g instanceof EmptyGraph));
        if (!graph.isPresent()) {
            Optional<Graph> parentGraph;
            TraversalParent parent = step.getTraversal().getParent();
            if (parent instanceof Traversal && (parentGraph = ((Traversal)parent).asAdmin().getGraph().filter(g -> !(g instanceof EmptyGraph))).isPresent()) {
                step.getTraversal().setGraph(parentGraph.get());
                return (HugeGraph)parentGraph.get();
            }
            return null;
        }
        assert (graph.get() instanceof HugeGraph);
        return (HugeGraph)graph.get();
    }

    public static void trySetGraph(Step<?, ?> step, HugeGraph graph) {
        if (graph == null || step == null || step.getTraversal() == null) {
            return;
        }
        Optional<Graph> stepGraph = step.getTraversal().getGraph().filter(g -> !(g instanceof EmptyGraph));
        if (step instanceof TraversalParent) {
            for (Traversal.Admin local : ((TraversalParent)step).getLocalChildren()) {
                if (local.getGraph().filter(g -> !(g instanceof EmptyGraph)).isPresent()) continue;
                local.setGraph((Graph)graph);
            }
            for (Traversal.Admin global : ((TraversalParent)step).getGlobalChildren()) {
                if (global.getGraph().filter(g -> !(g instanceof EmptyGraph)).isPresent()) continue;
                global.setGraph((Graph)graph);
            }
        }
        if (stepGraph.isPresent()) {
            assert (stepGraph.get() instanceof HugeGraph);
            return;
        }
        step.getTraversal().setGraph((Graph)graph);
    }

    public static void extractHasContainer(HugeGraphStep<?, ?> newStep, Traversal.Admin<?, ?> traversal) {
        Step step = newStep;
        do {
            if (!((step = step.getNextStep()) instanceof HasStep)) continue;
            HasContainerHolder holder = (HasContainerHolder)step;
            for (HasContainer has : holder.getHasContainers()) {
                if (GraphStep.processHasContainerIds((GraphStep)newStep, (HasContainer)has)) continue;
                newStep.addHasContainer(has);
            }
            TraversalHelper.copyLabels((Step)step, (Step)step.getPreviousStep(), (boolean)false);
            traversal.removeStep(step);
        } while (step instanceof HasStep || step instanceof NoOpBarrierStep);
    }

    public static void extractHasContainer(HugeVertexStep<?> newStep, Traversal.Admin<?, ?> traversal) {
        Step step = newStep;
        do {
            if (!(step instanceof HasStep)) continue;
            HasContainerHolder holder = (HasContainerHolder)step;
            for (HasContainer has : holder.getHasContainers()) {
                newStep.addHasContainer(has);
            }
            TraversalHelper.copyLabels((Step)step, (Step)step.getPreviousStep(), (boolean)false);
            traversal.removeStep(step);
        } while ((step = step.getNextStep()) instanceof HasStep || step instanceof NoOpBarrierStep);
    }

    public static void extractOrder(Step<?, ?> newStep, Traversal.Admin<?, ?> traversal) {
        Step step = newStep;
        do {
            if (!((step = step.getNextStep()) instanceof OrderGlobalStep)) continue;
            QueryHolder holder = (QueryHolder)newStep;
            OrderGlobalStep orderStep = (OrderGlobalStep)step;
            orderStep.getComparators().forEach(comp -> {
                ElementValueComparator comparator = (ElementValueComparator)comp.getValue1();
                holder.orderBy(comparator.getPropertyKey(), (Order)comparator.getValueComparator());
            });
            TraversalHelper.copyLabels((Step)step, (Step)newStep, (boolean)false);
            traversal.removeStep(step);
        } while ((step = step.getNextStep()) instanceof OrderGlobalStep || step instanceof IdentityStep);
    }

    public static void extractRange(Step<?, ?> newStep, Traversal.Admin<?, ?> traversal, boolean extractOnlyLimit) {
        QueryHolder holder = (QueryHolder)newStep;
        Step step = newStep;
        do {
            if (!((step = step.getNextStep()) instanceof RangeGlobalStep)) continue;
            RangeGlobalStep range = (RangeGlobalStep)step;
            if (extractOnlyLimit) {
                holder.setRange(0L, range.getHighRange());
                continue;
            }
            long limit = holder.setRange(range.getLowRange(), range.getHighRange());
            RangeGlobalStep newRange = new RangeGlobalStep(traversal, 0L, limit);
            TraversalHelper.replaceStep((Step)range, (Step)newRange, traversal);
        } while (step instanceof RangeGlobalStep || step instanceof IdentityStep || step instanceof NoOpBarrierStep);
    }

    public static void extractCount(Step<?, ?> newStep, Traversal.Admin<?, ?> traversal) {
        Step step = newStep;
        do {
            if (!((step = step.getNextStep()) instanceof CountGlobalStep)) continue;
            QueryHolder holder = (QueryHolder)newStep;
            holder.setCount();
        } while (step instanceof CountGlobalStep || step instanceof FilterStep || step instanceof IdentityStep || step instanceof NoOpBarrierStep);
    }

    public static void extractAggregateFunc(Step<?, ?> newStep, Traversal.Admin<?, ?> traversal) {
        PropertiesStep propertiesStep = null;
        Step step = newStep;
        do {
            Aggregate.AggregateFunc aggregateFunc;
            if ((step = step.getNextStep()) instanceof PropertiesStep) {
                PropertiesStep propStep = (PropertiesStep)step;
                if (propStep.getReturnType() != PropertyType.VALUE || propStep.getPropertyKeys().length != 1) continue;
                propertiesStep = propStep;
                continue;
            }
            if (propertiesStep == null || !(step instanceof ReducingBarrierStep) || (aggregateFunc = step instanceof CountGlobalStep ? Aggregate.AggregateFunc.COUNT : (step instanceof MaxGlobalStep ? Aggregate.AggregateFunc.MAX : (step instanceof MinGlobalStep ? Aggregate.AggregateFunc.MIN : (step instanceof MeanGlobalStep ? Aggregate.AggregateFunc.AVG : (step instanceof SumGlobalStep ? Aggregate.AggregateFunc.SUM : null))))) == null) continue;
            QueryHolder holder = (QueryHolder)newStep;
            holder.setAggregate(aggregateFunc, propertiesStep.getPropertyKeys()[0]);
            traversal.removeStep(step);
            traversal.removeStep((Step)propertiesStep);
        } while (step instanceof FilterStep || step instanceof PropertiesStep || step instanceof IdentityStep || step instanceof NoOpBarrierStep);
    }

    public static ConditionQuery fillConditionQuery(ConditionQuery query, List<HasContainer> hasContainers, HugeGraph graph) {
        HugeType resultType = query.resultType();
        for (HasContainer has : hasContainers) {
            Condition condition = TraversalUtil.convHas2Condition(has, resultType, graph);
            query.query(condition);
        }
        return query;
    }

    public static void fillConditionQuery(ConditionQuery query, Map<Id, Object> properties, HugeGraph graph) {
        for (Map.Entry<Id, Object> entry : properties.entrySet()) {
            Id key = entry.getKey();
            Object value = entry.getValue();
            PropertyKey pk = graph.propertyKey(key);
            if (value instanceof String && ((String)value).startsWith(P_CALL)) {
                String predicate = (String)value;
                query.query(TraversalUtil.parsePredicate(pk, predicate));
                continue;
            }
            if (value instanceof Collection) {
                ArrayList validValues = new ArrayList();
                for (Object v : (Collection)value) {
                    validValues.add(TraversalUtil.validPropertyValue(v, pk));
                }
                query.query(Condition.in(key, validValues));
                continue;
            }
            Object validValue = TraversalUtil.validPropertyValue(value, pk);
            query.query(Condition.eq(key, validValue));
        }
    }

    public static Condition convHas2Condition(HasContainer has, HugeType type, HugeGraph graph) {
        Condition condition;
        P p = has.getPredicate();
        E.checkArgument((p != null ? 1 : 0) != 0, (String)"The predicate of has(%s) is null", (Object[])new Object[]{has});
        BiPredicate bp = p.getBiPredicate();
        if (TraversalUtil.keyForContainsKeyOrValue(has.getKey())) {
            condition = TraversalUtil.convContains2Relation(graph, has);
        } else if (bp instanceof Compare) {
            condition = TraversalUtil.convCompare2Relation(graph, type, has);
        } else if (bp instanceof Condition.RelationType) {
            condition = TraversalUtil.convRelationType2Relation(graph, type, has);
        } else if (bp instanceof Contains) {
            condition = TraversalUtil.convIn2Relation(graph, type, has);
        } else if (p instanceof AndP) {
            condition = TraversalUtil.convAnd(graph, type, has);
        } else if (p instanceof OrP) {
            condition = TraversalUtil.convOr(graph, type, has);
        } else {
            throw TraversalUtil.newUnsupportedPredicate(p);
        }
        return condition;
    }

    public static Condition convAnd(HugeGraph graph, HugeType type, HasContainer has) {
        P p = has.getPredicate();
        assert (p instanceof AndP);
        List predicates = ((AndP)p).getPredicates();
        if (predicates.size() < 2) {
            throw TraversalUtil.newUnsupportedPredicate(p);
        }
        Condition cond = null;
        for (P predicate : predicates) {
            HasContainer newHas = new HasContainer(has.getKey(), predicate);
            Condition newCond = TraversalUtil.convHas2Condition(newHas, type, graph);
            if (cond == null) {
                cond = newCond;
                continue;
            }
            cond = Condition.and(newCond, cond);
        }
        return cond;
    }

    public static Condition convOr(HugeGraph graph, HugeType type, HasContainer has) {
        P p = has.getPredicate();
        assert (p instanceof OrP);
        List predicates = ((OrP)p).getPredicates();
        if (predicates.size() < 2) {
            throw TraversalUtil.newUnsupportedPredicate(p);
        }
        Condition cond = null;
        for (P predicate : predicates) {
            HasContainer newHas = new HasContainer(has.getKey(), predicate);
            Condition newCond = TraversalUtil.convHas2Condition(newHas, type, graph);
            if (cond == null) {
                cond = newCond;
                continue;
            }
            cond = Condition.or(newCond, cond);
        }
        return cond;
    }

    private static Condition.Relation convCompare2Relation(HugeGraph graph, HugeType type, HasContainer has) {
        assert (type.isGraph());
        BiPredicate bp = has.getPredicate().getBiPredicate();
        assert (bp instanceof Compare);
        return TraversalUtil.isSysProp(has.getKey()) ? TraversalUtil.convCompare2SyspropRelation(graph, type, has) : TraversalUtil.convCompare2UserpropRelation(graph, type, has);
    }

    private static Condition.Relation convCompare2SyspropRelation(HugeGraph graph, HugeType type, HasContainer has) {
        BiPredicate bp = has.getPredicate().getBiPredicate();
        assert (bp instanceof Compare);
        HugeKeys key = TraversalUtil.token2HugeKey(has.getKey());
        E.checkNotNull((Object)((Object)key), (String)"token key");
        Object value = TraversalUtil.convSysValueIfNeeded(graph, type, key, has.getValue());
        switch ((Compare)bp) {
            case eq: {
                return Condition.eq(key, value);
            }
            case gt: {
                return Condition.gt(key, value);
            }
            case gte: {
                return Condition.gte(key, value);
            }
            case lt: {
                return Condition.lt(key, value);
            }
            case lte: {
                return Condition.lte(key, value);
            }
            case neq: {
                return Condition.neq(key, value);
            }
        }
        throw TraversalUtil.newUnsupportedPredicate(has.getPredicate());
    }

    private static Condition.Relation convCompare2UserpropRelation(HugeGraph graph, HugeType type, HasContainer has) {
        BiPredicate bp = has.getPredicate().getBiPredicate();
        assert (bp instanceof Compare);
        String key = has.getKey();
        PropertyKey pkey = graph.propertyKey(key);
        Id pkeyId = pkey.id();
        Object value = TraversalUtil.validPropertyValue(has.getValue(), pkey);
        switch ((Compare)bp) {
            case eq: {
                return Condition.eq(pkeyId, value);
            }
            case gt: {
                return Condition.gt(pkeyId, value);
            }
            case gte: {
                return Condition.gte(pkeyId, value);
            }
            case lt: {
                return Condition.lt(pkeyId, value);
            }
            case lte: {
                return Condition.lte(pkeyId, value);
            }
            case neq: {
                return Condition.neq(pkeyId, value);
            }
        }
        throw TraversalUtil.newUnsupportedPredicate(has.getPredicate());
    }

    private static Condition convRelationType2Relation(HugeGraph graph, HugeType type, HasContainer has) {
        assert (type.isGraph());
        BiPredicate bp = has.getPredicate().getBiPredicate();
        assert (bp instanceof Condition.RelationType);
        String key = has.getKey();
        PropertyKey pkey = graph.propertyKey(key);
        Id pkeyId = pkey.id();
        Object value = TraversalUtil.validPropertyValue(has.getValue(), pkey);
        return new Condition.UserpropRelation(pkeyId, (Condition.RelationType)bp, value);
    }

    public static Condition convIn2Relation(HugeGraph graph, HugeType type, HasContainer has) {
        HugeKeys hugeKey;
        BiPredicate bp = has.getPredicate().getBiPredicate();
        assert (bp instanceof Contains);
        Collection values = (Collection)has.getValue();
        String originKey = has.getKey();
        if (values.size() > 1) {
            E.checkArgument((!originKey.equals(T.key.getAccessor()) && !originKey.equals(T.value.getAccessor()) ? 1 : 0) != 0, (String)"Not support hasKey() or hasValue() with multiple values", (Object[])new Object[0]);
        }
        if ((hugeKey = TraversalUtil.token2HugeKey(originKey)) != null) {
            List<?> valueList = TraversalUtil.convSysListValueIfNeeded(graph, type, hugeKey, values);
            switch ((Contains)bp) {
                case within: {
                    return Condition.in(hugeKey, valueList);
                }
                case without: {
                    return Condition.nin(hugeKey, valueList);
                }
            }
            throw TraversalUtil.newUnsupportedPredicate(has.getPredicate());
        }
        ArrayList valueList = new ArrayList(values);
        String key = has.getKey();
        PropertyKey pkey = graph.propertyKey(key);
        switch ((Contains)bp) {
            case within: {
                return Condition.in(pkey.id(), valueList);
            }
            case without: {
                return Condition.nin(pkey.id(), valueList);
            }
        }
        throw TraversalUtil.newUnsupportedPredicate(has.getPredicate());
    }

    public static Condition convContains2Relation(HugeGraph graph, HasContainer has) {
        BiPredicate bp = has.getPredicate().getBiPredicate();
        E.checkArgument((bp == Compare.eq ? 1 : 0) != 0, (String)"CONTAINS query with relation '%s' is not supported", (Object[])new Object[]{bp});
        HugeKeys key = TraversalUtil.token2HugeKey(has.getKey());
        E.checkNotNull((Object)((Object)key), (String)"token key");
        Object value = has.getValue();
        if (TraversalUtil.keyForContainsKey(has.getKey())) {
            if (value instanceof String) {
                value = graph.propertyKey((String)value).id();
            }
            return Condition.containsKey(key, value);
        }
        assert (TraversalUtil.keyForContainsValue(has.getKey()));
        return Condition.containsValue(key, value);
    }

    public static BackendException newUnsupportedPredicate(P<?> predicate) {
        return new BackendException("Unsupported predicate: '%s'", predicate);
    }

    public static HugeKeys string2HugeKey(String key) {
        HugeKeys hugeKey = TraversalUtil.token2HugeKey(key);
        return hugeKey != null ? hugeKey : HugeKeys.valueOf(key);
    }

    public static HugeKeys token2HugeKey(String key) {
        if (key.equals(T.label.getAccessor())) {
            return HugeKeys.LABEL;
        }
        if (key.equals(T.id.getAccessor())) {
            return HugeKeys.ID;
        }
        if (TraversalUtil.keyForContainsKeyOrValue(key)) {
            return HugeKeys.PROPERTIES;
        }
        return null;
    }

    public static boolean keyForContainsKeyOrValue(String key) {
        return key.equals(T.key.getAccessor()) || key.equals(T.value.getAccessor());
    }

    public static boolean keyForContainsKey(String key) {
        return key.equals(T.key.getAccessor());
    }

    public static boolean keyForContainsValue(String key) {
        return key.equals(T.value.getAccessor());
    }

    public static <V> Iterator<V> filterResult(List<HasContainer> hasContainers, Iterator<? extends Element> iterator) {
        if (hasContainers.isEmpty()) {
            return iterator;
        }
        FilterIterator result = new FilterIterator(iterator, elem -> HasContainer.testAll((Element)elem, (List)hasContainers));
        return result;
    }

    public static Iterator<Edge> filterResult(Vertex vertex, Directions dir, Iterator<Edge> edges) {
        return new FilterIterator(edges, edge -> dir == Directions.OUT && vertex.equals(edge.outVertex()) || dir == Directions.IN && vertex.equals(edge.inVertex()));
    }

    public static void convAllHasSteps(Traversal.Admin<?, ?> traversal) {
        List steps = TraversalHelper.getStepsOfAssignableClassRecursively(HasStep.class, traversal);
        if (steps.isEmpty()) {
            return;
        }
        if (!traversal.getGraph().filter(g -> !(g instanceof EmptyGraph)).isPresent()) {
            if (traversal.getParent() == null || !(traversal.getParent() instanceof Traversal)) {
                return;
            }
            Optional parentGraph = ((Traversal)traversal.getParent()).asAdmin().getGraph();
            if (parentGraph.filter(g -> !(g instanceof EmptyGraph)).isPresent()) {
                traversal.setGraph((Graph)parentGraph.get());
            }
        }
        HugeGraph graph = (HugeGraph)traversal.getGraph().get();
        for (HasStep step : steps) {
            TraversalUtil.convHasStep(graph, step);
        }
    }

    public static void convHasStep(HugeGraph graph, HasStep<?> step) {
        HasStep<?> holder = step;
        for (HasContainer has : holder.getHasContainers()) {
            TraversalUtil.convPredicateValue(graph, has);
        }
    }

    private static void convPredicateValue(HugeGraph graph, HasContainer has) {
        if (TraversalUtil.isSysProp(has.getKey())) {
            return;
        }
        PropertyKey pkey = graph.propertyKey(has.getKey());
        TraversalUtil.updatePredicateValue(has.getPredicate(), pkey);
    }

    private static void updatePredicateValue(P<?> predicate, PropertyKey pkey) {
        ArrayList<P<Object>> leafPredicates = new ArrayList<P<Object>>();
        TraversalUtil.collectPredicates(leafPredicates, ImmutableList.of(predicate));
        for (P p : leafPredicates) {
            Object value = TraversalUtil.validPropertyValue(p.getValue(), pkey);
            p.setValue(value);
        }
    }

    private static boolean isSysProp(String key) {
        if ("~page".equals(key)) {
            return true;
        }
        return TraversalUtil.token2HugeKey(key) != null;
    }

    private static void collectPredicates(List<P<Object>> results, List<P<?>> predicates) {
        for (P<?> p : predicates) {
            if (p instanceof ConnectiveP) {
                TraversalUtil.collectPredicates(results, ((ConnectiveP)p).getPredicates());
                continue;
            }
            results.add(p);
        }
    }

    private static Object convSysValueIfNeeded(HugeGraph graph, HugeType type, HugeKeys key, Object value) {
        if (key == HugeKeys.LABEL && !(value instanceof Id)) {
            value = SchemaLabel.getLabelId(graph, type, value);
        } else if (key == HugeKeys.ID && !(value instanceof Id)) {
            value = HugeElement.getIdValue(type, value);
        }
        return value;
    }

    private static List<?> convSysListValueIfNeeded(HugeGraph graph, HugeType type, HugeKeys key, Collection<?> values) {
        ArrayList<Object> newValues = new ArrayList<Object>(values.size());
        for (Object value : values) {
            newValues.add(TraversalUtil.convSysValueIfNeeded(graph, type, key, value));
        }
        return newValues;
    }

    public static Query.Order convOrder(Order order) {
        return order == Order.desc ? Query.Order.DESC : Query.Order.ASC;
    }

    private static <V> V validPropertyValue(V value, PropertyKey pkey) {
        V validValue;
        if (pkey.cardinality().single() && value instanceof Collection && !pkey.dataType().isBlob()) {
            Collection collection = (Collection)value;
            ArrayList validValues = new ArrayList();
            for (Object element : collection) {
                Object validValue2 = pkey.validValue(element);
                if (validValue2 == null) {
                    validValues = null;
                    break;
                }
                validValues.add(validValue2);
            }
            if (validValues == null) {
                ArrayList classes = new ArrayList();
                for (Object v : (Collection)value) {
                    classes.add(v == null ? null : v.getClass());
                }
                E.checkArgument((boolean)false, (String)"Invalid data type of query value in %s, expect %s for '%s', actual got %s", (Object[])new Object[]{value, pkey.dataType(), pkey.name(), classes});
            }
            ArrayList validValue3 = validValues;
            return (V)validValue3;
        }
        if (pkey.cardinality().multiple() && !(value instanceof Collection)) {
            List values = CollectionUtil.toList(value);
            validValue = (values = pkey.validValue(values)) != null ? values.get(0) : null;
        } else {
            validValue = pkey.validValue(value);
        }
        if (validValue == null) {
            E.checkArgument((boolean)false, (String)"Invalid data type of query value '%s', expect %s for '%s', actual got %s", (Object[])new Object[]{value, pkey.dataType(), pkey.name(), value == null ? null : value.getClass()});
        }
        return validValue;
    }

    public static void retrieveSysprop(List<HasContainer> hasContainers, Function<HasContainer, Boolean> func) {
        Iterator<HasContainer> iter = hasContainers.iterator();
        while (iter.hasNext()) {
            HasContainer container = iter.next();
            if (!container.getKey().startsWith("~") || !func.apply(container).booleanValue()) continue;
            iter.remove();
        }
    }

    public static String page(GraphTraversal<?, ?> traversal) {
        QueryHolder holder = TraversalUtil.firstPageStep(traversal);
        E.checkState((holder != null ? 1 : 0) != 0, (String)"Invalid paging traversal: %s", (Object[])new Object[]{traversal.getClass()});
        Object page = holder.metadata("page", new Object[0]);
        if (page == null) {
            return null;
        }
        assert (page instanceof PageInfo || page instanceof PageState);
        return page.toString();
    }

    public static QueryHolder rootStep(GraphTraversal<?, ?> traversal) {
        for (Step step : traversal.asAdmin().getSteps()) {
            if (!(step instanceof QueryHolder)) continue;
            return (QueryHolder)step;
        }
        return null;
    }

    public static QueryHolder firstPageStep(GraphTraversal<?, ?> traversal) {
        for (Step step : traversal.asAdmin().getSteps()) {
            if (!(step instanceof QueryHolder) || !((QueryHolder)step).queryInfo().paging()) continue;
            return (QueryHolder)step;
        }
        return null;
    }

    public static boolean testProperty(Property<?> prop, Object expected) {
        Object actual = prop.value();
        P<Object> predicate = expected instanceof String && ((String)expected).startsWith(P_CALL) ? TraversalUtil.parsePredicate((String)expected) : ConditionP.eq(expected);
        TraversalUtil.updatePredicateValue(predicate, ((HugeProperty)prop).propertyKey());
        return predicate.test(actual);
    }

    public static Map<Id, Object> transProperties(HugeGraph graph, Map<String, Object> props) {
        HashMap<Id, Object> pks = new HashMap<Id, Object>(props.size());
        for (Map.Entry<String, Object> e : props.entrySet()) {
            PropertyKey pk = graph.propertyKey(e.getKey());
            pks.put(pk.id(), e.getValue());
        }
        return pks;
    }

    public static P<Object> parsePredicate(String predicate) {
        Pattern pattern = Pattern.compile("^P\\.([a-z]+)\\(([\\S ]*)\\)$");
        Matcher matcher = pattern.matcher(predicate);
        if (!matcher.find()) {
            throw new HugeException("Invalid predicate: %s", predicate);
        }
        String method = matcher.group(1);
        String value = matcher.group(2);
        switch (method) {
            case "eq": {
                return P.eq((Object)TraversalUtil.predicateNumber(value));
            }
            case "neq": {
                return P.neq((Object)TraversalUtil.predicateNumber(value));
            }
            case "lt": {
                return P.lt((Object)TraversalUtil.predicateNumber(value));
            }
            case "lte": {
                return P.lte((Object)TraversalUtil.predicateNumber(value));
            }
            case "gt": {
                return P.gt((Object)TraversalUtil.predicateNumber(value));
            }
            case "gte": {
                return P.gte((Object)TraversalUtil.predicateNumber(value));
            }
            case "between": {
                Number[] params = TraversalUtil.predicateNumbers(value, 2);
                return P.between((Object)params[0], (Object)params[1]);
            }
            case "inside": {
                Number[] params = TraversalUtil.predicateNumbers(value, 2);
                return P.inside((Object)params[0], (Object)params[1]);
            }
            case "outside": {
                Number[] params = TraversalUtil.predicateNumbers(value, 2);
                return P.outside((Object)params[0], (Object)params[1]);
            }
            case "within": {
                return P.within(TraversalUtil.predicateArgs(value));
            }
            case "textcontains": {
                return ConditionP.textContains(TraversalUtil.predicateArg(value));
            }
            case "contains": {
                return ConditionP.contains(TraversalUtil.predicateArg(value));
            }
        }
        throw new NotSupportException("predicate '%s'", method);
    }

    public static Condition parsePredicate(PropertyKey pk, String predicate) {
        Pattern pattern = Pattern.compile("^P\\.([a-z]+)\\(([\\S ]*)\\)$");
        Matcher matcher = pattern.matcher(predicate);
        if (!matcher.find()) {
            throw new HugeException("Invalid predicate: %s", predicate);
        }
        String method = matcher.group(1);
        String value = matcher.group(2);
        switch (method) {
            case "eq": {
                Number validValue = TraversalUtil.validPropertyValue(TraversalUtil.predicateNumber(value), pk);
                return Condition.eq(pk.id(), (Object)validValue);
            }
            case "neq": {
                Number validValue = TraversalUtil.validPropertyValue(TraversalUtil.predicateNumber(value), pk);
                return Condition.neq(pk.id(), (Object)validValue);
            }
            case "lt": {
                Number validValue = TraversalUtil.validPropertyValue(TraversalUtil.predicateNumber(value), pk);
                return Condition.lt(pk.id(), (Object)validValue);
            }
            case "lte": {
                Number validValue = TraversalUtil.validPropertyValue(TraversalUtil.predicateNumber(value), pk);
                return Condition.lte(pk.id(), (Object)validValue);
            }
            case "gt": {
                Number validValue = TraversalUtil.validPropertyValue(TraversalUtil.predicateNumber(value), pk);
                return Condition.gt(pk.id(), (Object)validValue);
            }
            case "gte": {
                Number validValue = TraversalUtil.validPropertyValue(TraversalUtil.predicateNumber(value), pk);
                return Condition.gte(pk.id(), (Object)validValue);
            }
            case "between": {
                Number[] params = TraversalUtil.predicateNumbers(value, 2);
                Number v1 = TraversalUtil.validPropertyValue(params[0], pk);
                Number v2 = TraversalUtil.validPropertyValue(params[1], pk);
                return Condition.and(Condition.gte(pk.id(), (Object)v1), Condition.lt(pk.id(), (Object)v2));
            }
            case "inside": {
                Number[] params = TraversalUtil.predicateNumbers(value, 2);
                Number v1 = TraversalUtil.validPropertyValue(params[0], pk);
                Number v2 = TraversalUtil.validPropertyValue(params[1], pk);
                return Condition.and(Condition.gt(pk.id(), (Object)v1), Condition.lt(pk.id(), (Object)v2));
            }
            case "outside": {
                Number[] params = TraversalUtil.predicateNumbers(value, 2);
                Number v1 = TraversalUtil.validPropertyValue(params[0], pk);
                Number v2 = TraversalUtil.validPropertyValue(params[1], pk);
                return Condition.and(Condition.lt(pk.id(), (Object)v1), Condition.gt(pk.id(), (Object)v2));
            }
            case "within": {
                List<T> values = TraversalUtil.predicateArgs(value);
                ArrayList<T> validValues = new ArrayList<T>(values.size());
                for (T v : values) {
                    validValues.add(TraversalUtil.validPropertyValue(v, pk));
                }
                return Condition.in(pk.id(), validValues);
            }
            case "textcontains": {
                String validValue = TraversalUtil.validPropertyValue(value, pk);
                return Condition.textContains(pk.id(), validValue);
            }
            case "contains": {
                String validValue = TraversalUtil.validPropertyValue(value, pk);
                return Condition.contains(pk.id(), (Object)validValue);
            }
        }
        throw new NotSupportException("predicate '%s'", method);
    }

    private static Number predicateNumber(String value) {
        try {
            return JsonUtil.fromJson(value, Number.class);
        }
        catch (Exception e) {
            if (e.getMessage().contains("not a valid number") || e.getMessage().contains("Unexpected character ('-'")) {
                try {
                    if (value.startsWith("\"")) {
                        value = JsonUtil.fromJson(value, String.class);
                    }
                    return DateUtil.parse((String)value).getTime();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new HugeException("Invalid value '%s', expect a number", (Throwable)e, value);
        }
    }

    private static Number[] predicateNumbers(String value, int count) {
        List values = TraversalUtil.predicateArgs(value);
        if (values.size() != count) {
            throw new HugeException("Invalid numbers size %s, expect %s", values.size(), count);
        }
        for (int i = 0; i < count; ++i) {
            Object v = values.get(i);
            if (v instanceof Number) continue;
            try {
                v = TraversalUtil.predicateNumber(v.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (v instanceof Number) {
                values.set(i, v);
                continue;
            }
            throw new HugeException("Invalid value '%s', expect a list of number", value);
        }
        return values.toArray(new Number[0]);
    }

    private static <V> V predicateArg(String value) {
        try {
            return (V)JsonUtil.fromJson(value, Object.class);
        }
        catch (Exception e) {
            throw new HugeException("Invalid value '%s', expect a single value", (Throwable)e, value);
        }
    }

    private static <V> List<V> predicateArgs(String value) {
        try {
            return JsonUtil.fromJson("[" + value + "]", List.class);
        }
        catch (Exception e) {
            throw new HugeException("Invalid value '%s', expect a list", (Throwable)e, value);
        }
    }
}

