/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.task;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.util.Blob;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.apache.hugegraph.util.StringEncoding;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.slf4j.Logger;

public class HugeTaskResult {
    private static final Logger LOG = Log.logger(HugeTaskResult.class);
    private static final float DECOMPRESS_RATIO = 10.0f;
    private final String taskResultId;
    private volatile String result;

    public HugeTaskResult(String taskId) {
        this.taskResultId = taskId;
        this.result = null;
    }

    public static String genId(Id taskId) {
        return String.format("task_result_%d", taskId.asLong());
    }

    public static HugeTaskResult fromVertex(Vertex vertex) {
        Id taskResultId = (Id)vertex.id();
        HugeTaskResult taskResult = new HugeTaskResult(taskResultId.asString());
        Iterator iter = vertex.properties(new String[0]);
        while (iter.hasNext()) {
            VertexProperty prop = (VertexProperty)iter.next();
            taskResult.property(prop.key(), prop.value());
        }
        return taskResult;
    }

    public String taskResultId() {
        return this.taskResultId;
    }

    public void result(String result) {
        this.result = result;
    }

    public String result() {
        return this.result;
    }

    protected synchronized Object[] asArray() {
        ArrayList<Object> list = new ArrayList<Object>(6);
        list.add(T.label);
        list.add(P.TASKRESULT);
        list.add(T.id);
        list.add(this.taskResultId);
        if (this.result != null) {
            byte[] bytes = StringEncoding.compress(this.result);
            list.add("~result_result");
            list.add(bytes);
        }
        return list.toArray();
    }

    protected void property(String key, Object value) {
        E.checkNotNull((Object)key, (String)"property key");
        switch (key) {
            case "~result_result": {
                this.result = StringEncoding.decompress(((Blob)value).bytes(), 10.0f);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unsupported key: " + key));
            }
        }
    }

    public static final class P {
        public static final String TASKRESULT = Graph.Hidden.hide((String)"taskresult");
        public static final String RESULT = "~result_result";

        public static String unhide(String key) {
            String prefix = Graph.Hidden.hide((String)"result_");
            if (key.startsWith(prefix)) {
                return key.substring(prefix.length());
            }
            return key;
        }
    }
}

