/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.memory.pool.impl;

import java.util.HashSet;
import java.util.Set;
import org.apache.hugegraph.memory.MemoryManager;
import org.apache.hugegraph.memory.allocator.MemoryAllocator;
import org.apache.hugegraph.memory.consumer.OffHeapObject;
import org.apache.hugegraph.memory.pool.AbstractMemoryPool;
import org.apache.hugegraph.memory.pool.MemoryPool;
import org.apache.hugegraph.memory.pool.impl.MemoryPoolStats;
import org.apache.hugegraph.memory.util.OutOfMemoryException;
import org.apache.hugegraph.memory.util.RoundUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperatorMemoryPool
extends AbstractMemoryPool {
    private static final Logger LOG = LoggerFactory.getLogger(OperatorMemoryPool.class);
    private final MemoryAllocator memoryAllocator;
    private final Set<OffHeapObject> offHeapObjects;

    public OperatorMemoryPool(MemoryPool parent, String poolName, MemoryAllocator memoryAllocator, MemoryManager memoryManager) {
        super(parent, poolName, MemoryPoolStats.MemoryPoolType.OPERATOR, memoryManager);
        this.memoryAllocator = memoryAllocator;
        this.offHeapObjects = new HashSet<OffHeapObject>();
    }

    @Override
    public MemoryPool addChildPool(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void bindMemoryConsumer(OffHeapObject offHeapObject) {
        this.offHeapObjects.add(offHeapObject);
    }

    @Override
    public void releaseSelf(String reason, boolean isTriggeredByOOM) {
        super.releaseSelf(reason, isTriggeredByOOM);
        this.memoryAllocator.returnMemoryToManager(this.getUsedBytes());
        this.memoryManager.returnReclaimedTaskMemory(this.getAllocatedBytes());
        this.offHeapObjects.forEach(memoryConsumer -> memoryConsumer.getAllMemoryBlock().forEach(this.memoryAllocator::releaseMemoryBlock));
        this.offHeapObjects.clear();
        this.resetStats();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long tryToReclaimLocalMemory(long neededBytes, MemoryPool requestingPool) {
        if (this.isClosed) {
            LOG.warn("[{}] is already closed, will abort this reclaim", (Object)this);
            return 0L;
        }
        long reclaimableBytes = 0L;
        try {
            if (!this.equals(requestingPool)) {
                this.memoryActionLock.lock();
            }
            LOG.debug("[{}] tryToReclaimLocalMemory: neededBytes={}", (Object)this, (Object)neededBytes);
            this.isBeingArbitrated.set(true);
            reclaimableBytes = this.getFreeBytes();
            if (reclaimableBytes <= neededBytes) {
                this.stats.setAllocatedBytes(this.stats.getUsedBytes());
                LOG.info("[{}] has tried its best to reclaim memory: reclaimedBytes={}, neededBytes={}, snapshot-[{}]", new Object[]{this, reclaimableBytes, neededBytes, this.getSnapShot()});
                long l = reclaimableBytes;
                return l;
            }
            this.stats.setAllocatedBytes(this.stats.getAllocatedBytes() - neededBytes);
            LOG.info("[{}] has reclaim enough memory: reclaimedBytes={}, neededBytes={}, snapshot-[{}]", new Object[]{this, neededBytes, neededBytes, this.getSnapShot()});
            long l = neededBytes;
            return l;
        }
        finally {
            if (reclaimableBytes > 0L) {
                this.stats.setNumShrinks(this.stats.getNumShrinks() + 1L);
            }
            this.isBeingArbitrated.set(false);
            if (!this.equals(requestingPool)) {
                this.condition.signalAll();
                this.memoryActionLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object requireMemory(long bytes, MemoryPool requestingPool) {
        try {
            this.memoryActionLock.lock();
            if (this.getFreeBytes() >= bytes) {
                LOG.debug("[{}] require {} bytes, there is enough free memory {} bytes, will require memory directly from self's free memory.", new Object[]{this, this.getFreeBytes(), bytes});
            } else {
                long delta = bytes - this.getFreeBytes();
                long l = this.requestMemoryInternal(delta, requestingPool);
            }
            Object delta = this.tryToAcquireMemoryInternal(bytes);
            return delta;
        }
        catch (OutOfMemoryException e) {
            LOG.warn("[{}] detected an OOM exception when request memory, will ABORT this query and release corresponding memory... snapshot-[{}]", (Object)this, (Object)this.getSnapShot());
            this.findRootQueryPool().releaseSelf(String.format(e.getMessage(), new Object[0]), true);
            Object var5_7 = null;
            return var5_7;
        }
        finally {
            this.memoryActionLock.unlock();
        }
    }

    @Override
    public Object tryToAcquireMemoryInternal(long size) {
        if (this.isClosed) {
            LOG.warn("[{}] is already closed, will abort this allocate", (Object)this);
            return null;
        }
        LOG.debug("[{}] tryToAcquireMemory: size={}", (Object)this, (Object)size);
        super.tryToAcquireMemoryInternal(size);
        this.getParentPool().tryToAcquireMemoryInternal(size);
        return this.memoryAllocator.tryToAllocate(size);
    }

    @Override
    public long requestMemoryInternal(long size, MemoryPool requestingPool) throws OutOfMemoryException {
        if (this.isClosed) {
            LOG.warn("[{}] is already closed, will abort this request", (Object)this);
            return 0L;
        }
        try {
            if (this.isBeingArbitrated.get()) {
                this.condition.await();
            }
            LOG.debug("[{}] requestMemory: request size={}", (Object)this, (Object)size);
            long alignedSize = RoundUtil.sizeAlign(size);
            long neededMemorySize = this.calculateReserveMemoryDelta(alignedSize);
            long fatherRes = this.getParentPool().requestMemoryInternal(neededMemorySize, requestingPool);
            if (fatherRes <= 0L) {
                LOG.error("[{}] requestMemory failed because of OOM, request size={}", (Object)this, (Object)size);
                if (fatherRes < 0L) {
                    this.stats.setAllocatedBytes(this.stats.getAllocatedBytes() - fatherRes);
                    this.stats.setNumExpands(this.stats.getNumExpands() + 1L);
                }
                this.stats.setNumAborts(this.stats.getNumAborts() + 1L);
                throw new OutOfMemoryException(String.format("%s requestMemory failed because of OOM, request size=%s", this, size));
            }
            this.stats.setAllocatedBytes(this.stats.getAllocatedBytes() + fatherRes);
            this.stats.setNumExpands(this.stats.getNumExpands() + 1L);
            LOG.debug("[{}] requestMemory success: requestedMemorySize={}", (Object)this, (Object)fatherRes);
            return fatherRes;
        }
        catch (InterruptedException e) {
            LOG.error("Failed to release self because ", (Throwable)e);
            Thread.currentThread().interrupt();
            return 0L;
        }
    }

    private long calculateReserveMemoryDelta(long size) {
        return RoundUtil.roundDelta(this.getAllocatedBytes(), size);
    }

    private void resetStats() {
        this.stats.setNumAborts(0L);
        this.stats.setNumExpands(0L);
        this.stats.setNumShrinks(0L);
        this.stats.setAllocatedBytes(0L);
        this.stats.setUsedBytes(0L);
        this.stats.setCumulativeBytes(0L);
    }
}

