/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.memory.arbitrator;

import java.util.Queue;
import org.apache.hugegraph.memory.MemoryManager;
import org.apache.hugegraph.memory.arbitrator.MemoryArbitrator;
import org.apache.hugegraph.memory.pool.MemoryPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryArbitratorImpl
implements MemoryArbitrator {
    private static final Logger LOG = LoggerFactory.getLogger(MemoryArbitratorImpl.class);
    private final MemoryManager memoryManager;

    public MemoryArbitratorImpl(MemoryManager memoryManager) {
        this.memoryManager = memoryManager;
    }

    @Override
    public long reclaimLocally(MemoryPool queryPool, long neededBytes, MemoryPool requestingPool) {
        long startTime = System.currentTimeMillis();
        long res = queryPool.tryToReclaimLocalMemory(neededBytes, requestingPool);
        LOG.info("[{}] reclaim local memory: {} bytes, took {} ms", new Object[]{queryPool, res, System.currentTimeMillis() - startTime});
        return res;
    }

    @Override
    public long reclaimGlobally(MemoryPool queryPool, long neededBytes) {
        long startTime = System.currentTimeMillis();
        long totalReclaimedBytes = 0L;
        long currentNeededBytes = neededBytes;
        Queue<MemoryPool> currentMemoryPool = this.memoryManager.getCurrentQueryMemoryPools();
        while (!currentMemoryPool.isEmpty()) {
            MemoryPool memoryPool = currentMemoryPool.poll();
            if (memoryPool.equals(queryPool)) continue;
            LOG.info("Global reclaim triggerred by {} select {} to reclaim", (Object)queryPool, (Object)memoryPool);
            long res = memoryPool.tryToReclaimLocalMemory(currentNeededBytes, queryPool);
            totalReclaimedBytes += res;
            if ((currentNeededBytes -= res) > 0L) continue;
            break;
        }
        LOG.info("[{}] reclaim global memory: {} bytes, took {} ms", new Object[]{queryPool, totalReclaimedBytes, System.currentTimeMillis() - startTime});
        return totalReclaimedBytes;
    }
}

