/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.job.schema;

import com.google.common.collect.ImmutableSet;
import org.apache.hugegraph.HugeGraphParams;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.tx.GraphTransaction;
import org.apache.hugegraph.backend.tx.ISchemaTransaction;
import org.apache.hugegraph.job.schema.IndexLabelRemoveJob;
import org.apache.hugegraph.job.schema.SchemaJob;
import org.apache.hugegraph.schema.EdgeLabel;
import org.apache.hugegraph.type.define.SchemaStatus;
import org.apache.hugegraph.util.LockUtil;

public class EdgeLabelRemoveJob
extends SchemaJob {
    @Override
    public String type() {
        return "remove_schema";
    }

    @Override
    public Object execute() {
        EdgeLabelRemoveJob.removeEdgeLabel(this.params(), this.schemaId());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeEdgeLabel(HugeGraphParams graph, Id id) {
        GraphTransaction graphTx = graph.graphTransaction();
        ISchemaTransaction schemaTx = graph.schemaTransaction();
        EdgeLabel edgeLabel = schemaTx.getEdgeLabel(id);
        if (edgeLabel == null) {
            return;
        }
        if (edgeLabel.status().deleting()) {
            LOG.info("The edge label '{}' has been in {} status, please check if it's expected to delete it again", (Object)edgeLabel, (Object)edgeLabel.status());
        }
        ImmutableSet indexIds = ImmutableSet.copyOf(edgeLabel.indexLabels());
        LockUtil.Locks locks = new LockUtil.Locks(graph.graph().spaceGraphName());
        try {
            locks.lockWrites("el_delete", id);
            schemaTx.updateSchemaStatus(edgeLabel, SchemaStatus.DELETING);
            try {
                for (Id indexId : indexIds) {
                    IndexLabelRemoveJob.removeIndexLabel(graph, indexId);
                }
                graphTx.removeEdges(edgeLabel);
                graph.graph().tx().commit();
                EdgeLabelRemoveJob.removeSchema(schemaTx, edgeLabel);
            }
            catch (Throwable e) {
                schemaTx.updateSchemaStatus(edgeLabel, SchemaStatus.UNDELETED);
                throw e;
            }
        }
        finally {
            locks.unlock();
        }
    }
}

