/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.job.algorithm.comm;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.job.UserJob;
import org.apache.hugegraph.job.algorithm.AbstractAlgorithm;
import org.apache.hugegraph.job.algorithm.comm.AbstractCommAlgorithm;
import org.apache.hugegraph.schema.SchemaManager;
import org.apache.hugegraph.schema.VertexLabel;
import org.apache.hugegraph.type.define.Directions;
import org.apache.hugegraph.util.E;
import org.apache.tinkerpop.gremlin.process.traversal.Scope;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class LpaAlgorithm
extends AbstractCommAlgorithm {
    public static final String ALGO_NAME = "lpa";

    @Override
    public String name() {
        return ALGO_NAME;
    }

    @Override
    public void checkParameters(Map<String, Object> parameters) {
        LpaAlgorithm.times(parameters);
        LpaAlgorithm.precision(parameters);
        LpaAlgorithm.sourceLabel(parameters);
        LpaAlgorithm.edgeLabel(parameters);
        LpaAlgorithm.direction(parameters);
        LpaAlgorithm.degree(parameters);
        LpaAlgorithm.showCommunity(parameters);
        LpaAlgorithm.workers(parameters);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object call(UserJob<Object> job, Map<String, Object> parameters) {
        int workers = LpaAlgorithm.workers(parameters);
        String showComm = LpaAlgorithm.showCommunity(parameters);
        try (Traverser traverser = new Traverser(job, workers);){
            if (showComm != null) {
                Object object = traverser.showCommunity(showComm);
                return object;
            }
            Object object = traverser.lpa(LpaAlgorithm.sourceLabel(parameters), LpaAlgorithm.edgeLabel(parameters), LpaAlgorithm.direction(parameters), LpaAlgorithm.degree(parameters), LpaAlgorithm.times(parameters), LpaAlgorithm.precision(parameters));
            return object;
        }
        catch (Throwable e) {
            job.graph().tx().rollback();
            throw e;
        }
    }

    private static class Traverser
    extends AbstractAlgorithm.AlgoTraverser {
        private static final long LIMIT = 100000000L;
        private final Random R = new Random();

        public Traverser(UserJob<Object> job, int workers) {
            super(job, LpaAlgorithm.ALGO_NAME, workers);
        }

        public Object lpa(String sourceLabel, String edgeLabel, Directions dir, long degree, int maxTimes, double precision) {
            assert (maxTimes > 0);
            assert (precision > 0.0);
            this.initSchema();
            int times = maxTimes;
            double changedPercent = 0.0;
            for (int i = 0; i < maxTimes; ++i) {
                changedPercent = this.detectCommunities(sourceLabel, edgeLabel, dir, degree);
                if (!(changedPercent <= precision)) continue;
                times = i + 1;
                break;
            }
            Number communities = this.tryNext(this.graph().traversal().V(new Object[0]).filter((Traversal)__.properties((String[])new String[]{"c_label"})).groupCount().by("c_label").count(Scope.local));
            return ImmutableMap.of((Object)"iteration_times", (Object)times, (Object)"last_precision", (Object)changedPercent, (Object)"times", (Object)maxTimes, (Object)"communities", (Object)communities);
        }

        public Object showCommunity(String clabel) {
            E.checkNotNull((Object)clabel, (String)"clabel");
            Iterator<Vertex> vertices = this.vertices(null, clabel, 100000000L);
            AbstractAlgorithm.JsonMap json = new AbstractAlgorithm.JsonMap();
            json.startList();
            while (vertices.hasNext()) {
                this.updateProgress(++this.progress);
                json.append(vertices.next().id().toString());
            }
            json.endList();
            return json.asJson();
        }

        private double detectCommunities(String sourceLabel, String edgeLabel, Directions dir, long degree) {
            AtomicLong changed = new AtomicLong(0L);
            long total = this.traverse(sourceLabel, null, v -> {
                if (this.voteCommunityAndUpdate((Vertex)v, edgeLabel, dir, degree)) {
                    changed.incrementAndGet();
                }
            }, () -> this.graph().tx().commit());
            return total == 0L ? 0.0 : changed.doubleValue() / (double)total;
        }

        private boolean voteCommunityAndUpdate(Vertex vertex, String edgeLabel, Directions dir, long degree) {
            String label = this.voteCommunityOfVertex(vertex, edgeLabel, dir, degree);
            if (!this.labelPresent(vertex) || !label.equals(this.labelOfVertex(vertex))) {
                this.updateLabelOfVertex(vertex, label);
                return true;
            }
            return false;
        }

        private String voteCommunityOfVertex(Vertex vertex, String edgeLabel, Directions dir, long degree) {
            Id source = (Id)vertex.id();
            Id labelId = this.getEdgeLabelIdOrNull(edgeLabel);
            Iterator<Id> neighbors = this.adjacentVertices(source, dir, labelId, degree);
            HashMap<String, MutableInt> labels = new HashMap<String, MutableInt>();
            while (neighbors.hasNext()) {
                String label = this.labelOfVertex(neighbors.next());
                if (label == null) continue;
                MutableInt labelCount = (MutableInt)labels.get(label);
                if (labelCount != null) {
                    labelCount.increment();
                    continue;
                }
                labels.put(label, new MutableInt(1));
            }
            if (labels.isEmpty()) {
                return this.labelOfVertex(vertex);
            }
            ArrayList<String> maxLabels = new ArrayList<String>();
            int maxFreq = 1;
            for (Map.Entry e : labels.entrySet()) {
                int value = ((MutableInt)e.getValue()).intValue();
                if (value > maxFreq) {
                    maxFreq = value;
                    maxLabels.clear();
                }
                if (value != maxFreq) continue;
                maxLabels.add((String)e.getKey());
            }
            int selected = this.R.nextInt(maxLabels.size());
            return (String)maxLabels.get(selected);
        }

        private boolean labelPresent(Vertex vertex) {
            return vertex.property("c_label").isPresent();
        }

        private String labelOfVertex(Vertex vertex) {
            if (!this.labelPresent(vertex)) {
                return vertex.id().toString();
            }
            return (String)vertex.value("c_label");
        }

        private String labelOfVertex(Id vid) {
            Vertex vertex = this.vertex(vid);
            if (vertex == null) {
                return null;
            }
            return this.labelOfVertex(vertex);
        }

        private void updateLabelOfVertex(Vertex v, String label) {
            v.property("c_label", (Object)label);
            this.commitIfNeeded();
        }

        private void initSchema() {
            String cl = "c_label";
            SchemaManager schema = this.graph().schema();
            schema.propertyKey(cl).asText().ifNotExist().create();
            for (VertexLabel vl : schema.getVertexLabels()) {
                schema.vertexLabel(vl.name()).properties(cl).nullableKeys(cl).append();
            }
        }
    }
}

