/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.job.algorithm.comm;

import java.util.Map;
import org.apache.hugegraph.job.algorithm.AbstractAlgorithm;
import org.apache.hugegraph.traversal.algorithm.HugeTraverser;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.ParameterUtil;

public abstract class AbstractCommAlgorithm
extends AbstractAlgorithm {
    private static final int MAX_TIMES = 2048;

    @Override
    public String category() {
        return "community";
    }

    protected static int times(Map<String, Object> parameters) {
        if (!parameters.containsKey("times")) {
            return 20;
        }
        int times = ParameterUtil.parameterInt(parameters, "times");
        HugeTraverser.checkPositiveOrNoLimit(times, "times");
        E.checkArgument((times <= 2048 ? 1 : 0) != 0, (String)"The maximum number of iterations is %s, but got %s", (Object[])new Object[]{2048, times});
        return times;
    }

    protected static int stableTimes(Map<String, Object> parameters) {
        if (!parameters.containsKey("stable_times")) {
            return 3;
        }
        int times = ParameterUtil.parameterInt(parameters, "stable_times");
        HugeTraverser.checkPositiveOrNoLimit(times, "stable_times");
        E.checkArgument((times <= 2048 ? 1 : 0) != 0, (String)"The maximum number of stable iterations is %s, but got %s", (Object[])new Object[]{2048, times});
        return times;
    }

    protected static double precision(Map<String, Object> parameters) {
        if (!parameters.containsKey("precision")) {
            return 0.001;
        }
        double precision = ParameterUtil.parameterDouble(parameters, "precision");
        E.checkArgument((0.0 < precision && precision < 1.0 ? 1 : 0) != 0, (String)"The %s parameter must be in range(0,1), but got: %s", (Object[])new Object[]{"precision", precision});
        return precision;
    }

    protected static String showCommunity(Map<String, Object> parameters) {
        if (!parameters.containsKey("show_community")) {
            return null;
        }
        return ParameterUtil.parameterString(parameters, "show_community");
    }
}

