/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.auth;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.hugegraph.HugeGraphParams;
import org.apache.hugegraph.auth.HugeGroup;
import org.apache.hugegraph.auth.HugeUser;
import org.apache.hugegraph.auth.ResourceType;
import org.apache.hugegraph.auth.SchemaDefine;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.id.IdGenerator;
import org.apache.hugegraph.schema.EdgeLabel;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.T;

public class HugeBelong
extends SchemaDefine.Relationship {
    public static final String UG = "ug";
    public static final String UR = "ur";
    public static final String GR = "gr";
    public static final String ALL = "*";
    private static final long serialVersionUID = -7242751631755533423L;
    public static final String DEFAULT_GRAPH_SPACE = "DEFAULT";
    private String graphSpace;
    private Id user;
    private Id group;
    private Id role;
    private String description;
    private String link;

    public HugeBelong(Id user, Id group) {
        this(DEFAULT_GRAPH_SPACE, user, group, null, UG);
    }

    public HugeBelong(String graphSpace, Id user, Id role) {
        this(graphSpace, user, null, role, UR);
    }

    public HugeBelong(String graphSpace, Id user, Id group, Id role, String link) {
        this.graphSpace = graphSpace;
        this.user = user;
        this.group = group;
        this.role = role;
        this.description = null;
        this.link = link;
    }

    public static boolean isLink(String link) {
        ImmutableList linkList = ImmutableList.of((Object)UG, (Object)UR, (Object)GR);
        return linkList.contains(link);
    }

    @Override
    public void setId() {
        String belongId = String.join((CharSequence)"->", this.source().asString(), this.link, this.target().asString());
        this.id(IdGenerator.of(belongId));
    }

    @Override
    public ResourceType type() {
        return ResourceType.GRANT;
    }

    @Override
    public String label() {
        return P.BELONG;
    }

    @Override
    public String sourceLabel() {
        return P.USER;
    }

    @Override
    public String targetLabel() {
        return P.GROUP;
    }

    @Override
    public String graphSpace() {
        return this.graphSpace;
    }

    @Override
    public Id source() {
        if (GR.equals(this.link)) {
            return this.group;
        }
        return this.user;
    }

    @Override
    public Id target() {
        if (UG.equals(this.link)) {
            return this.group;
        }
        return this.role;
    }

    public void target(Id id) {
        if (UG.equals(this.link)) {
            this.group = id;
        }
        this.role = id;
    }

    public String link() {
        return this.link;
    }

    public String description() {
        return this.description;
    }

    public void description(String description) {
        this.description = description;
    }

    public String toString() {
        return String.format("HugeBelong(%s->%s)%s", this.user, this.group, this.asMap());
    }

    @Override
    protected boolean property(String key, Object value) {
        if (super.property(key, value) || value == null) {
            return true;
        }
        switch (key) {
            case "~graphspace": {
                this.graphSpace = (String)value;
                break;
            }
            case "~user": {
                this.user = IdGenerator.of((String)value);
                break;
            }
            case "~group": {
                this.group = IdGenerator.of((String)value);
                break;
            }
            case "~role": {
                this.role = IdGenerator.of((String)value);
                break;
            }
            case "~belong_description": {
                this.description = (String)value;
                break;
            }
            case "~link": {
                this.link = (String)value;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unsupported key: " + key));
            }
        }
        return true;
    }

    @Override
    protected Object[] asArray() {
        ArrayList<Object> list = new ArrayList<Object>(10);
        list.add(T.label);
        list.add(P.BELONG);
        if (this.description != null) {
            list.add("~belong_description");
            list.add(this.description);
        }
        return super.asArray(list);
    }

    @Override
    public Map<String, Object> asMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(Graph.Hidden.unHide((String)"~graphspace"), this.graphSpace);
        if (this.user != null) {
            map.put(Graph.Hidden.unHide((String)P.USER), this.user);
        }
        if (this.group != null) {
            map.put(Graph.Hidden.unHide((String)P.GROUP), this.group);
        }
        if (this.role != null) {
            map.put(Graph.Hidden.unHide((String)"~role"), this.role);
        }
        map.put(Graph.Hidden.unHide((String)"~link"), this.link);
        if (this.description != null) {
            map.put(Graph.Hidden.unHide((String)"~belong_description"), this.description);
        }
        return super.asMap(map);
    }

    public static HugeBelong fromEdge(Edge edge) {
        HugeBelong belong = new HugeBelong((Id)edge.outVertex().id(), (Id)edge.inVertex().id());
        return HugeBelong.fromEdge(edge, belong);
    }

    public static Schema schema(HugeGraphParams graph) {
        return new Schema(graph);
    }

    public static HugeBelong fromMap(Map<String, Object> map) {
        HugeBelong belong = new HugeBelong(null, null);
        return HugeBelong.fromMap(map, belong);
    }

    public static final class Schema
    extends SchemaDefine {
        public Schema(HugeGraphParams graph) {
            super(graph, P.BELONG);
        }

        @Override
        public void initSchemaIfNeeded() {
            if (this.existEdgeLabel(this.label)) {
                return;
            }
            String[] properties = this.initProperties();
            EdgeLabel label = (EdgeLabel)this.schema().edgeLabel(this.label).sourceLabel(P.USER).targetLabel(P.GROUP).properties(properties).nullableKeys("~belong_description").enableLabelIndex(true).build();
            this.graph.schemaTransaction().addEdgeLabel(label);
        }

        private String[] initProperties() {
            ArrayList<String> props = new ArrayList<String>();
            props.add(this.createPropertyKey("~belong_description"));
            return super.initProperties(props);
        }
    }

    public static final class P {
        public static final String BELONG = Graph.Hidden.hide((String)"belong");
        public static final String LABEL = T.label.getAccessor();
        public static final String GRAPHSPACE = "~graphspace";
        public static final String ROLE = "~role";
        public static final String USER = HugeUser.P.USER;
        public static final String USER_HIDDEN = "~user";
        public static final String GROUP = HugeGroup.P.GROUP;
        public static final String GROUP_HIDDEN = "~group";
        public static final String DESCRIPTION = "~belong_description";
        public static final String LINK = "~link";

        public static String unhide(String key) {
            String prefix = Graph.Hidden.hide((String)"belong_");
            if (key.startsWith(prefix)) {
                return key.substring(prefix.length());
            }
            return key;
        }
    }
}

