/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.util.star;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONUtil;
import org.apache.tinkerpop.gremlin.structure.util.Comparators;
import org.apache.tinkerpop.gremlin.structure.util.star.DirectionalStarGraph;
import org.apache.tinkerpop.gremlin.structure.util.star.StarGraph;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.apache.tinkerpop.shaded.jackson.core.JsonGenerationException;
import org.apache.tinkerpop.shaded.jackson.core.JsonGenerator;
import org.apache.tinkerpop.shaded.jackson.core.JsonProcessingException;
import org.apache.tinkerpop.shaded.jackson.databind.SerializerProvider;
import org.apache.tinkerpop.shaded.jackson.databind.jsontype.TypeSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.ser.std.StdSerializer;

public class StarGraphGraphSONSerializerV2d0
extends StdSerializer<DirectionalStarGraph> {
    private final boolean normalize;

    public StarGraphGraphSONSerializerV2d0(boolean normalize) {
        super(DirectionalStarGraph.class);
        this.normalize = normalize;
    }

    public void serialize(DirectionalStarGraph starGraph, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
        this.ser(starGraph, jsonGenerator, serializerProvider, null);
    }

    public void serializeWithType(DirectionalStarGraph starGraph, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException, JsonProcessingException {
        this.ser(starGraph, jsonGenerator, serializerProvider, typeSerializer);
    }

    private void ser(DirectionalStarGraph directionalStarGraph, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException, JsonProcessingException {
        StarGraph starGraph = directionalStarGraph.getStarGraphToSerialize();
        GraphSONUtil.writeStartObject(starGraph, jsonGenerator, typeSerializer);
        GraphSONUtil.writeWithType("id", starGraph.starVertex.id, jsonGenerator, serializerProvider, typeSerializer);
        jsonGenerator.writeStringField("label", starGraph.starVertex.label);
        if (directionalStarGraph.getDirection() != null) {
            this.writeEdges(directionalStarGraph, jsonGenerator, serializerProvider, typeSerializer, Direction.IN);
        }
        if (directionalStarGraph.getDirection() != null) {
            this.writeEdges(directionalStarGraph, jsonGenerator, serializerProvider, typeSerializer, Direction.OUT);
        }
        if (starGraph.starVertex.vertexProperties != null && !starGraph.starVertex.vertexProperties.isEmpty()) {
            jsonGenerator.writeFieldName("properties");
            GraphSONUtil.writeStartObject(starGraph, jsonGenerator, typeSerializer);
            Set<String> keys = this.normalize ? new TreeSet<String>(starGraph.starVertex.vertexProperties.keySet()) : starGraph.starVertex.vertexProperties.keySet();
            for (String k : keys) {
                List<VertexProperty> vp = starGraph.starVertex.vertexProperties.get(k);
                jsonGenerator.writeFieldName(k);
                GraphSONUtil.writeStartArray(k, jsonGenerator, typeSerializer);
                List<VertexProperty> vertexProperties = this.normalize ? StarGraphGraphSONSerializerV2d0.sort(vp, Comparators.PROPERTY_COMPARATOR) : vp;
                for (VertexProperty property : vertexProperties) {
                    Iterator metaProperties;
                    GraphSONUtil.writeStartObject(property, jsonGenerator, typeSerializer);
                    GraphSONUtil.writeWithType("id", property.id(), jsonGenerator, serializerProvider, typeSerializer);
                    GraphSONUtil.writeWithType("value", property.value(), jsonGenerator, serializerProvider, typeSerializer);
                    Iterator iterator = metaProperties = this.normalize ? IteratorUtils.list(property.properties(new String[0]), Comparators.PROPERTY_COMPARATOR).iterator() : property.properties(new String[0]);
                    if (metaProperties.hasNext()) {
                        jsonGenerator.writeFieldName("properties");
                        GraphSONUtil.writeStartObject(metaProperties, jsonGenerator, typeSerializer);
                        while (metaProperties.hasNext()) {
                            Property meta = metaProperties.next();
                            GraphSONUtil.writeWithType(meta.key(), meta.value(), jsonGenerator, serializerProvider, typeSerializer);
                        }
                        GraphSONUtil.writeEndObject(metaProperties, jsonGenerator, typeSerializer);
                    }
                    GraphSONUtil.writeEndObject(property, jsonGenerator, typeSerializer);
                }
                GraphSONUtil.writeEndArray(k, jsonGenerator, typeSerializer);
            }
            GraphSONUtil.writeEndObject(starGraph, jsonGenerator, typeSerializer);
        }
        GraphSONUtil.writeEndObject(starGraph, jsonGenerator, typeSerializer);
    }

    private void writeEdges(DirectionalStarGraph directionalStarGraph, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer, Direction direction) throws IOException, JsonProcessingException {
        boolean writeEdges;
        StarGraph starGraph = directionalStarGraph.getStarGraphToSerialize();
        Direction edgeDirectionToSerialize = directionalStarGraph.getDirection();
        Map<String, List<Edge>> starEdges = direction.equals((Object)Direction.OUT) ? starGraph.starVertex.outEdges : starGraph.starVertex.inEdges;
        boolean bl = writeEdges = null != starEdges && edgeDirectionToSerialize != null && (edgeDirectionToSerialize == direction || edgeDirectionToSerialize == Direction.BOTH);
        if (writeEdges) {
            jsonGenerator.writeFieldName(direction == Direction.IN ? "inE" : "outE");
            GraphSONUtil.writeStartObject(directionalStarGraph, jsonGenerator, typeSerializer);
            Set<String> keys = this.normalize ? new TreeSet<String>(starEdges.keySet()) : starEdges.keySet();
            for (String k : keys) {
                List<Edge> edges = starEdges.get(k);
                jsonGenerator.writeFieldName(k);
                GraphSONUtil.writeStartArray(k, jsonGenerator, typeSerializer);
                List<Edge> edgesToWrite = this.normalize ? StarGraphGraphSONSerializerV2d0.sort(edges, Comparators.EDGE_COMPARATOR) : edges;
                for (Edge edge : edgesToWrite) {
                    Iterator edgeProperties;
                    GraphSONUtil.writeStartObject(edge, jsonGenerator, typeSerializer);
                    GraphSONUtil.writeWithType("id", edge.id(), jsonGenerator, serializerProvider, typeSerializer);
                    GraphSONUtil.writeWithType(direction.equals((Object)Direction.OUT) ? "inV" : "outV", direction.equals((Object)Direction.OUT) ? edge.inVertex().id() : edge.outVertex().id(), jsonGenerator, serializerProvider, typeSerializer);
                    Iterator iterator = edgeProperties = this.normalize ? IteratorUtils.list(edge.properties(new String[0]), Comparators.PROPERTY_COMPARATOR).iterator() : edge.properties(new String[0]);
                    if (edgeProperties.hasNext()) {
                        jsonGenerator.writeFieldName("properties");
                        GraphSONUtil.writeStartObject(edge, jsonGenerator, typeSerializer);
                        while (edgeProperties.hasNext()) {
                            Property meta = edgeProperties.next();
                            GraphSONUtil.writeWithType(meta.key(), meta.value(), jsonGenerator, serializerProvider, typeSerializer);
                        }
                        GraphSONUtil.writeEndObject(edge, jsonGenerator, typeSerializer);
                    }
                    GraphSONUtil.writeEndObject(edge, jsonGenerator, typeSerializer);
                }
                GraphSONUtil.writeEndArray(k, jsonGenerator, typeSerializer);
            }
            GraphSONUtil.writeEndObject(directionalStarGraph, jsonGenerator, typeSerializer);
        }
    }

    private static <S> List<S> sort(List<S> listToSort, Comparator comparator) {
        Collections.sort(listToSort, comparator);
        return listToSort;
    }
}

