/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.jcseg.extractor.impl;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.lionsoul.jcseg.ISegment;
import org.lionsoul.jcseg.IWord;
import org.lionsoul.jcseg.extractor.KeyphraseExtractor;
import org.lionsoul.jcseg.util.IStringBuffer;

public class TextRankKeyphraseExtractor
extends KeyphraseExtractor {
    public static final float D = 0.85f;
    protected int keywordsNum = 10;
    protected int maxIterateNum = 120;
    protected int windowSize = 5;
    protected int autoMinLength = -1;
    protected int maxWordsNum = 5;

    public TextRankKeyphraseExtractor(ISegment seg) {
        super(seg);
    }

    @Override
    public List<String> getKeyphrase(Reader reader) throws IOException {
        HashMap winMap = new HashMap();
        ArrayList<IWord> wordsPool = new ArrayList<IWord>();
        IWord w = null;
        this.seg.reset(reader);
        while ((w = this.seg.next()) != null) {
            if (!this.filter(w)) continue;
            if (!winMap.containsKey(w)) {
                winMap.put(w, new LinkedList());
            }
            wordsPool.add(w);
        }
        for (int i = 0; i < wordsPool.size(); ++i) {
            IWord word = (IWord)wordsPool.get(i);
            List support = (List)winMap.get(word);
            int n = Math.max(0, i - this.windowSize);
            int eIdx = Math.min(i + this.windowSize, wordsPool.size() - 1);
            for (int j = n; j <= eIdx; ++j) {
                if (j == i) continue;
                support.add(wordsPool.get(j));
            }
        }
        HashMap<IWord, Float> score = new HashMap<IWord, Float>();
        for (int c = 0; c < this.maxIterateNum; ++c) {
            for (Map.Entry entry : winMap.entrySet()) {
                IWord key = (IWord)entry.getKey();
                List value = (List)entry.getValue();
                float f = 0.0f;
                for (IWord ele : value) {
                    int size = ((List)winMap.get(ele)).size();
                    if (size == 0 || ele.getValue().equals(key.getValue())) continue;
                    float Sy = 0.0f;
                    if (score != null && score.containsKey(ele)) {
                        Sy = ((Float)score.get(ele)).floatValue();
                    }
                    f += Sy / (float)size;
                }
                score.put(key, Float.valueOf(0.14999998f + 0.85f * f));
            }
        }
        ArrayList entryList = new ArrayList(score.entrySet());
        Collections.sort(entryList, new Comparator<Map.Entry<IWord, Float>>(){

            @Override
            public int compare(Map.Entry<IWord, Float> o1, Map.Entry<IWord, Float> o2) {
                return o2.getValue().compareTo(o1.getValue());
            }
        });
        if (entryList.size() == 0) {
            return new ArrayList<String>(1);
        }
        float tScores = 0.0f;
        float f = 0.0f;
        float stdScores = 0.0f;
        for (Map.Entry entry : entryList) {
            tScores += ((Float)entry.getValue()).floatValue();
        }
        f = tScores / (float)wordsPool.size();
        stdScores = f * 1.85f;
        IStringBuffer isb = new IStringBuffer();
        LinkedList<String> linkedList = new LinkedList<String>();
        int i = 0;
        while (i < entryList.size()) {
            int idx;
            Map.Entry entry = (Map.Entry)entryList.get(i);
            IWord seed = (IWord)entry.getKey();
            if (((Float)entry.getValue()).floatValue() < stdScores) {
                ++i;
                continue;
            }
            int len = 0;
            ArrayList sortQueue = null;
            ArrayList<IWord> listQueue = new ArrayList<IWord>(this.maxWordsNum);
            listQueue.add(seed);
            for (int j = 1; j < this.maxWordsNum && (idx = i + j) < entryList.size(); ++j) {
                listQueue.add((IWord)((Map.Entry)entryList.get(idx)).getKey());
            }
            while (listQueue.size() > 1) {
                sortQueue = new ArrayList(listQueue);
                Collections.sort(sortQueue, new Comparator<IWord>(){

                    @Override
                    public int compare(IWord o1, IWord o2) {
                        return o1.getPosition() - o2.getPosition();
                    }
                });
                IWord t = (IWord)sortQueue.get(0);
                int pos = t.getPosition() + t.getLength() - 1;
                boolean match = true;
                for (int k = 1; k < sortQueue.size(); ++k) {
                    IWord kw = (IWord)sortQueue.get(k);
                    if (kw.getPosition() - pos != 1) {
                        match = false;
                        break;
                    }
                    pos = kw.getPosition() + kw.getLength() - 1;
                }
                if (!match) {
                    sortQueue.clear();
                    sortQueue = null;
                    listQueue.remove(listQueue.size() - 1);
                    continue;
                }
                len = listQueue.size();
                break;
            }
            if (len == 0) {
                if (seed.getType() == 2) {
                    linkedList.add(seed.getValue());
                } else if (this.autoMinLength > 0 && seed.getLength() >= this.autoMinLength) {
                    linkedList.add(seed.getValue());
                }
                ++i;
                continue;
            }
            isb.clear();
            for (IWord word : sortQueue) {
                isb.append(word.getValue());
            }
            linkedList.add(isb.toString());
            i += sortQueue.size();
            listQueue.clear();
            listQueue = null;
        }
        return linkedList;
    }

    public int getKeywordsNum() {
        return this.keywordsNum;
    }

    public void setKeywordsNum(int keywordsNum) {
        this.keywordsNum = keywordsNum;
    }

    public int getMaxIterateNum() {
        return this.maxIterateNum;
    }

    public void setMaxIterateNum(int maxIterateNum) {
        this.maxIterateNum = maxIterateNum;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public void setWindowSize(int windowSize) {
        this.windowSize = windowSize;
    }

    public int getAutoMinLength() {
        return this.autoMinLength;
    }

    public void setAutoMinLength(int autoMinLength) {
        this.autoMinLength = autoMinLength;
    }

    public int getMaxWordsNum() {
        return this.maxWordsNum;
    }

    public void setMaxWordsNum(int maxPhraseLength) {
        this.maxWordsNum = maxPhraseLength;
    }
}

