/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.jcseg;

import java.io.IOException;
import java.io.Reader;
import org.lionsoul.jcseg.IWord;
import org.lionsoul.jcseg.fi.SegmenterFunction;
import org.lionsoul.jcseg.segmenter.ComplexSeg;
import org.lionsoul.jcseg.segmenter.DelimiterSeg;
import org.lionsoul.jcseg.segmenter.DetectSeg;
import org.lionsoul.jcseg.segmenter.MostSeg;
import org.lionsoul.jcseg.segmenter.NGramSeg;
import org.lionsoul.jcseg.segmenter.NLPSeg;
import org.lionsoul.jcseg.segmenter.SimpleSeg;

public interface ISegment {
    public static final Type SIMPLE = Type.SIMPLE;
    public static final Type COMPLEX = Type.COMPLEX;
    public static final Type DETECT = Type.DETECT;
    public static final Type MOST = Type.MOST;
    public static final Type NLP = Type.NLP;
    public static final Type DELIMITER = Type.DELIMITER;
    public static final Type NGRAM = Type.NGRAM;
    public static final int SIMPLE_MODE = Type.SIMPLE.index;
    public static final int COMPLEX_MODE = Type.COMPLEX.index;
    public static final int DETECT_MODE = Type.DETECT.index;
    public static final int MOST_MODE = Type.MOST.index;
    public static final int NLP_MODE = Type.NLP.index;
    public static final int DELIMITER_MODE = Type.DELIMITER.index;
    public static final int NGRAM_MODE = Type.NGRAM.index;
    public static final int CHECK_CE_MASk = 1;
    public static final int CHECK_CF_MASK = 2;
    public static final int START_SS_MASK = 4;
    public static final int CHECK_EC_MASK = 8;

    public void reset(Reader var1) throws IOException;

    public int getStreamPosition();

    public IWord next() throws IOException;

    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type SIMPLE = new Type("simple", 1, SimpleSeg::new);
        public static final /* enum */ Type COMPLEX = new Type("complex", 2, ComplexSeg::new);
        public static final /* enum */ Type DETECT = new Type("detect", 3, DetectSeg::new);
        public static final /* enum */ Type MOST = new Type("most", 4, MostSeg::new);
        public static final /* enum */ Type NLP = new Type("nlp", 5, NLPSeg::new);
        public static final /* enum */ Type DELIMITER = new Type("delimiter", 6, DelimiterSeg::new);
        public static final /* enum */ Type NGRAM = new Type("ngram", 7, NGramSeg::new);
        public final String name;
        public final int index;
        public final SegmenterFunction factory;
        public static final Type[] MAPPING;
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String name) {
            return Enum.valueOf(Type.class, name);
        }

        private Type(String name, int index, SegmenterFunction factory) {
            this.name = name;
            this.index = index;
            this.factory = factory;
        }

        public static Type fromString(String type, Type defaultValue) {
            if (type == null) {
                return defaultValue;
            }
            if ("simple".equals(type = type.toLowerCase())) {
                return SIMPLE;
            }
            if ("complex".equals(type)) {
                return COMPLEX;
            }
            if ("detect".equals(type)) {
                return DETECT;
            }
            if ("most".equals(type)) {
                return MOST;
            }
            if ("nlp".equals(type)) {
                return NLP;
            }
            if ("delimiter".equals(type)) {
                return DELIMITER;
            }
            if ("ngram".equals(type)) {
                return NGRAM;
            }
            return defaultValue;
        }

        public static Type fromString(String type) {
            return Type.fromString(type, COMPLEX);
        }

        public static Type fromIndex(int index) {
            assert (index > 0);
            assert (index < MAPPING.length);
            return MAPPING[index];
        }

        static {
            $VALUES = new Type[]{SIMPLE, COMPLEX, DETECT, MOST, NLP, DELIMITER, NGRAM};
            MAPPING = new Type[]{null, SIMPLE, COMPLEX, DETECT, MOST, NLP, DELIMITER, NGRAM};
        }
    }
}

