/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.postgresql;

import java.util.ArrayList;
import java.util.List;
import org.apache.hugegraph.backend.serializer.TableBackendEntry;
import org.apache.hugegraph.backend.store.mysql.MysqlSessions;
import org.apache.hugegraph.backend.store.mysql.MysqlTable;
import org.apache.hugegraph.backend.store.mysql.WhereBuilder;
import org.apache.hugegraph.backend.store.postgresql.PostgresqlSessions;
import org.apache.hugegraph.type.define.HugeKeys;

public abstract class PostgresqlTable
extends MysqlTable {
    private String orderByKeysTemplate = null;

    public PostgresqlTable(String table) {
        super(table);
    }

    protected String buildDropTemplate() {
        return String.format("DROP TABLE IF EXISTS %s CASCADE;", this.table());
    }

    protected String buildTruncateTemplate() {
        return String.format("TRUNCATE TABLE %s CASCADE;", this.table());
    }

    protected String engine(MysqlSessions.Session session) {
        return "";
    }

    protected String buildUpdateForcedTemplate(TableBackendEntry.Row entry) {
        return this.buildInsertKeys(entry, false);
    }

    protected List<?> buildUpdateForcedParams(TableBackendEntry.Row entry) {
        ArrayList params = new ArrayList();
        List allColumns = this.buildColumnsParams(entry);
        params.addAll(allColumns);
        params.addAll(allColumns);
        return params;
    }

    protected String buildUpdateIfAbsentTemplate(TableBackendEntry.Row entry) {
        return this.buildInsertKeys(entry, true);
    }

    protected List<?> buildUpdateIfAbsentParams(TableBackendEntry.Row entry) {
        return this.buildColumnsParams(entry);
    }

    protected String buildInsertKeys(TableBackendEntry.Row entry, boolean ignoreConflicts) {
        StringBuilder insert = new StringBuilder();
        insert.append("INSERT INTO ").append(this.table()).append(" (");
        int i = 0;
        int size = entry.columns().size();
        for (HugeKeys key : entry.columns().keySet()) {
            insert.append(PostgresqlTable.formatKey((HugeKeys)key));
            if (++i == size) continue;
            insert.append(", ");
        }
        insert.append(") VALUES (");
        for (i = 0; i < size; ++i) {
            insert.append("?");
            if (i == size - 1) continue;
            insert.append(", ");
        }
        insert.append(")");
        i = 0;
        size = this.tableDefine().keys().size();
        insert.append(" ON CONFLICT (");
        for (HugeKeys key : this.tableDefine().keys()) {
            insert.append(PostgresqlTable.formatKey((HugeKeys)key));
            if (++i == size) continue;
            insert.append(", ");
        }
        insert.append(")");
        if (ignoreConflicts) {
            insert.append(" DO NOTHING");
        } else {
            i = 0;
            size = entry.columns().keySet().size();
            insert.append(" DO UPDATE SET ");
            for (HugeKeys key : entry.columns().keySet()) {
                insert.append(PostgresqlTable.formatKey((HugeKeys)key)).append(" = ?");
                if (++i == size) continue;
                insert.append(", ");
            }
        }
        return insert.toString();
    }

    protected String orderByKeys() {
        if (this.orderByKeysTemplate != null) {
            return this.orderByKeysTemplate;
        }
        int i = 0;
        int size = this.tableDefine().keys().size();
        StringBuilder select = new StringBuilder(" ORDER BY ");
        for (HugeKeys hugeKey : this.tableDefine().keys()) {
            String key = PostgresqlTable.formatKey((HugeKeys)hugeKey);
            select.append(key).append(" ");
            select.append("ASC ");
            if (++i == size) continue;
            select.append(", ");
        }
        this.orderByKeysTemplate = select.toString();
        return this.orderByKeysTemplate;
    }

    protected WhereBuilder newWhereBuilder(boolean startWithWhere) {
        return new PgWhereBuilder(startWithWhere);
    }

    private static class PgWhereBuilder
    extends WhereBuilder {
        public PgWhereBuilder(boolean startWithWhere) {
            super(startWithWhere);
        }

        protected String escapeAndWrapString(String value) {
            if (value.equals("\u0000")) {
                return "''";
            }
            return PostgresqlSessions.escapeAndWrapString(value);
        }
    }
}

