/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.postgresql;

import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.http.client.utils.URIBuilder;
import org.apache.hugegraph.backend.BackendException;
import org.apache.hugegraph.backend.store.mysql.MysqlSessions;
import org.apache.hugegraph.backend.store.mysql.MysqlUtil;
import org.apache.hugegraph.backend.store.postgresql.PostgresqlOptions;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.util.Log;
import org.postgresql.core.Utils;
import org.postgresql.util.PSQLException;
import org.slf4j.Logger;

public class PostgresqlSessions
extends MysqlSessions {
    private static final Logger LOG = Log.logger(PostgresqlSessions.class);
    private static final String COCKROACH_DB_CREATE = "CREATE DATABASE %s ENCODING='UTF-8'";
    private static final String POSTGRESQL_DB_CREATE = "CREATE DATABASE %s ENCODING='UTF-8' TEMPLATE=template0 LC_COLLATE='C' LC_CTYPE='C';";

    public PostgresqlSessions(HugeConfig config, String database, String store) {
        super(config, database, store);
    }

    public boolean existsDatabase() {
        boolean bl;
        block8: {
            String statement = String.format("SELECT datname FROM pg_catalog.pg_database WHERE datname = '%s';", this.escapedDatabase());
            Connection conn = this.openWithoutDB(0);
            try {
                ResultSet result = conn.createStatement().executeQuery(statement);
                bl = result.next();
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new BackendException("Failed to obtain database info", (Throwable)e);
                }
            }
            conn.close();
        }
        return bl;
    }

    public void createDatabase() {
        block11: {
            LOG.debug("Create database: {}", (Object)this.database());
            String sql = this.buildCreateDatabase(this.database());
            try (Connection conn = this.openWithoutDB(0);){
                try {
                    conn.createStatement().execute(sql);
                }
                catch (PSQLException e) {
                    if (e.getMessage().contains("syntax error at or near \"template\"")) {
                        sql = String.format(COCKROACH_DB_CREATE, this.database());
                        conn.createStatement().execute(sql);
                    }
                }
            }
            catch (SQLException e) {
                if (e.getMessage().endsWith("already exists")) break block11;
                throw new BackendException("Failed to create database '%s'", (Throwable)e, new Object[]{this.database()});
            }
        }
    }

    protected String buildCreateDatabase(String database) {
        return String.format(POSTGRESQL_DB_CREATE, database);
    }

    protected String buildDropDatabase(String database) {
        return String.format("REVOKE CONNECT ON DATABASE %s FROM public;SELECT pg_terminate_backend(pg_stat_activity.pid)   FROM pg_stat_activity   WHERE pg_stat_activity.datname = %s;DROP DATABASE IF EXISTS %s;", database, PostgresqlSessions.escapeAndWrapString(database), database);
    }

    protected String buildExistsTable(String table) {
        return String.format("SELECT * FROM information_schema.tables WHERE table_schema = 'public' AND table_name = '%s' LIMIT 1;", MysqlUtil.escapeString((String)table));
    }

    protected URIBuilder newConnectionURIBuilder(String url) throws URISyntaxException {
        return new URIBuilder(url).addParameter("loggerLevel", "OFF");
    }

    protected String connectDatabase() {
        return (String)this.config().get(PostgresqlOptions.POSTGRESQL_CONNECT_DATABASE);
    }

    public static String escapeAndWrapString(String value) {
        StringBuilder builder = new StringBuilder(8 + value.length());
        builder.append('\'');
        try {
            Utils.escapeLiteral((StringBuilder)builder, (String)value, (boolean)false);
        }
        catch (SQLException e) {
            throw new BackendException("Failed to escape '%s'", (Throwable)e, new Object[]{value});
        }
        builder.append('\'');
        return builder.toString();
    }
}

