/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.client.util;

import java.util.concurrent.atomic.AtomicLong;

public class MetricX {
    public static AtomicLong iteratorSum = new AtomicLong();
    public static AtomicLong iteratorCount = new AtomicLong();
    public static AtomicLong iteratorMax = new AtomicLong();
    public AtomicLong failureCount = new AtomicLong();
    private long start;
    private long end;

    private MetricX(long start) {
        this.start = start;
    }

    public static MetricX ofStart() {
        return new MetricX(System.currentTimeMillis());
    }

    public static void plusIteratorWait(long nanoSeconds) {
        iteratorSum.addAndGet(nanoSeconds);
        iteratorCount.getAndIncrement();
        if (iteratorMax.get() < nanoSeconds) {
            iteratorMax.set(nanoSeconds);
        }
    }

    public static long getIteratorWait() {
        return iteratorSum.get() / 1000000L;
    }

    public static long getIteratorWaitAvg() {
        if (iteratorCount.get() == 0L) {
            return -1L;
        }
        return MetricX.getIteratorWait() / iteratorCount.get();
    }

    public static long getIteratorWaitMax() {
        return iteratorMax.get() / 1000000L;
    }

    public static long getIteratorCount() {
        return iteratorCount.get();
    }

    public long start() {
        this.start = System.currentTimeMillis();
        return this.start;
    }

    public long end() {
        this.end = System.currentTimeMillis();
        return this.end;
    }

    public long past() {
        return this.end - this.start;
    }

    public void countFail() {
        this.failureCount.getAndIncrement();
    }

    public long getFailureCount() {
        return this.failureCount.get();
    }
}

