/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.client;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.hugegraph.store.client.HgPrivate;
import org.apache.hugegraph.store.client.HgStoreNode;
import org.apache.hugegraph.store.client.HgStoreNodeBuilder;
import org.apache.hugegraph.store.client.HgStoreNodeNotifier;
import org.apache.hugegraph.store.client.HgStoreNodePartitioner;
import org.apache.hugegraph.store.client.HgStoreNodeProvider;
import org.apache.hugegraph.store.client.HgStoreNotice;
import org.apache.hugegraph.store.client.grpc.GrpcStoreNodeBuilder;
import org.apache.hugegraph.store.client.type.HgNodeStatus;
import org.apache.hugegraph.store.client.type.HgStoreClientException;
import org.apache.hugegraph.store.client.util.HgAssert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class HgStoreNodeManager {
    private static final Logger log = LoggerFactory.getLogger(HgStoreNodeManager.class);
    private static final Set<String> CLUSTER_ID_SET = new HashSet<String>();
    private static final HgStoreNodeManager instance = new HgStoreNodeManager();
    private final String clusterId;
    private final Map<String, HgStoreNode> addressMap = new ConcurrentHashMap<String, HgStoreNode>();
    private final Map<Long, HgStoreNode> nodeIdMap = new ConcurrentHashMap<Long, HgStoreNode>();
    private final Map<String, List<HgStoreNode>> graphNodesMap = new ConcurrentHashMap<String, List<HgStoreNode>>();
    private HgStoreNodeProvider nodeProvider;
    private HgStoreNodePartitioner nodePartitioner;
    private HgStoreNodeNotifier nodeNotifier;

    private HgStoreNodeManager() {
        this.clusterId = "default-node-cluster";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HgStoreNodeManager(String clusterId) {
        Set<String> set = CLUSTER_ID_SET;
        synchronized (set) {
            if (CLUSTER_ID_SET.contains(clusterId)) {
                throw new RuntimeException("The cluster [" + clusterId + "] has been existing.");
            }
            CLUSTER_ID_SET.add(clusterId);
            this.clusterId = clusterId;
        }
    }

    public static HgStoreNodeManager getInstance() {
        return instance;
    }

    public HgStoreNodeBuilder getNodeBuilder() {
        return new GrpcStoreNodeBuilder(this, HgPrivate.getInstance());
    }

    public HgStoreNode getStoreNode(Long nodeId) {
        if (nodeId == null) {
            return null;
        }
        return this.nodeIdMap.get(nodeId);
    }

    HgStoreNode applyNode(String graphName, Long nodeId) {
        HgStoreNode node = this.nodeIdMap.get(nodeId);
        if (node != null) {
            return node;
        }
        if (this.nodeProvider == null) {
            return null;
        }
        node = this.nodeProvider.apply(graphName, nodeId);
        if (node == null) {
            log.warn("Failed to apply a HgStoreNode instance form the nodeProvider [ " + this.nodeProvider.getClass().getName() + " ].");
            this.notifying(graphName, nodeId, HgNodeStatus.NOT_EXIST);
            return null;
        }
        this.addNode(graphName, node);
        return node;
    }

    private void notifying(String graphName, Long nodeId, HgNodeStatus status) {
        if (this.nodeNotifier != null) {
            try {
                this.nodeNotifier.notice(graphName, HgStoreNotice.of(nodeId, status));
            }
            catch (Throwable t) {
                log.error("Failed to invoke " + this.nodeNotifier.getClass().getSimpleName() + ":notice(" + nodeId + "," + String.valueOf((Object)status) + ")", t);
            }
        }
    }

    public Integer notifying(String graphName, HgStoreNotice notice) {
        if (this.nodeNotifier != null) {
            Thread thread = Thread.currentThread();
            synchronized (thread) {
                try {
                    return this.nodeNotifier.notice(graphName, notice);
                }
                catch (Throwable t) {
                    String msg = "Failed to invoke " + this.nodeNotifier.getClass().getSimpleName() + ", notice: [ " + String.valueOf(notice) + " ]";
                    log.error(msg, t);
                    throw new HgStoreClientException(msg);
                }
            }
        }
        return null;
    }

    public List<HgStoreNode> getStoreNodes(String graphName) {
        if (HgAssert.isInvalid(graphName)) {
            return null;
        }
        return this.graphNodesMap.get(graphName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HgStoreNode addNode(HgStoreNode storeNode) {
        HgAssert.isFalse(storeNode == null, "the argument: storeNode is null.");
        Long nodeId = storeNode.getNodeId();
        HgStoreNode node = null;
        Map<Long, HgStoreNode> map = this.nodeIdMap;
        synchronized (map) {
            node = this.addressMap.get(nodeId);
            if (node == null) {
                node = storeNode;
                this.nodeIdMap.put(nodeId, node);
                this.addressMap.put(storeNode.getAddress(), node);
            }
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HgStoreNode addNode(String graphName, HgStoreNode storeNode) {
        HgAssert.isFalse(HgAssert.isInvalid(graphName), "the argument is invalid: graphName");
        HgStoreNode node = this.addNode(storeNode);
        List<HgStoreNode> nodes = null;
        Map<String, List<HgStoreNode>> map = this.graphNodesMap;
        synchronized (map) {
            nodes = this.graphNodesMap.get(graphName);
            if (nodes == null) {
                nodes = new ArrayList<HgStoreNode>();
                this.graphNodesMap.put(graphName, nodes);
            }
            nodes.add(node);
        }
        return node;
    }

    public HgStoreNodePartitioner getNodePartitioner() {
        return this.nodePartitioner;
    }

    public HgStoreNodeManager setNodePartitioner(HgStoreNodePartitioner nodePartitioner) {
        HgAssert.isFalse(nodePartitioner == null, "the argument is invalid: nodePartitioner");
        this.nodePartitioner = nodePartitioner;
        return this;
    }

    public HgStoreNodeNotifier getNodeNotifier() {
        return this.nodeNotifier;
    }

    public HgStoreNodeManager setNodeNotifier(HgStoreNodeNotifier nodeNotifier) {
        HgAssert.isFalse(nodeNotifier == null, "the argument is invalid: nodeNotifier");
        this.nodeNotifier = nodeNotifier;
        return this;
    }

    public HgStoreNodeManager setNodeProvider(HgStoreNodeProvider nodeProvider) {
        this.nodeProvider = nodeProvider;
        return this;
    }
}

