/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.nps.parser;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.gridkit.jvmtool.codec.stacktrace.ThreadSnapshotEventPojo;
import org.gridkit.jvmtool.event.Event;
import org.gridkit.jvmtool.event.EventMorpher;
import org.gridkit.jvmtool.event.EventReader;
import org.gridkit.jvmtool.event.MorphingEventReader;
import org.gridkit.jvmtool.stacktrace.StackFrame;
import org.gridkit.jvmtool.stacktrace.StackFrameArray;
import org.gridkit.jvmtool.stacktrace.StackFrameList;
import org.netbeans.lib.profiler.results.CCTNode;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNode;

public class DirectNpsEventAdapter
implements EventReader<Event> {
    public static final String NODE_WEIGHT = "netbeans.sampleWeight";
    private final CPUResultsSnapshot snapshot;
    private StackFrame[] frameCache = new StackFrame[256];
    private TreeWalkNode root;
    private TreeWalkNode lastNode;
    private long begingTime;
    private ThreadSnapshotEventPojo nextEvent;

    public DirectNpsEventAdapter(CPUResultsSnapshot snapshot) {
        this.snapshot = snapshot;
        this.begingTime = snapshot.getBeginTime();
        this.init();
        if (this.lastNode.parent != null) {
            this.nextEvent = new ThreadSnapshotEventPojo();
            this.initEvent(this.nextEvent);
        }
    }

    private void seek() {
        this.nextEvent = new ThreadSnapshotEventPojo();
        if (!this.next(this.nextEvent)) {
            this.nextEvent = null;
        }
    }

    public Iterator<Event> iterator() {
        return this;
    }

    public boolean hasNext() {
        return this.nextEvent != null;
    }

    public Event next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ThreadSnapshotEventPojo e = this.nextEvent;
        this.seek();
        return e;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public <M extends Event> EventReader<M> morph(EventMorpher<Event, M> morpher) {
        return new MorphingEventReader((EventReader)this, morpher);
    }

    public Event peekNext() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.nextEvent;
    }

    public void dispose() {
    }

    private void init() {
        PrestimeCPUCCTNode root = this.snapshot.getRootNode(0);
        this.root = new TreeWalkNode(null, root);
    }

    public boolean next(ThreadSnapshotEventPojo pojo) {
        if (!this.nextEvent()) {
            return false;
        }
        this.initEvent(pojo);
        return true;
    }

    private void initEvent(ThreadSnapshotEventPojo pojo) {
        pojo.stackTrace((StackFrameList)new StackFrameArray(this.lastNode.trace));
        pojo.threadId((long)this.lastNode.threadId);
        pojo.threadName(this.snapshot.getThreadNameForId(this.lastNode.threadId));
        pojo.timestamp(this.begingTime);
        pojo.counters().set(NODE_WEIGHT, this.lastNode.getSelfTime());
    }

    private boolean nextEvent() {
        TreeWalkNode c = this.lastNode.parent;
        while (c != null) {
            if (c.initNextChild()) {
                return true;
            }
            c = c.parent;
        }
        return false;
    }

    private StackFrame frame(int id) {
        if (this.frameCache.length <= id) {
            this.frameCache = Arrays.copyOf(this.frameCache, Math.max(2 * this.frameCache.length, id + 1));
        }
        if (this.frameCache[id] == null) {
            StackFrame sf;
            String[] mi = this.snapshot.getMethodClassNameAndSig(id, 0);
            String cn = mi[0];
            String m = mi[1];
            boolean ntv = false;
            if (m.endsWith("[native]")) {
                ntv = true;
                m = m.substring(0, m.length() - "[native]".length());
            }
            this.frameCache[id] = sf = new StackFrame("", cn, m, null, ntv ? -2 : -1);
        }
        return this.frameCache[id];
    }

    private class TreeWalkNode {
        private TreeWalkNode parent;
        private int threadId;
        private PrestimeCPUCCTNode srcNode;
        private int frameDepth;
        private int frameRef;
        private int nextChild;
        private boolean reportSelf = true;
        private StackFrame[] trace;

        public TreeWalkNode(TreeWalkNode parent, PrestimeCPUCCTNode node) {
            this.parent = parent;
            this.threadId = 0;
            this.srcNode = node;
            this.frameDepth = 0;
            this.frameRef = 0;
            this.nextChild = 0;
            if (parent != null) {
                if (parent.parent == null) {
                    this.threadId = node.getThreadId();
                } else {
                    this.threadId = parent.threadId;
                    this.frameRef = node.getMethodId();
                    if (this.frameRef != 0) {
                        this.frameDepth = parent.frameDepth + 1;
                    }
                }
            }
            DirectNpsEventAdapter.this.lastNode = this;
            if (!this.initNextChild()) {
                this.initTrace();
            }
        }

        public long getSelfTime() {
            long totalTime = this.srcNode.getTotalTime0();
            long childrenTime = 0L;
            if (this.srcNode.getNChildren() > 0) {
                for (CCTNode node : this.srcNode.getChildren()) {
                    PrestimeCPUCCTNode cnode;
                    if (!(node instanceof PrestimeCPUCCTNode) || (cnode = (PrestimeCPUCCTNode)node).isSelfTimeNode()) continue;
                    childrenTime += cnode.getTotalTime0();
                }
            }
            return totalTime - childrenTime;
        }

        protected boolean initNextChild() {
            while (this.nextChild < this.srcNode.getNChildren()) {
                PrestimeCPUCCTNode cnode;
                CCTNode node = this.srcNode.getChild(this.nextChild);
                ++this.nextChild;
                if (!(node instanceof PrestimeCPUCCTNode) || (cnode = (PrestimeCPUCCTNode)node).isSelfTimeNode()) continue;
                new TreeWalkNode(this, cnode);
                return true;
            }
            if (this.getSelfTime() > 0L && this.reportSelf) {
                this.reportSelf = false;
                this.initTrace();
                DirectNpsEventAdapter.this.lastNode = this;
                return true;
            }
            return false;
        }

        private void initTrace() {
            this.trace = new StackFrame[this.frameDepth];
            int n = 0;
            TreeWalkNode tn = this;
            while (tn != null) {
                if (tn.frameRef != 0) {
                    this.trace[n++] = DirectNpsEventAdapter.this.frame(tn.frameRef);
                }
                tn = tn.parent;
            }
        }
    }
}

