/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.splitWord.analysis;

import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.ansj.domain.Result;
import org.ansj.domain.Term;
import org.ansj.recognition.arrimpl.NumRecognition;
import org.ansj.recognition.arrimpl.PersonRecognition;
import org.ansj.recognition.arrimpl.UserDefineRecognition;
import org.ansj.splitWord.Analysis;
import org.ansj.util.AnsjReader;
import org.ansj.util.Graph;
import org.ansj.util.TermUtil;
import org.nlpcn.commons.lang.tire.domain.Forest;

public class ToAnalysis
extends Analysis {
    @Override
    protected List<Term> getResult(final Graph graph) {
        Analysis.Merger merger = new Analysis.Merger(){

            @Override
            public List<Term> merger() {
                graph.walkPath();
                if (graph.hasPerson && ToAnalysis.this.isNameRecognition) {
                    new PersonRecognition().recognition(graph);
                }
                if (ToAnalysis.this.isNumRecognition) {
                    new NumRecognition(ToAnalysis.this.isQuantifierRecognition && graph.hasNumQua).recognition(graph);
                }
                this.userDefineRecognition(graph, ToAnalysis.this.forests);
                return this.getResult();
            }

            private void userDefineRecognition(Graph graph2, Forest ... forests) {
                new UserDefineRecognition(TermUtil.InsertTermType.SKIP, forests).recognition(graph2);
                graph2.rmLittlePath();
                graph2.walkPathByScore();
            }

            private List<Term> getResult() {
                ArrayList<Term> result = new ArrayList<Term>();
                int length = graph.terms.length - 1;
                for (int i = 0; i < length; ++i) {
                    if (graph.terms[i] == null) continue;
                    ToAnalysis.this.setIsNewWord(graph.terms[i]);
                    result.add(graph.terms[i]);
                }
                ToAnalysis.this.setRealName(graph, result);
                return result;
            }
        };
        return merger.merger();
    }

    public ToAnalysis() {
    }

    public ToAnalysis(Reader reader) {
        super.resetContent(new AnsjReader(reader));
    }

    public static Result parse(String str) {
        return new ToAnalysis().parseStr(str);
    }

    public static Result parse(String str, Forest ... forests) {
        return new ToAnalysis().setForests(forests).parseStr(str);
    }
}

