/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.util;

import java.util.AbstractQueue;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hugegraph.store.util.DefaultThreadFactory;

public final class ExecutorUtil {
    private static final Map<String, ThreadPoolExecutor> pools = new ConcurrentHashMap<String, ThreadPoolExecutor>();

    public static ThreadPoolExecutor getThreadPoolExecutor(String name) {
        if (name == null) {
            return null;
        }
        return pools.get(name);
    }

    public static ThreadPoolExecutor createExecutor(String name, int coreThreads, int maxThreads, int queueSize) {
        return ExecutorUtil.createExecutor(name, coreThreads, maxThreads, queueSize, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ThreadPoolExecutor createExecutor(String name, int coreThreads, int maxThreads, int queueSize, boolean daemon) {
        if (coreThreads <= 0 || maxThreads <= 0) {
            throw new IllegalArgumentException("coreThreads and maxThreads must be positive");
        }
        if (coreThreads > maxThreads) {
            throw new IllegalArgumentException("coreThreads cannot be greater than maxThreads");
        }
        ThreadPoolExecutor res = pools.get(name);
        if (res != null) {
            return res;
        }
        Map<String, ThreadPoolExecutor> map = pools;
        synchronized (map) {
            res = pools.get(name);
            if (res != null) {
                return res;
            }
            AbstractQueue queue = queueSize <= 0 ? new SynchronousQueue() : new LinkedBlockingQueue(queueSize);
            res = new ThreadPoolExecutor(coreThreads, maxThreads, 60L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)((Object)queue), new DefaultThreadFactory(name, daemon));
            pools.put(name, res);
        }
        return res;
    }

    public static void shutdown(String name, boolean now) {
        if (name == null) {
            return;
        }
        ThreadPoolExecutor executor = pools.remove(name);
        if (executor != null) {
            if (now) {
                executor.shutdownNow();
            } else {
                executor.shutdown();
            }
        }
    }

    public static void shutDownAll(boolean now) {
        for (Map.Entry<String, ThreadPoolExecutor> entry : pools.entrySet()) {
            ThreadPoolExecutor executor = entry.getValue();
            if (now) {
                executor.shutdownNow();
            } else {
                executor.shutdown();
            }
            pools.clear();
        }
    }
}

