/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.service;

import com.google.protobuf.GeneratedMessageV3;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.hugegraph.pd.ConfigService;
import org.apache.hugegraph.pd.LogService;
import org.apache.hugegraph.pd.PartitionService;
import org.apache.hugegraph.pd.StoreMonitorDataService;
import org.apache.hugegraph.pd.StoreNodeService;
import org.apache.hugegraph.pd.TaskScheduleService;
import org.apache.hugegraph.pd.common.HgAssert;
import org.apache.hugegraph.pd.common.KVPair;
import org.apache.hugegraph.pd.common.PDException;
import org.apache.hugegraph.pd.grpc.Metapb;
import org.apache.hugegraph.pd.grpc.Pdpb;
import org.apache.hugegraph.pd.grpc.discovery.NodeInfo;
import org.apache.hugegraph.pd.grpc.discovery.NodeInfos;
import org.apache.hugegraph.pd.grpc.discovery.Query;
import org.apache.hugegraph.pd.grpc.discovery.RegisterInfo;
import org.apache.hugegraph.pd.model.RegistryRestRequest;
import org.apache.hugegraph.pd.model.RegistryRestResponse;
import org.apache.hugegraph.pd.service.DiscoveryService;
import org.apache.hugegraph.pd.service.PDRestService;
import org.apache.hugegraph.pd.service.PDService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PDRestService
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(PDRestService.class);
    private static final String EMPTY_STRING = "";
    @Autowired
    PDService pdService;
    @Autowired
    DiscoveryService discoveryService;
    private StoreNodeService storeNodeService;
    private PartitionService partitionService;
    private TaskScheduleService monitorService;
    private ConfigService configService;
    private LogService logService;
    private StoreMonitorDataService storeMonitorDataService;

    public void afterPropertiesSet() throws Exception {
        this.storeNodeService = this.pdService.getStoreNodeService();
        this.partitionService = this.pdService.getPartitionService();
        this.monitorService = this.pdService.getTaskService();
        this.configService = this.pdService.getConfigService();
        this.logService = this.pdService.getLogService();
        this.storeMonitorDataService = this.pdService.getStoreMonitorDataService();
        HgAssert.isNotNull((Object)this.storeNodeService, (String)"storeNodeService does not initialize");
        HgAssert.isNotNull((Object)this.partitionService, (String)"partitionService does not initialize");
    }

    public List<Metapb.Store> getStores(String graphName) throws PDException {
        return this.storeNodeService.getStores(graphName);
    }

    public Metapb.Store getStore(long storeId) throws PDException {
        return this.storeNodeService.getStore(storeId);
    }

    public List<Metapb.ShardGroup> getShardGroups() throws PDException {
        return this.storeNodeService.getShardGroups();
    }

    public Metapb.Store updateStore(Metapb.Store store) throws PDException {
        this.logService.insertLog("NODE_CHANGE", "REST", (GeneratedMessageV3)store);
        return this.storeNodeService.updateStore(store);
    }

    public boolean removeStore(Long storeId) throws PDException {
        if (storeId == null) {
            return false;
        }
        return 0L != this.storeNodeService.removeStore(storeId);
    }

    public Metapb.GraphSpace setGraphSpace(Metapb.GraphSpace graphSpace) throws PDException {
        return this.configService.setGraphSpace(graphSpace);
    }

    public List<Metapb.GraphSpace> getGraphSpaces() throws PDException {
        return this.configService.getGraphSpace(EMPTY_STRING);
    }

    public Metapb.GraphSpace getGraphSpace(String graphSpaceName) throws PDException {
        return (Metapb.GraphSpace)this.configService.getGraphSpace(graphSpaceName).get(0);
    }

    public List<Metapb.Graph> getGraphs() throws PDException {
        return this.partitionService.getGraphs();
    }

    public Metapb.Graph getGraph(String graphName) throws PDException {
        return this.partitionService.getGraph(graphName);
    }

    public Metapb.Graph updateGraph(Metapb.Graph graph) throws PDException {
        return this.partitionService.updateGraph(graph);
    }

    public List<Metapb.Partition> getPartitions(String graphName) {
        return this.partitionService.getPartitions(graphName);
    }

    public Map<Integer, Metapb.ShardGroup> getShardGroupCache() {
        return this.partitionService.getShardGroupCache();
    }

    public List<Metapb.Store> patrolStores() throws PDException {
        return this.monitorService.patrolStores();
    }

    public List<Metapb.Partition> patrolPartitions() throws PDException {
        return this.monitorService.patrolPartitions();
    }

    public Metapb.PartitionStats getPartitionStats(String graphName, int partitionId) throws PDException {
        return this.partitionService.getPartitionStats(graphName, partitionId);
    }

    public List<Metapb.PartitionStats> getPartitionStatus(String graphName) throws PDException {
        return this.partitionService.getPartitionStatus(graphName);
    }

    public Map<Integer, KVPair<Long, Long>> balancePartitions() throws PDException {
        return this.monitorService.balancePartitionShard();
    }

    public List<Metapb.Partition> splitPartitions() throws PDException {
        return this.monitorService.autoSplitPartition();
    }

    public List<Metapb.Store> getStoreStats(boolean isActive) throws PDException {
        return this.storeNodeService.getStoreStatus(isActive);
    }

    public List<Map<String, Long>> getMonitorData(long storeId) throws PDException {
        return this.storeMonitorDataService.getStoreMonitorData(storeId);
    }

    public String getMonitorDataText(long storeId) throws PDException {
        return this.storeMonitorDataService.getStoreMonitorDataText(storeId);
    }

    public RegistryRestResponse register(NodeInfo nodeInfo) throws PDException {
        CountDownLatch latch = new CountDownLatch(1);
        RegisterInfo[] info = new RegisterInfo[]{null};
        RegistryRestResponse response = new RegistryRestResponse();
        try {
            1 observer = new /* Unavailable Anonymous Inner Class!! */;
            this.discoveryService.register(nodeInfo, (StreamObserver)observer);
            latch.await();
            Pdpb.Error error = info[0].getHeader().getError();
            response.setErrorType(error.getType());
            response.setMessage(error.getMessage());
        }
        catch (InterruptedException e) {
            response.setErrorType(Pdpb.ErrorType.UNRECOGNIZED);
            response.setMessage(e.getMessage());
        }
        return response;
    }

    public ArrayList<RegistryRestRequest> getNodeInfo(Query request) throws PDException {
        CountDownLatch latch = new CountDownLatch(1);
        NodeInfos[] info = new NodeInfos[]{null};
        RegistryRestResponse response = new RegistryRestResponse();
        ArrayList<RegistryRestRequest> registryRestRequests = null;
        try {
            2 observer = new /* Unavailable Anonymous Inner Class!! */;
            this.discoveryService.getNodes(request, (StreamObserver)observer);
            latch.await();
            List infoList = info[0].getInfoList();
            registryRestRequests = new ArrayList<RegistryRestRequest>(infoList.size());
            for (int i = 0; i < infoList.size(); ++i) {
                NodeInfo element = (NodeInfo)infoList.get(i);
                RegistryRestRequest registryRestRequest = new RegistryRestRequest();
                registryRestRequest.setAddress(element.getAddress());
                registryRestRequest.setAppName(element.getAppName());
                registryRestRequest.setVersion(element.getVersion());
                registryRestRequest.setInterval(String.valueOf(element.getInterval()));
                HashMap labels = new HashMap();
                labels.putAll(element.getLabelsMap());
                registryRestRequest.setLabels(labels);
                registryRestRequests.add(registryRestRequest);
            }
        }
        catch (InterruptedException e) {
            response.setErrorType(Pdpb.ErrorType.UNRECOGNIZED);
            response.setMessage(e.getMessage());
        }
        return registryRestRequests;
    }

    public List<Metapb.LogRecord> getStoreStatusLog(Long start, Long end) throws PDException {
        return this.logService.getLog("NODE_CHANGE", start, end);
    }

    public List<Metapb.LogRecord> getPartitionLog(Long start, Long end) throws PDException {
        return this.logService.getLog("PARTITION_CHANGE", start, end);
    }

    public Map<Integer, Long> balancePartitionLeader() throws PDException {
        return this.monitorService.balancePartitionLeader(true);
    }

    public void dbCompaction() throws PDException {
        this.monitorService.dbCompaction(EMPTY_STRING);
    }

    public List<Metapb.Shard> getShardList(int partitionId) throws PDException {
        return this.storeNodeService.getShardList(partitionId);
    }

    public void resetPartitionState(Metapb.Partition partition) throws PDException {
        this.partitionService.updatePartitionState(partition.getGraphName(), partition.getId(), Metapb.PartitionState.PState_Normal);
    }
}

