/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.sink;

import org.apache.paimon.codegen.CodeGenUtils;
import org.apache.paimon.codegen.Projection;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.sink.KeyAndBucketExtractor;
import org.apache.paimon.table.sink.RowPartitionKeyExtractor;

public abstract class RowKeyExtractor
implements KeyAndBucketExtractor<InternalRow> {
    private final RowPartitionKeyExtractor partitionKeyExtractor;
    private final Projection logPrimaryKeyProjection;
    protected InternalRow record;
    private BinaryRow partition;
    private BinaryRow trimmedPrimaryKey;
    private BinaryRow logPrimaryKey;

    public RowKeyExtractor(TableSchema schema) {
        this.partitionKeyExtractor = new RowPartitionKeyExtractor(schema);
        this.logPrimaryKeyProjection = CodeGenUtils.newProjection(schema.logicalRowType(), schema.projection(schema.primaryKeys()));
    }

    @Override
    public void setRecord(InternalRow record) {
        this.record = record;
        this.partition = null;
        this.trimmedPrimaryKey = null;
        this.logPrimaryKey = null;
    }

    @Override
    public BinaryRow partition() {
        if (this.partition == null) {
            this.partition = this.partitionKeyExtractor.partition(this.record);
        }
        return this.partition;
    }

    @Override
    public BinaryRow trimmedPrimaryKey() {
        if (this.trimmedPrimaryKey == null) {
            this.trimmedPrimaryKey = this.partitionKeyExtractor.trimmedPrimaryKey(this.record);
        }
        return this.trimmedPrimaryKey;
    }

    @Override
    public BinaryRow logPrimaryKey() {
        if (this.logPrimaryKey == null) {
            this.logPrimaryKey = this.logPrimaryKeyProjection.apply(this.record);
        }
        return this.logPrimaryKey;
    }
}

