/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.shade.org.apache.parquet.hadoop.example;

import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.paimon.shade.org.apache.parquet.conf.HadoopParquetConfiguration;
import org.apache.paimon.shade.org.apache.parquet.conf.ParquetConfiguration;
import org.apache.paimon.shade.org.apache.parquet.example.data.Group;
import org.apache.paimon.shade.org.apache.parquet.example.data.simple.convert.GroupRecordConverter;
import org.apache.paimon.shade.org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.paimon.shade.org.apache.parquet.io.api.RecordMaterializer;
import org.apache.paimon.shade.org.apache.parquet.schema.MessageType;

public class GroupReadSupport
extends ReadSupport<Group> {
    @Override
    public ReadSupport.ReadContext init(Configuration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema) {
        return this.init(new HadoopParquetConfiguration(configuration), keyValueMetaData, fileSchema);
    }

    @Override
    public ReadSupport.ReadContext init(ParquetConfiguration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema) {
        String partialSchemaString = configuration.get("parquet.read.schema");
        MessageType requestedProjection = GroupReadSupport.getSchemaForRead(fileSchema, partialSchemaString);
        return new ReadSupport.ReadContext(requestedProjection);
    }

    @Override
    public RecordMaterializer<Group> prepareForRead(Configuration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema, ReadSupport.ReadContext readContext) {
        return new GroupRecordConverter(readContext.getRequestedSchema());
    }

    @Override
    public RecordMaterializer<Group> prepareForRead(ParquetConfiguration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema, ReadSupport.ReadContext readContext) {
        return new GroupRecordConverter(readContext.getRequestedSchema());
    }
}

