/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.shade.org.apache.hadoop.hive.common;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.codehaus.jackson.map.ObjectMapper;

public class AcidMetaDataFile {
    public static final String METADATA_FILE = "_metadata_acid";
    public static final String CURRENT_VERSION = "0";

    public static void writeToFile(FileSystem fs, Path basePath, DataFormat format) throws IOException {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put(Field.VERSION.toString(), CURRENT_VERSION);
        metadata.put(Field.DATA_FORMAT.toString(), format.toString());
        String data = new ObjectMapper().writeValueAsString(metadata);
        try (FSDataOutputStream out = fs.create(new Path(basePath, METADATA_FILE));
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, "UTF-8");){
            writer.write(data);
            writer.flush();
        }
    }

    public static enum DataFormat {
        COMPACTED,
        TRUNCATED;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum Field {
        VERSION("thisFileVersion"),
        DATA_FORMAT("dataFormat");

        private final String fieldName;

        private Field(String fieldName) {
            this.fieldName = fieldName;
        }

        public String toString() {
            return this.fieldName;
        }
    }
}

