/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.disk;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.paimon.disk.FileChannelManager;
import org.apache.paimon.disk.FileIOChannel;
import org.apache.paimon.utils.FileIOUtils;
import org.apache.paimon.utils.IOUtils;
import org.apache.paimon.utils.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileChannelManagerImpl
implements FileChannelManager {
    private static final Logger LOG = LoggerFactory.getLogger(FileChannelManagerImpl.class);
    private final File[] paths;
    private final Random random;
    private final AtomicLong nextPath = new AtomicLong(0L);

    public FileChannelManagerImpl(String[] tempDirs, String prefix) {
        Preconditions.checkNotNull(tempDirs, "The temporary directories must not be null.");
        Preconditions.checkArgument(tempDirs.length > 0, "The temporary directories must not be empty.");
        this.random = new Random();
        this.paths = FileChannelManagerImpl.createFiles(tempDirs, prefix);
        LOG.info("Created a new {} for spilling of task related data to disk (joins, sorting, ...). Used directories:\n\t{}", (Object)FileChannelManager.class.getSimpleName(), (Object)String.join((CharSequence)"\n\t", tempDirs));
    }

    private static File[] createFiles(String[] tempDirs, String prefix) {
        ArrayList<File> filesList = new ArrayList<File>();
        for (String tempDir : tempDirs) {
            File baseDir = new File(tempDir);
            String subfolder = String.format("paimon-%s-%s", prefix, UUID.randomUUID());
            File storageDir = new File(baseDir, subfolder);
            if (!storageDir.exists() && !storageDir.mkdirs()) {
                LOG.warn("Failed to create directory {}, temp directory {} will not be used", (Object)storageDir.getAbsolutePath(), (Object)tempDir);
                continue;
            }
            filesList.add(storageDir);
            LOG.debug("FileChannelManager uses directory {} for spill files.", (Object)storageDir.getAbsolutePath());
        }
        if (filesList.isEmpty()) {
            throw new RuntimeException("No available temporary directories");
        }
        return filesList.toArray(new File[0]);
    }

    @Override
    public FileIOChannel.ID createChannel() {
        int num = (int)(this.nextPath.getAndIncrement() % (long)this.paths.length);
        return new FileIOChannel.ID(this.paths[num], num, this.random);
    }

    @Override
    public FileIOChannel.ID createChannel(String prefix) {
        int num = (int)(this.nextPath.getAndIncrement() % (long)this.paths.length);
        return new FileIOChannel.ID(this.paths[num], num, prefix, this.random);
    }

    @Override
    public FileIOChannel.Enumerator createChannelEnumerator() {
        return new FileIOChannel.Enumerator(this.paths, this.random);
    }

    @Override
    public File[] getPaths() {
        return Arrays.copyOf(this.paths, this.paths.length);
    }

    @Override
    public void close() throws Exception {
        IOUtils.closeAll(Arrays.stream(this.paths).filter(File::exists).map(this::getFileCloser).collect(Collectors.toList()));
        LOG.info("Closed {} with directories:\n\t{}", (Object)FileChannelManager.class.getSimpleName(), (Object)Arrays.stream(this.paths).map(File::getAbsolutePath).collect(Collectors.joining("\n\t")));
    }

    private AutoCloseable getFileCloser(File path) {
        return () -> {
            try {
                FileIOUtils.deleteDirectory(path);
                LOG.info("FileChannelManager removed spill file directory {}", (Object)path.getAbsolutePath());
            }
            catch (IOException e) {
                String errorMessage = String.format("FileChannelManager failed to properly clean up temp file directory: %s", path);
                throw new UncheckedIOException(errorMessage, e);
            }
        };
    }
}

