/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.data.variant;

import java.io.IOException;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Base64;
import java.util.Locale;
import java.util.Objects;
import org.apache.paimon.data.variant.GenericVariantBuilder;
import org.apache.paimon.data.variant.GenericVariantUtil;
import org.apache.paimon.data.variant.PathSegment;
import org.apache.paimon.data.variant.Variant;

public final class GenericVariant
implements Variant {
    private final byte[] value;
    private final byte[] metadata;
    private final int pos;
    private static final DateTimeFormatter TIMESTAMP_NTZ_FORMATTER = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').append(DateTimeFormatter.ISO_LOCAL_TIME).toFormatter(Locale.US);
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = new DateTimeFormatterBuilder().append(TIMESTAMP_NTZ_FORMATTER).appendOffset("+HH:MM", "+00:00").toFormatter(Locale.US);

    public GenericVariant(byte[] value, byte[] metadata) {
        this(value, metadata, 0);
    }

    private GenericVariant(byte[] value, byte[] metadata, int pos) {
        this.value = value;
        this.metadata = metadata;
        this.pos = pos;
        if (metadata.length < 1 || (metadata[0] & 0xF) != 1) {
            throw GenericVariantUtil.malformedVariant();
        }
        if (metadata.length > 0x1000000 || value.length > 0x1000000) {
            throw GenericVariantUtil.variantConstructorSizeLimit();
        }
    }

    @Override
    public byte[] value() {
        if (this.pos == 0) {
            return this.value;
        }
        int size = GenericVariantUtil.valueSize(this.value, this.pos);
        GenericVariantUtil.checkIndex(this.pos + size - 1, this.value.length);
        return Arrays.copyOfRange(this.value, this.pos, this.pos + size);
    }

    public byte[] rawValue() {
        return this.value;
    }

    @Override
    public byte[] metadata() {
        return this.metadata;
    }

    public int pos() {
        return this.pos;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenericVariant that = (GenericVariant)o;
        return this.pos == that.pos && Objects.deepEquals(this.value, that.value) && Objects.deepEquals(this.metadata, that.metadata);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.value), Arrays.hashCode(this.metadata), this.pos);
    }

    public static Variant fromJson(String json) {
        try {
            return GenericVariantBuilder.parseJson(json, false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String toJson() {
        return this.toJson(ZoneOffset.UTC);
    }

    public String toJson(ZoneId zoneId) {
        StringBuilder sb = new StringBuilder();
        GenericVariant.toJsonImpl(this.value, this.metadata, this.pos, sb, zoneId);
        return sb.toString();
    }

    public String toString() {
        return this.toJson();
    }

    @Override
    public Object variantGet(String path) {
        PathSegment[] parsedPath;
        GenericVariant v = this;
        for (PathSegment pathSegment : parsedPath = PathSegment.parse(path)) {
            if (pathSegment.isKey() && v.getType() == GenericVariantUtil.Type.OBJECT) {
                v = v.getFieldByKey(pathSegment.getKey());
                continue;
            }
            if (pathSegment.isIndex() && v.getType() == GenericVariantUtil.Type.ARRAY) {
                v = v.getElementAtIndex(pathSegment.getIndex());
                continue;
            }
            return null;
        }
        switch (v.getType()) {
            case OBJECT: 
            case ARRAY: {
                return v.toJson();
            }
            case STRING: {
                return v.getString();
            }
            case LONG: {
                return v.getLong();
            }
            case DOUBLE: {
                return v.getDouble();
            }
            case DECIMAL: {
                return v.getDecimal();
            }
            case BOOLEAN: {
                return v.getBoolean();
            }
            case NULL: {
                return null;
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + (Object)((Object)v.getType()));
    }

    @Override
    public long sizeInBytes() {
        return this.metadata.length + this.value.length;
    }

    @Override
    public Variant copy() {
        return new GenericVariant(Arrays.copyOf(this.value, this.value.length), Arrays.copyOf(this.metadata, this.metadata.length), this.pos);
    }

    public boolean getBoolean() {
        return GenericVariantUtil.getBoolean(this.value, this.pos);
    }

    public long getLong() {
        return GenericVariantUtil.getLong(this.value, this.pos);
    }

    public double getDouble() {
        return GenericVariantUtil.getDouble(this.value, this.pos);
    }

    public BigDecimal getDecimal() {
        return GenericVariantUtil.getDecimal(this.value, this.pos);
    }

    public float getFloat() {
        return GenericVariantUtil.getFloat(this.value, this.pos);
    }

    public byte[] getBinary() {
        return GenericVariantUtil.getBinary(this.value, this.pos);
    }

    public String getString() {
        return GenericVariantUtil.getString(this.value, this.pos);
    }

    public int getTypeInfo() {
        return GenericVariantUtil.getTypeInfo(this.value, this.pos);
    }

    public GenericVariantUtil.Type getType() {
        return GenericVariantUtil.getType(this.value, this.pos);
    }

    public int objectSize() {
        return GenericVariantUtil.handleObject(this.value, this.pos, (size, idSize, offsetSize, idStart, offsetStart, dataStart) -> size);
    }

    public GenericVariant getFieldByKey(String key) {
        return GenericVariantUtil.handleObject(this.value, this.pos, (size, idSize, offsetSize, idStart, offsetStart, dataStart) -> {
            if (size < 32) {
                for (int i = 0; i < size; ++i) {
                    int id = GenericVariantUtil.readUnsigned(this.value, idStart + idSize * i, idSize);
                    if (!key.equals(GenericVariantUtil.getMetadataKey(this.metadata, id))) continue;
                    int offset = GenericVariantUtil.readUnsigned(this.value, offsetStart + offsetSize * i, offsetSize);
                    return new GenericVariant(this.value, this.metadata, dataStart + offset);
                }
            } else {
                int low = 0;
                int high = size - 1;
                while (low <= high) {
                    int mid = low + high >>> 1;
                    int id = GenericVariantUtil.readUnsigned(this.value, idStart + idSize * mid, idSize);
                    int cmp = GenericVariantUtil.getMetadataKey(this.metadata, id).compareTo(key);
                    if (cmp < 0) {
                        low = mid + 1;
                        continue;
                    }
                    if (cmp > 0) {
                        high = mid - 1;
                        continue;
                    }
                    int offset = GenericVariantUtil.readUnsigned(this.value, offsetStart + offsetSize * mid, offsetSize);
                    return new GenericVariant(this.value, this.metadata, dataStart + offset);
                }
            }
            return null;
        });
    }

    public ObjectField getFieldAtIndex(int index) {
        return GenericVariantUtil.handleObject(this.value, this.pos, (size, idSize, offsetSize, idStart, offsetStart, dataStart) -> {
            if (index < 0 || index >= size) {
                return null;
            }
            int id = GenericVariantUtil.readUnsigned(this.value, idStart + idSize * index, idSize);
            int offset = GenericVariantUtil.readUnsigned(this.value, offsetStart + offsetSize * index, offsetSize);
            String key = GenericVariantUtil.getMetadataKey(this.metadata, id);
            GenericVariant v = new GenericVariant(this.value, this.metadata, dataStart + offset);
            return new ObjectField(key, v);
        });
    }

    public int getDictionaryIdAtIndex(int index) {
        return GenericVariantUtil.handleObject(this.value, this.pos, (size, idSize, offsetSize, idStart, offsetStart, dataStart) -> {
            if (index < 0 || index >= size) {
                throw GenericVariantUtil.malformedVariant();
            }
            return GenericVariantUtil.readUnsigned(this.value, idStart + idSize * index, idSize);
        });
    }

    public int arraySize() {
        return GenericVariantUtil.handleArray(this.value, this.pos, (size, offsetSize, offsetStart, dataStart) -> size);
    }

    public GenericVariant getElementAtIndex(int index) {
        return GenericVariantUtil.handleArray(this.value, this.pos, (size, offsetSize, offsetStart, dataStart) -> {
            if (index < 0 || index >= size) {
                return null;
            }
            int offset = GenericVariantUtil.readUnsigned(this.value, offsetStart + offsetSize * index, offsetSize);
            return new GenericVariant(this.value, this.metadata, dataStart + offset);
        });
    }

    /*
     * Exception decompiling
     */
    private static String escapeJson(String str) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static void appendQuoted(StringBuilder sb, String str) {
        sb.append('\"');
        sb.append(str);
        sb.append('\"');
    }

    private static Instant microsToInstant(long timestamp) {
        return Instant.EPOCH.plus(timestamp, ChronoUnit.MICROS);
    }

    private static void toJsonImpl(byte[] value, byte[] metadata, int pos, StringBuilder sb, ZoneId zoneId) {
        switch (GenericVariantUtil.getType(value, pos)) {
            case OBJECT: {
                GenericVariantUtil.handleObject(value, pos, (size, idSize, offsetSize, idStart, offsetStart, dataStart) -> {
                    sb.append('{');
                    for (int i = 0; i < size; ++i) {
                        int id = GenericVariantUtil.readUnsigned(value, idStart + idSize * i, idSize);
                        int offset = GenericVariantUtil.readUnsigned(value, offsetStart + offsetSize * i, offsetSize);
                        int elementPos = dataStart + offset;
                        if (i != 0) {
                            sb.append(',');
                        }
                        sb.append(GenericVariant.escapeJson(GenericVariantUtil.getMetadataKey(metadata, id)));
                        sb.append(':');
                        GenericVariant.toJsonImpl(value, metadata, elementPos, sb, zoneId);
                    }
                    sb.append('}');
                    return null;
                });
                break;
            }
            case ARRAY: {
                GenericVariantUtil.handleArray(value, pos, (size, offsetSize, offsetStart, dataStart) -> {
                    sb.append('[');
                    for (int i = 0; i < size; ++i) {
                        int offset = GenericVariantUtil.readUnsigned(value, offsetStart + offsetSize * i, offsetSize);
                        int elementPos = dataStart + offset;
                        if (i != 0) {
                            sb.append(',');
                        }
                        GenericVariant.toJsonImpl(value, metadata, elementPos, sb, zoneId);
                    }
                    sb.append(']');
                    return null;
                });
                break;
            }
            case NULL: {
                sb.append("null");
                break;
            }
            case BOOLEAN: {
                sb.append(GenericVariantUtil.getBoolean(value, pos));
                break;
            }
            case LONG: {
                sb.append(GenericVariantUtil.getLong(value, pos));
                break;
            }
            case STRING: {
                sb.append(GenericVariant.escapeJson(GenericVariantUtil.getString(value, pos)));
                break;
            }
            case DOUBLE: {
                sb.append(GenericVariantUtil.getDouble(value, pos));
                break;
            }
            case DECIMAL: {
                sb.append(GenericVariantUtil.getDecimal(value, pos).toPlainString());
                break;
            }
            case DATE: {
                GenericVariant.appendQuoted(sb, LocalDate.ofEpochDay((int)GenericVariantUtil.getLong(value, pos)).toString());
                break;
            }
            case TIMESTAMP: {
                GenericVariant.appendQuoted(sb, TIMESTAMP_FORMATTER.format(GenericVariant.microsToInstant(GenericVariantUtil.getLong(value, pos)).atZone(zoneId)));
                break;
            }
            case TIMESTAMP_NTZ: {
                GenericVariant.appendQuoted(sb, TIMESTAMP_NTZ_FORMATTER.format(GenericVariant.microsToInstant(GenericVariantUtil.getLong(value, pos)).atZone(ZoneOffset.UTC)));
                break;
            }
            case FLOAT: {
                sb.append(GenericVariantUtil.getFloat(value, pos));
                break;
            }
            case BINARY: {
                GenericVariant.appendQuoted(sb, Base64.getEncoder().encodeToString(GenericVariantUtil.getBinary(value, pos)));
            }
        }
    }

    public static final class ObjectField {
        public final String key;
        public final Variant value;

        public ObjectField(String key, Variant value) {
            this.key = key;
            this.value = value;
        }
    }
}

