/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.data;

import java.io.EOFException;
import org.apache.paimon.data.AbstractPagedOutputView;
import org.apache.paimon.memory.MemorySegment;

public class RandomAccessOutputView
extends AbstractPagedOutputView {
    private final MemorySegment[] segments;
    private int currentSegmentIndex;

    public RandomAccessOutputView(MemorySegment[] segments, int segmentSize) {
        super(segments[0], segmentSize);
        if ((segmentSize & segmentSize - 1) != 0) {
            throw new IllegalArgumentException("Segment size must be a power of 2!");
        }
        this.segments = segments;
    }

    @Override
    protected MemorySegment nextSegment(MemorySegment current, int positionInCurrent) throws EOFException {
        if (++this.currentSegmentIndex < this.segments.length) {
            return this.segments[this.currentSegmentIndex];
        }
        throw new EOFException();
    }
}

