/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.security.spec.RSAPublicKeySpec;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSKEYRecord;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.Header;
import org.xbill.DNS.KEYBase;
import org.xbill.DNS.KEYRecord;
import org.xbill.DNS.Message;
import org.xbill.DNS.Mnemonic;
import org.xbill.DNS.Name;
import org.xbill.DNS.RRSIGRecord;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;
import org.xbill.DNS.SIGBase;
import org.xbill.DNS.SIGRecord;

public class DNSSEC {
    private static final ECKeyInfo GOST = new ECKeyInfo(32, "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFD97", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFD94", "A6", "1", "8D91E471E0989CDA27DF505A453F2B7635294F2DDF23E3B122ACC99C9E9F1E14", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF6C611070995AD10045841B09B761B893");
    private static final ECKeyInfo ECDSA_P256 = new ECKeyInfo(32, "FFFFFFFF00000001000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF", "FFFFFFFF00000001000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFC", "5AC635D8AA3A93E7B3EBBD55769886BC651D06B0CC53B0F63BCE3C3E27D2604B", "6B17D1F2E12C4247F8BCE6E563A440F277037D812DEB33A0F4A13945D898C296", "4FE342E2FE1A7F9B8EE7EB4A7C0F9E162BCE33576B315ECECBB6406837BF51F5", "FFFFFFFF00000000FFFFFFFFFFFFFFFFBCE6FAADA7179E84F3B9CAC2FC632551");
    private static final ECKeyInfo ECDSA_P384 = new ECKeyInfo(48, "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFF0000000000000000FFFFFFFF", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFF0000000000000000FFFFFFFC", "B3312FA7E23EE7E4988E056BE3F82D19181D9C6EFE8141120314088F5013875AC656398D8A2ED19D2A85C8EDD3EC2AEF", "AA87CA22BE8B05378EB1C71EF320AD746E1D3B628BA79B9859F741E082542A385502F25DBF55296C3A545E3872760AB7", "3617DE4A96262C6F5D9E98BF9292DC29F8F41DBD289A147CE9DA3113B5F0B8C00A60B1CE1D7E819D7A431D7C90EA0E5F", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC7634D81F4372DDF581A0DB248B0A77AECEC196ACCC52973");
    private static final int ASN1_SEQ = 48;
    private static final int ASN1_INT = 2;
    private static final int DSA_LEN = 20;

    private DNSSEC() {
    }

    private static void digestSIG(DNSOutput out, SIGBase sig) {
        out.writeU16(sig.getTypeCovered());
        out.writeU8(sig.getAlgorithm());
        out.writeU8(sig.getLabels());
        out.writeU32(sig.getOrigTTL());
        out.writeU32(sig.getExpire().getTime() / 1000L);
        out.writeU32(sig.getTimeSigned().getTime() / 1000L);
        out.writeU16(sig.getFootprint());
        sig.getSigner().toWireCanonical(out);
    }

    public static byte[] digestRRset(RRSIGRecord rrsig, RRset rrset) {
        DNSOutput out = new DNSOutput();
        DNSSEC.digestSIG(out, rrsig);
        int size = rrset.size();
        Object[] records = new Record[size];
        Iterator it = rrset.rrs();
        Name name = rrset.getName();
        Name wild = null;
        int sigLabels = rrsig.getLabels() + 1;
        if (name.labels() > sigLabels) {
            wild = name.wild(name.labels() - sigLabels);
        }
        while (it.hasNext()) {
            records[--size] = (Record)it.next();
        }
        Arrays.sort(records);
        DNSOutput header = new DNSOutput();
        if (wild != null) {
            wild.toWireCanonical(header);
        } else {
            name.toWireCanonical(header);
        }
        header.writeU16(rrset.getType());
        header.writeU16(rrset.getDClass());
        header.writeU32(rrsig.getOrigTTL());
        for (int i = 0; i < records.length; ++i) {
            out.writeByteArray(header.toByteArray());
            int lengthPosition = out.current();
            out.writeU16(0);
            out.writeByteArray(((Record)records[i]).rdataToWireCanonical());
            int rrlength = out.current() - lengthPosition - 2;
            out.save();
            out.jump(lengthPosition);
            out.writeU16(rrlength);
            out.restore();
        }
        return out.toByteArray();
    }

    public static byte[] digestMessage(SIGRecord sig, Message msg, byte[] previous) {
        DNSOutput out = new DNSOutput();
        DNSSEC.digestSIG(out, sig);
        if (previous != null) {
            out.writeByteArray(previous);
        }
        msg.toWire(out);
        return out.toByteArray();
    }

    private static int BigIntegerLength(BigInteger i) {
        return (i.bitLength() + 7) / 8;
    }

    private static BigInteger readBigInteger(DNSInput in, int len) throws IOException {
        byte[] b = in.readByteArray(len);
        return new BigInteger(1, b);
    }

    private static BigInteger readBigInteger(DNSInput in) {
        byte[] b = in.readByteArray();
        return new BigInteger(1, b);
    }

    private static byte[] trimByteArray(byte[] array) {
        if (array[0] == 0) {
            byte[] trimmedArray = new byte[array.length - 1];
            System.arraycopy(array, 1, trimmedArray, 0, array.length - 1);
            return trimmedArray;
        }
        return array;
    }

    private static void reverseByteArray(byte[] array) {
        for (int i = 0; i < array.length / 2; ++i) {
            int j = array.length - i - 1;
            byte tmp = array[i];
            array[i] = array[j];
            array[j] = tmp;
        }
    }

    private static BigInteger readBigIntegerLittleEndian(DNSInput in, int len) throws IOException {
        byte[] b = in.readByteArray(len);
        DNSSEC.reverseByteArray(b);
        return new BigInteger(1, b);
    }

    private static void writeBigInteger(DNSOutput out, BigInteger val) {
        byte[] b = DNSSEC.trimByteArray(val.toByteArray());
        out.writeByteArray(b);
    }

    private static void writePaddedBigInteger(DNSOutput out, BigInteger val, int len) {
        byte[] b = DNSSEC.trimByteArray(val.toByteArray());
        if (b.length > len) {
            throw new IllegalArgumentException();
        }
        if (b.length < len) {
            byte[] pad = new byte[len - b.length];
            out.writeByteArray(pad);
        }
        out.writeByteArray(b);
    }

    private static void writePaddedBigIntegerLittleEndian(DNSOutput out, BigInteger val, int len) {
        byte[] b = DNSSEC.trimByteArray(val.toByteArray());
        if (b.length > len) {
            throw new IllegalArgumentException();
        }
        DNSSEC.reverseByteArray(b);
        out.writeByteArray(b);
        if (b.length < len) {
            byte[] pad = new byte[len - b.length];
            out.writeByteArray(pad);
        }
    }

    private static PublicKey toRSAPublicKey(KEYBase r) throws IOException, GeneralSecurityException {
        DNSInput in = new DNSInput(r.getKey());
        int exponentLength = in.readU8();
        if (exponentLength == 0) {
            exponentLength = in.readU16();
        }
        BigInteger exponent = DNSSEC.readBigInteger(in, exponentLength);
        BigInteger modulus = DNSSEC.readBigInteger(in);
        KeyFactory factory2 = KeyFactory.getInstance("RSA");
        return factory2.generatePublic(new RSAPublicKeySpec(modulus, exponent));
    }

    private static PublicKey toDSAPublicKey(KEYBase r) throws IOException, GeneralSecurityException, MalformedKeyException {
        DNSInput in = new DNSInput(r.getKey());
        int t = in.readU8();
        if (t > 8) {
            throw new MalformedKeyException(r);
        }
        BigInteger q = DNSSEC.readBigInteger(in, 20);
        BigInteger p = DNSSEC.readBigInteger(in, 64 + t * 8);
        BigInteger g2 = DNSSEC.readBigInteger(in, 64 + t * 8);
        BigInteger y = DNSSEC.readBigInteger(in, 64 + t * 8);
        KeyFactory factory2 = KeyFactory.getInstance("DSA");
        return factory2.generatePublic(new DSAPublicKeySpec(y, p, q, g2));
    }

    private static PublicKey toECGOSTPublicKey(KEYBase r, ECKeyInfo keyinfo) throws IOException, GeneralSecurityException, MalformedKeyException {
        DNSInput in = new DNSInput(r.getKey());
        BigInteger x = DNSSEC.readBigIntegerLittleEndian(in, keyinfo.length);
        BigInteger y = DNSSEC.readBigIntegerLittleEndian(in, keyinfo.length);
        ECPoint q = new ECPoint(x, y);
        KeyFactory factory2 = KeyFactory.getInstance("ECGOST3410");
        return factory2.generatePublic(new ECPublicKeySpec(q, keyinfo.spec));
    }

    private static PublicKey toECDSAPublicKey(KEYBase r, ECKeyInfo keyinfo) throws IOException, GeneralSecurityException, MalformedKeyException {
        DNSInput in = new DNSInput(r.getKey());
        BigInteger x = DNSSEC.readBigInteger(in, keyinfo.length);
        BigInteger y = DNSSEC.readBigInteger(in, keyinfo.length);
        ECPoint q = new ECPoint(x, y);
        KeyFactory factory2 = KeyFactory.getInstance("EC");
        return factory2.generatePublic(new ECPublicKeySpec(q, keyinfo.spec));
    }

    static PublicKey toPublicKey(KEYBase r) throws DNSSECException {
        int alg = r.getAlgorithm();
        try {
            switch (alg) {
                case 1: 
                case 5: 
                case 7: 
                case 8: 
                case 10: {
                    return DNSSEC.toRSAPublicKey(r);
                }
                case 3: 
                case 6: {
                    return DNSSEC.toDSAPublicKey(r);
                }
                case 12: {
                    return DNSSEC.toECGOSTPublicKey(r, GOST);
                }
                case 13: {
                    return DNSSEC.toECDSAPublicKey(r, ECDSA_P256);
                }
                case 14: {
                    return DNSSEC.toECDSAPublicKey(r, ECDSA_P384);
                }
            }
            throw new UnsupportedAlgorithmException(alg);
        }
        catch (IOException e) {
            throw new MalformedKeyException(r);
        }
        catch (GeneralSecurityException e) {
            throw new DNSSECException(e.toString());
        }
    }

    private static byte[] fromRSAPublicKey(RSAPublicKey key) {
        DNSOutput out = new DNSOutput();
        BigInteger exponent = key.getPublicExponent();
        BigInteger modulus = key.getModulus();
        int exponentLength = DNSSEC.BigIntegerLength(exponent);
        if (exponentLength < 256) {
            out.writeU8(exponentLength);
        } else {
            out.writeU8(0);
            out.writeU16(exponentLength);
        }
        DNSSEC.writeBigInteger(out, exponent);
        DNSSEC.writeBigInteger(out, modulus);
        return out.toByteArray();
    }

    private static byte[] fromDSAPublicKey(DSAPublicKey key) {
        DNSOutput out = new DNSOutput();
        BigInteger q = key.getParams().getQ();
        BigInteger p = key.getParams().getP();
        BigInteger g2 = key.getParams().getG();
        BigInteger y = key.getY();
        int t = (p.toByteArray().length - 64) / 8;
        out.writeU8(t);
        DNSSEC.writeBigInteger(out, q);
        DNSSEC.writeBigInteger(out, p);
        DNSSEC.writePaddedBigInteger(out, g2, 8 * t + 64);
        DNSSEC.writePaddedBigInteger(out, y, 8 * t + 64);
        return out.toByteArray();
    }

    private static byte[] fromECGOSTPublicKey(ECPublicKey key, ECKeyInfo keyinfo) {
        DNSOutput out = new DNSOutput();
        BigInteger x = key.getW().getAffineX();
        BigInteger y = key.getW().getAffineY();
        DNSSEC.writePaddedBigIntegerLittleEndian(out, x, keyinfo.length);
        DNSSEC.writePaddedBigIntegerLittleEndian(out, y, keyinfo.length);
        return out.toByteArray();
    }

    private static byte[] fromECDSAPublicKey(ECPublicKey key, ECKeyInfo keyinfo) {
        DNSOutput out = new DNSOutput();
        BigInteger x = key.getW().getAffineX();
        BigInteger y = key.getW().getAffineY();
        DNSSEC.writePaddedBigInteger(out, x, keyinfo.length);
        DNSSEC.writePaddedBigInteger(out, y, keyinfo.length);
        return out.toByteArray();
    }

    static byte[] fromPublicKey(PublicKey key, int alg) throws DNSSECException {
        switch (alg) {
            case 1: 
            case 5: 
            case 7: 
            case 8: 
            case 10: {
                if (!(key instanceof RSAPublicKey)) {
                    throw new IncompatibleKeyException();
                }
                return DNSSEC.fromRSAPublicKey((RSAPublicKey)key);
            }
            case 3: 
            case 6: {
                if (!(key instanceof DSAPublicKey)) {
                    throw new IncompatibleKeyException();
                }
                return DNSSEC.fromDSAPublicKey((DSAPublicKey)key);
            }
            case 12: {
                if (!(key instanceof ECPublicKey)) {
                    throw new IncompatibleKeyException();
                }
                return DNSSEC.fromECGOSTPublicKey((ECPublicKey)key, GOST);
            }
            case 13: {
                if (!(key instanceof ECPublicKey)) {
                    throw new IncompatibleKeyException();
                }
                return DNSSEC.fromECDSAPublicKey((ECPublicKey)key, ECDSA_P256);
            }
            case 14: {
                if (!(key instanceof ECPublicKey)) {
                    throw new IncompatibleKeyException();
                }
                return DNSSEC.fromECDSAPublicKey((ECPublicKey)key, ECDSA_P384);
            }
        }
        throw new UnsupportedAlgorithmException(alg);
    }

    public static String algString(int alg) throws UnsupportedAlgorithmException {
        switch (alg) {
            case 1: {
                return "MD5withRSA";
            }
            case 3: 
            case 6: {
                return "SHA1withDSA";
            }
            case 5: 
            case 7: {
                return "SHA1withRSA";
            }
            case 8: {
                return "SHA256withRSA";
            }
            case 10: {
                return "SHA512withRSA";
            }
            case 12: {
                return "GOST3411withECGOST3410";
            }
            case 13: {
                return "SHA256withECDSA";
            }
            case 14: {
                return "SHA384withECDSA";
            }
        }
        throw new UnsupportedAlgorithmException(alg);
    }

    private static byte[] DSASignaturefromDNS(byte[] dns) throws DNSSECException, IOException {
        if (dns.length != 41) {
            throw new SignatureVerificationException();
        }
        DNSInput in = new DNSInput(dns);
        DNSOutput out = new DNSOutput();
        int t = in.readU8();
        byte[] r = in.readByteArray(20);
        int rlen = 20;
        if (r[0] < 0) {
            ++rlen;
        }
        byte[] s2 = in.readByteArray(20);
        int slen = 20;
        if (s2[0] < 0) {
            ++slen;
        }
        out.writeU8(48);
        out.writeU8(rlen + slen + 4);
        out.writeU8(2);
        out.writeU8(rlen);
        if (rlen > 20) {
            out.writeU8(0);
        }
        out.writeByteArray(r);
        out.writeU8(2);
        out.writeU8(slen);
        if (slen > 20) {
            out.writeU8(0);
        }
        out.writeByteArray(s2);
        return out.toByteArray();
    }

    private static byte[] DSASignaturetoDNS(byte[] signature, int t) throws IOException {
        DNSInput in = new DNSInput(signature);
        DNSOutput out = new DNSOutput();
        out.writeU8(t);
        int tmp = in.readU8();
        if (tmp != 48) {
            throw new IOException();
        }
        int seqlen = in.readU8();
        tmp = in.readU8();
        if (tmp != 2) {
            throw new IOException();
        }
        int rlen = in.readU8();
        if (rlen == 21 ? in.readU8() != 0 : rlen != 20) {
            throw new IOException();
        }
        byte[] bytes = in.readByteArray(20);
        out.writeByteArray(bytes);
        tmp = in.readU8();
        if (tmp != 2) {
            throw new IOException();
        }
        int slen = in.readU8();
        if (slen == 21 ? in.readU8() != 0 : slen != 20) {
            throw new IOException();
        }
        bytes = in.readByteArray(20);
        out.writeByteArray(bytes);
        return out.toByteArray();
    }

    private static byte[] ECGOSTSignaturefromDNS(byte[] signature, ECKeyInfo keyinfo) throws DNSSECException, IOException {
        if (signature.length != keyinfo.length * 2) {
            throw new SignatureVerificationException();
        }
        return signature;
    }

    private static byte[] ECDSASignaturefromDNS(byte[] signature, ECKeyInfo keyinfo) throws DNSSECException, IOException {
        if (signature.length != keyinfo.length * 2) {
            throw new SignatureVerificationException();
        }
        DNSInput in = new DNSInput(signature);
        DNSOutput out = new DNSOutput();
        byte[] r = in.readByteArray(keyinfo.length);
        int rlen = keyinfo.length;
        if (r[0] < 0) {
            ++rlen;
        }
        byte[] s2 = in.readByteArray(keyinfo.length);
        int slen = keyinfo.length;
        if (s2[0] < 0) {
            ++slen;
        }
        out.writeU8(48);
        out.writeU8(rlen + slen + 4);
        out.writeU8(2);
        out.writeU8(rlen);
        if (rlen > keyinfo.length) {
            out.writeU8(0);
        }
        out.writeByteArray(r);
        out.writeU8(2);
        out.writeU8(slen);
        if (slen > keyinfo.length) {
            out.writeU8(0);
        }
        out.writeByteArray(s2);
        return out.toByteArray();
    }

    private static byte[] ECDSASignaturetoDNS(byte[] signature, ECKeyInfo keyinfo) throws IOException {
        DNSInput in = new DNSInput(signature);
        DNSOutput out = new DNSOutput();
        int tmp = in.readU8();
        if (tmp != 48) {
            throw new IOException();
        }
        int seqlen = in.readU8();
        tmp = in.readU8();
        if (tmp != 2) {
            throw new IOException();
        }
        int rlen = in.readU8();
        if (rlen == keyinfo.length + 1 ? in.readU8() != 0 : rlen != keyinfo.length) {
            throw new IOException();
        }
        byte[] bytes = in.readByteArray(keyinfo.length);
        out.writeByteArray(bytes);
        tmp = in.readU8();
        if (tmp != 2) {
            throw new IOException();
        }
        int slen = in.readU8();
        if (slen == keyinfo.length + 1 ? in.readU8() != 0 : slen != keyinfo.length) {
            throw new IOException();
        }
        bytes = in.readByteArray(keyinfo.length);
        out.writeByteArray(bytes);
        return out.toByteArray();
    }

    private static void verify(PublicKey key, int alg, byte[] data, byte[] signature) throws DNSSECException {
        if (key instanceof DSAPublicKey) {
            try {
                signature = DNSSEC.DSASignaturefromDNS(signature);
            }
            catch (IOException e) {
                throw new IllegalStateException();
            }
        }
        if (key instanceof ECPublicKey) {
            try {
                switch (alg) {
                    case 12: {
                        signature = DNSSEC.ECGOSTSignaturefromDNS(signature, GOST);
                        break;
                    }
                    case 13: {
                        signature = DNSSEC.ECDSASignaturefromDNS(signature, ECDSA_P256);
                        break;
                    }
                    case 14: {
                        signature = DNSSEC.ECDSASignaturefromDNS(signature, ECDSA_P384);
                        break;
                    }
                    default: {
                        throw new UnsupportedAlgorithmException(alg);
                    }
                }
            }
            catch (IOException e) {
                throw new IllegalStateException();
            }
        }
        try {
            Signature s2 = Signature.getInstance(DNSSEC.algString(alg));
            s2.initVerify(key);
            s2.update(data);
            if (!s2.verify(signature)) {
                throw new SignatureVerificationException();
            }
        }
        catch (GeneralSecurityException e) {
            throw new DNSSECException(e.toString());
        }
    }

    private static boolean matches(SIGBase sig, KEYBase key) {
        return key.getAlgorithm() == sig.getAlgorithm() && key.getFootprint() == sig.getFootprint() && key.getName().equals(sig.getSigner());
    }

    public static void verify(RRset rrset, RRSIGRecord rrsig, DNSKEYRecord key) throws DNSSECException {
        if (!DNSSEC.matches(rrsig, key)) {
            throw new KeyMismatchException(key, rrsig);
        }
        Date now = new Date();
        if (now.compareTo(rrsig.getExpire()) > 0) {
            throw new SignatureExpiredException(rrsig.getExpire(), now);
        }
        if (now.compareTo(rrsig.getTimeSigned()) < 0) {
            throw new SignatureNotYetValidException(rrsig.getTimeSigned(), now);
        }
        DNSSEC.verify(key.getPublicKey(), rrsig.getAlgorithm(), DNSSEC.digestRRset(rrsig, rrset), rrsig.getSignature());
    }

    private static byte[] sign(PrivateKey privkey, PublicKey pubkey, int alg, byte[] data, String provider) throws DNSSECException {
        byte[] signature;
        try {
            Signature s2 = provider != null ? Signature.getInstance(DNSSEC.algString(alg), provider) : Signature.getInstance(DNSSEC.algString(alg));
            s2.initSign(privkey);
            s2.update(data);
            signature = s2.sign();
        }
        catch (GeneralSecurityException e) {
            throw new DNSSECException(e.toString());
        }
        if (pubkey instanceof DSAPublicKey) {
            try {
                DSAPublicKey dsa = (DSAPublicKey)pubkey;
                BigInteger P = dsa.getParams().getP();
                int t = (DNSSEC.BigIntegerLength(P) - 64) / 8;
                signature = DNSSEC.DSASignaturetoDNS(signature, t);
            }
            catch (IOException e) {
                throw new IllegalStateException();
            }
        }
        if (pubkey instanceof ECPublicKey) {
            try {
                switch (alg) {
                    case 12: {
                        break;
                    }
                    case 13: {
                        signature = DNSSEC.ECDSASignaturetoDNS(signature, ECDSA_P256);
                        break;
                    }
                    case 14: {
                        signature = DNSSEC.ECDSASignaturetoDNS(signature, ECDSA_P384);
                        break;
                    }
                    default: {
                        throw new UnsupportedAlgorithmException(alg);
                    }
                }
            }
            catch (IOException e) {
                throw new IllegalStateException();
            }
        }
        return signature;
    }

    static void checkAlgorithm(PrivateKey key, int alg) throws UnsupportedAlgorithmException {
        switch (alg) {
            case 1: 
            case 5: 
            case 7: 
            case 8: 
            case 10: {
                if (key instanceof RSAPrivateKey) break;
                throw new IncompatibleKeyException();
            }
            case 3: 
            case 6: {
                if (key instanceof DSAPrivateKey) break;
                throw new IncompatibleKeyException();
            }
            case 12: 
            case 13: 
            case 14: {
                if (key instanceof ECPrivateKey) break;
                throw new IncompatibleKeyException();
            }
            default: {
                throw new UnsupportedAlgorithmException(alg);
            }
        }
    }

    public static RRSIGRecord sign(RRset rrset, DNSKEYRecord key, PrivateKey privkey, Date inception, Date expiration) throws DNSSECException {
        return DNSSEC.sign(rrset, key, privkey, inception, expiration, null);
    }

    public static RRSIGRecord sign(RRset rrset, DNSKEYRecord key, PrivateKey privkey, Date inception, Date expiration, String provider) throws DNSSECException {
        int alg = key.getAlgorithm();
        DNSSEC.checkAlgorithm(privkey, alg);
        RRSIGRecord rrsig = new RRSIGRecord(rrset.getName(), rrset.getDClass(), rrset.getTTL(), rrset.getType(), alg, rrset.getTTL(), expiration, inception, key.getFootprint(), key.getName(), null);
        rrsig.setSignature(DNSSEC.sign(privkey, key.getPublicKey(), alg, DNSSEC.digestRRset(rrsig, rrset), provider));
        return rrsig;
    }

    static SIGRecord signMessage(Message message, SIGRecord previous, KEYRecord key, PrivateKey privkey, Date inception, Date expiration) throws DNSSECException {
        int alg = key.getAlgorithm();
        DNSSEC.checkAlgorithm(privkey, alg);
        SIGRecord sig = new SIGRecord(Name.root, 255, 0L, 0, alg, 0L, expiration, inception, key.getFootprint(), key.getName(), null);
        DNSOutput out = new DNSOutput();
        DNSSEC.digestSIG(out, sig);
        if (previous != null) {
            out.writeByteArray(previous.getSignature());
        }
        out.writeByteArray(message.toWire());
        sig.setSignature(DNSSEC.sign(privkey, key.getPublicKey(), alg, out.toByteArray(), null));
        return sig;
    }

    static void verifyMessage(Message message, byte[] bytes, SIGRecord sig, SIGRecord previous, KEYRecord key) throws DNSSECException {
        if (message.sig0start == 0) {
            throw new NoSignatureException();
        }
        if (!DNSSEC.matches(sig, key)) {
            throw new KeyMismatchException(key, sig);
        }
        Date now = new Date();
        if (now.compareTo(sig.getExpire()) > 0) {
            throw new SignatureExpiredException(sig.getExpire(), now);
        }
        if (now.compareTo(sig.getTimeSigned()) < 0) {
            throw new SignatureNotYetValidException(sig.getTimeSigned(), now);
        }
        DNSOutput out = new DNSOutput();
        DNSSEC.digestSIG(out, sig);
        if (previous != null) {
            out.writeByteArray(previous.getSignature());
        }
        Header header = (Header)message.getHeader().clone();
        header.decCount(3);
        out.writeByteArray(header.toWire());
        out.writeByteArray(bytes, 12, message.sig0start - 12);
        DNSSEC.verify(key.getPublicKey(), sig.getAlgorithm(), out.toByteArray(), sig.getSignature());
    }

    static byte[] generateDSDigest(DNSKEYRecord key, int digestid) {
        MessageDigest digest;
        try {
            switch (digestid) {
                case 1: {
                    digest = MessageDigest.getInstance("sha-1");
                    break;
                }
                case 2: {
                    digest = MessageDigest.getInstance("sha-256");
                    break;
                }
                case 3: {
                    digest = MessageDigest.getInstance("GOST3411");
                    break;
                }
                case 4: {
                    digest = MessageDigest.getInstance("sha-384");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown DS digest type " + digestid);
                }
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("no message digest support");
        }
        digest.update(key.getName().toWireCanonical());
        digest.update(key.rdataToWireCanonical());
        return digest.digest();
    }

    private static class ECKeyInfo {
        int length;
        public BigInteger p;
        public BigInteger a;
        public BigInteger b;
        public BigInteger gx;
        public BigInteger gy;
        public BigInteger n;
        EllipticCurve curve;
        ECParameterSpec spec;

        ECKeyInfo(int length, String p_str, String a_str, String b_str, String gx_str, String gy_str, String n_str) {
            this.length = length;
            this.p = new BigInteger(p_str, 16);
            this.a = new BigInteger(a_str, 16);
            this.b = new BigInteger(b_str, 16);
            this.gx = new BigInteger(gx_str, 16);
            this.gy = new BigInteger(gy_str, 16);
            this.n = new BigInteger(n_str, 16);
            this.curve = new EllipticCurve(new ECFieldFp(this.p), this.a, this.b);
            this.spec = new ECParameterSpec(this.curve, new ECPoint(this.gx, this.gy), this.n, 1);
        }
    }

    public static class NoSignatureException
    extends DNSSECException {
        NoSignatureException() {
            super("no signature found");
        }
    }

    public static class IncompatibleKeyException
    extends IllegalArgumentException {
        IncompatibleKeyException() {
            super("incompatible keys");
        }
    }

    public static class SignatureVerificationException
    extends DNSSECException {
        SignatureVerificationException() {
            super("signature verification failed");
        }
    }

    public static class SignatureNotYetValidException
    extends DNSSECException {
        private Date when;
        private Date now;

        SignatureNotYetValidException(Date when, Date now) {
            super("signature is not yet valid");
            this.when = when;
            this.now = now;
        }

        public Date getExpiration() {
            return this.when;
        }

        public Date getVerifyTime() {
            return this.now;
        }
    }

    public static class SignatureExpiredException
    extends DNSSECException {
        private Date when;
        private Date now;

        SignatureExpiredException(Date when, Date now) {
            super("signature expired");
            this.when = when;
            this.now = now;
        }

        public Date getExpiration() {
            return this.when;
        }

        public Date getVerifyTime() {
            return this.now;
        }
    }

    public static class KeyMismatchException
    extends DNSSECException {
        private KEYBase key;
        private SIGBase sig;

        KeyMismatchException(KEYBase key, SIGBase sig) {
            super("key " + key.getName() + "/" + Algorithm.string(key.getAlgorithm()) + "/" + key.getFootprint() + " " + "does not match signature " + sig.getSigner() + "/" + Algorithm.string(sig.getAlgorithm()) + "/" + sig.getFootprint());
        }
    }

    public static class MalformedKeyException
    extends DNSSECException {
        MalformedKeyException(KEYBase rec) {
            super("Invalid key data: " + rec.rdataToString());
        }
    }

    public static class UnsupportedAlgorithmException
    extends DNSSECException {
        UnsupportedAlgorithmException(int alg) {
            super("Unsupported algorithm: " + alg);
        }
    }

    public static class DNSSECException
    extends Exception {
        DNSSECException(String s2) {
            super(s2);
        }
    }

    public static class Algorithm {
        public static final int RSAMD5 = 1;
        public static final int DH = 2;
        public static final int DSA = 3;
        public static final int RSASHA1 = 5;
        public static final int DSA_NSEC3_SHA1 = 6;
        public static final int RSA_NSEC3_SHA1 = 7;
        public static final int RSASHA256 = 8;
        public static final int RSASHA512 = 10;
        public static final int ECC_GOST = 12;
        public static final int ECDSAP256SHA256 = 13;
        public static final int ECDSAP384SHA384 = 14;
        public static final int INDIRECT = 252;
        public static final int PRIVATEDNS = 253;
        public static final int PRIVATEOID = 254;
        private static Mnemonic algs = new Mnemonic("DNSSEC algorithm", 2);

        private Algorithm() {
        }

        public static String string(int alg) {
            return algs.getText(alg);
        }

        public static int value(String s2) {
            return algs.getValue(s2);
        }

        static {
            algs.setMaximum(255);
            algs.setNumericAllowed(true);
            algs.add(1, "RSAMD5");
            algs.add(2, "DH");
            algs.add(3, "DSA");
            algs.add(5, "RSASHA1");
            algs.add(6, "DSA-NSEC3-SHA1");
            algs.add(7, "RSA-NSEC3-SHA1");
            algs.add(8, "RSASHA256");
            algs.add(10, "RSASHA512");
            algs.add(12, "ECC-GOST");
            algs.add(13, "ECDSAP256SHA256");
            algs.add(14, "ECDSAP384SHA384");
            algs.add(252, "INDIRECT");
            algs.add(253, "PRIVATEDNS");
            algs.add(254, "PRIVATEOID");
        }
    }
}

