/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web.oauth2;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.web.oauth2.AccessTokenProvider;
import org.apache.hadoop.hdfs.web.oauth2.AccessTokenTimer;
import org.apache.hadoop.hdfs.web.oauth2.OAuth2Constants;
import org.apache.hadoop.hdfs.web.oauth2.Utils;
import org.apache.hadoop.util.JsonSerialization;
import org.apache.hadoop.util.Timer;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ConfRefreshTokenBasedAccessTokenProvider
extends AccessTokenProvider {
    public static final String OAUTH_REFRESH_TOKEN_KEY = "dfs.webhdfs.oauth2.refresh.token";
    public static final String OAUTH_REFRESH_TOKEN_EXPIRES_KEY = "dfs.webhdfs.oauth2.refresh.token.expires.ms.since.epoch";
    private AccessTokenTimer accessTokenTimer;
    private String accessToken;
    private String refreshToken;
    private String clientId;
    private String refreshURL;

    public ConfRefreshTokenBasedAccessTokenProvider() {
        this.accessTokenTimer = new AccessTokenTimer();
    }

    public ConfRefreshTokenBasedAccessTokenProvider(Timer timer) {
        this.accessTokenTimer = new AccessTokenTimer(timer);
    }

    @Override
    public void setConf(Configuration conf) {
        super.setConf(conf);
        this.refreshToken = Utils.notNull(conf, OAUTH_REFRESH_TOKEN_KEY);
        this.accessTokenTimer.setExpiresInMSSinceEpoch(Utils.notNull(conf, OAUTH_REFRESH_TOKEN_EXPIRES_KEY));
        this.clientId = Utils.notNull(conf, "dfs.webhdfs.oauth2.client.id");
        this.refreshURL = Utils.notNull(conf, "dfs.webhdfs.oauth2.refresh.url");
    }

    @Override
    public synchronized String getAccessToken() throws IOException {
        if (this.accessTokenTimer.shouldRefresh()) {
            this.refresh();
        }
        return this.accessToken;
    }

    void refresh() throws IOException {
        OkHttpClient client = new OkHttpClient.Builder().connectTimeout(60000L, TimeUnit.MILLISECONDS).readTimeout(60000L, TimeUnit.MILLISECONDS).build();
        String bodyString = Utils.postBody("grant_type", "refresh_token", "refresh_token", this.refreshToken, "client_id", this.clientId);
        RequestBody body = RequestBody.create(bodyString, OAuth2Constants.URLENCODED);
        Request request = new Request.Builder().url(this.refreshURL).post(body).build();
        try (Response response = client.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("Unexpected code " + response);
            }
            if (response.code() != 200) {
                throw new IllegalArgumentException("Received invalid http response: " + response.code() + ", text = " + response.toString());
            }
            Map responseBody = (Map)JsonSerialization.mapReader().readValue(response.body().string());
            String newExpiresIn = responseBody.get("expires_in").toString();
            this.accessTokenTimer.setExpiresIn(newExpiresIn);
            this.accessToken = responseBody.get("access_token").toString();
        }
        catch (Exception e) {
            throw new IOException("Exception while refreshing access token", e);
        }
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }
}

