/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.PathIsDirectoryException;
import org.apache.hadoop.fs.shell.CommandFactory;
import org.apache.hadoop.fs.shell.CommandFormat;
import org.apache.hadoop.fs.shell.FsCommand;
import org.apache.hadoop.fs.shell.PathData;
import org.apache.hadoop.io.IOUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class Head
extends FsCommand {
    public static final String NAME = "head";
    public static final String USAGE = "<file>";
    public static final String DESCRIPTION = "Show the first 1KB of the file.\n";
    private long endingOffset = 1024L;

    Head() {
    }

    public static void registerCommands(CommandFactory factory2) {
        factory2.addClass(Head.class, "-head");
    }

    @Override
    protected void processOptions(LinkedList<String> args2) throws IOException {
        CommandFormat cf = new CommandFormat(1, 1, new String[0]);
        cf.parse(args2);
    }

    @Override
    protected List<PathData> expandArgument(String arg) throws IOException {
        LinkedList<PathData> items = new LinkedList<PathData>();
        items.add(new PathData(arg, this.getConf()));
        return items;
    }

    @Override
    protected void processPath(PathData item) throws IOException {
        if (item.stat.isDirectory()) {
            throw new PathIsDirectoryException(item.toString());
        }
        this.dumpToOffset(item);
    }

    private void dumpToOffset(PathData item) throws IOException {
        try (FSDataInputStream in = item.fs.open(item.path);){
            IOUtils.copyBytes((InputStream)in, (OutputStream)System.out, this.endingOffset, false);
        }
    }
}

