/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluss.fs.s3;

import java.io.IOException;
import java.net.URI;
import java.util.Objects;
import org.apache.fluss.config.ConfigBuilder;
import org.apache.fluss.fs.FileSystem;
import org.apache.fluss.fs.FileSystemPlugin;
import org.apache.fluss.fs.s3.S3FileSystem;
import org.apache.fluss.fs.s3.token.S3ADelegationTokenReceiver;
import org.apache.fluss.fs.s3.token.S3DelegationTokenReceiver;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.s3a.S3AFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3FileSystemPlugin
implements FileSystemPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(S3FileSystemPlugin.class);
    private static final String[] FLUSS_CONFIG_PREFIXES = new String[]{"s3.", "s3a.", "fs.s3a."};
    private static final String HADOOP_CONFIG_PREFIX = "fs.s3a.";
    private static final String ACCESS_KEY_ID = "fs.s3a.access.key";
    private static final String[][] MIRRORED_CONFIG_KEYS = new String[][]{{"fs.s3a.access-key", "fs.s3a.access.key"}, {"fs.s3a.secret-key", "fs.s3a.secret.key"}, {"fs.s3a.path-style-access", "fs.s3a.path.style.access"}};

    public String getScheme() {
        return "s3";
    }

    public FileSystem create(URI fsUri, org.apache.fluss.config.Configuration flussConfig) throws IOException {
        Configuration hadoopConfig = this.mirrorCertainHadoopConfig(this.getHadoopConfiguration(flussConfig));
        this.setCredentialProvider(hadoopConfig);
        S3AFileSystem fs = new S3AFileSystem();
        ((org.apache.hadoop.fs.FileSystem)fs).initialize(this.getInitURI(fsUri, hadoopConfig), hadoopConfig);
        return new S3FileSystem(this.getScheme(), fs, hadoopConfig);
    }

    Configuration getHadoopConfiguration(org.apache.fluss.config.Configuration flussConfig) {
        Configuration conf = new Configuration();
        if (flussConfig == null) {
            return conf;
        }
        for (String key : flussConfig.keySet()) {
            for (String prefix : FLUSS_CONFIG_PREFIXES) {
                if (!key.startsWith(prefix)) continue;
                String newKey = HADOOP_CONFIG_PREFIX + key.substring(prefix.length());
                String newValue = flussConfig.getString(ConfigBuilder.key((String)key).stringType().noDefaultValue(), null);
                conf.set(newKey, newValue);
                LOG.debug("Adding Fluss config entry for {} as {} to Hadoop config", (Object)key, (Object)newKey);
            }
        }
        return conf;
    }

    private Configuration mirrorCertainHadoopConfig(Configuration hadoopConfig) {
        for (String[] mirrored : MIRRORED_CONFIG_KEYS) {
            String value = hadoopConfig.get(mirrored[0], null);
            if (value == null) continue;
            hadoopConfig.set(mirrored[1], value);
        }
        return hadoopConfig;
    }

    private URI getInitURI(URI fsUri, Configuration hadoopConfig) {
        URI defaultUri;
        String scheme = fsUri.getScheme();
        String authority = fsUri.getAuthority();
        if (scheme == null && authority == null) {
            fsUri = org.apache.hadoop.fs.FileSystem.getDefaultUri(hadoopConfig);
        } else if (scheme != null && authority == null && scheme.equals((defaultUri = org.apache.hadoop.fs.FileSystem.getDefaultUri(hadoopConfig)).getScheme()) && defaultUri.getAuthority() != null) {
            fsUri = defaultUri;
        }
        return fsUri;
    }

    private void setCredentialProvider(Configuration hadoopConfig) {
        if (hadoopConfig.get(ACCESS_KEY_ID) == null) {
            if (Objects.equals(this.getScheme(), "s3")) {
                S3DelegationTokenReceiver.updateHadoopConfig(hadoopConfig);
            } else if (Objects.equals(this.getScheme(), "s3a")) {
                S3ADelegationTokenReceiver.updateHadoopConfig(hadoopConfig);
            } else {
                throw new IllegalArgumentException("Unsupported scheme: " + this.getScheme());
            }
            LOG.info("{} is not set, using credential provider {}.", (Object)ACCESS_KEY_ID, (Object)hadoopConfig.get("fs.s3a.aws.credentials.provider"));
        } else {
            LOG.info("{} is set, using provided access key id and secret.", (Object)ACCESS_KEY_ID);
        }
    }
}

