/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.baserpc;

import io.grpc.MethodDescriptor;
import io.grpc.ServiceDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import lombok.Generated;
import org.apache.bifromq.baserpc.marshaller.HLCStampedMarshaller;

public final class BluePrint {
    private final ServiceDescriptor serviceDescriptor;
    private final Map<String, MethodSemantic> methodSemantics;
    private final Map<String, MethodDescriptor<?, ?>> wrappedMethods;

    private BluePrint(ServiceDescriptor serviceDescriptor, Map<String, MethodSemantic> methodSemantics, Map<String, MethodDescriptor<?, ?>> methods, Map<String, MethodDescriptor<?, ?>> wrappedMethods) {
        this.serviceDescriptor = serviceDescriptor;
        this.methodSemantics = methodSemantics;
        this.wrappedMethods = wrappedMethods;
        if (!serviceDescriptor.getMethods().containsAll(methods.values())) {
            throw new RuntimeException("Some method is not defined in the supplied service descriptor");
        }
        block4: for (String methodName : methodSemantics.keySet()) {
            MethodDescriptor<?, ?> methodDesc = wrappedMethods.get(methodName);
            MethodSemantic semantic = methodSemantics.get(methodName);
            switch (methodDesc.getType()) {
                case UNARY: {
                    if (semantic instanceof Unary) continue block4;
                    throw new RuntimeException("Wrong semantic for Unary rpc");
                }
                case BIDI_STREAMING: {
                    if (semantic instanceof PipelineUnary || semantic instanceof Streaming) continue block4;
                    throw new RuntimeException("Wrong semantic configured for bidi streaming rpc");
                }
            }
            throw new RuntimeException("Unknown method type: " + String.valueOf(methodDesc.getType()));
        }
    }

    public static BluePrintBuilder builder() {
        return new BluePrintBuilder();
    }

    public ServiceDescriptor serviceDescriptor() {
        return this.serviceDescriptor;
    }

    public Set<String> allMethods() {
        return this.wrappedMethods.keySet();
    }

    public MethodSemantic semantic(String fullMethodName) {
        return this.methodSemantics.get(fullMethodName);
    }

    public <ReqT, RespT> MethodDescriptor<ReqT, RespT> methodDesc(String fullMethodName) {
        return this.wrappedMethods.get(fullMethodName);
    }

    public static interface MethodSemantic {
        public MethodType type();

        public BalanceMode mode();
    }

    public static interface Unary
    extends MethodSemantic {
        @Override
        default public MethodType type() {
            return MethodType.UNARY;
        }
    }

    public static interface PipelineUnary
    extends MethodSemantic {
        @Override
        default public MethodType type() {
            return MethodType.PIPELINE_UNARY;
        }
    }

    public static interface Streaming
    extends MethodSemantic {
        @Override
        default public MethodType type() {
            return MethodType.STREAMING;
        }
    }

    public static class BluePrintBuilder {
        private ServiceDescriptor serviceDescriptor;
        private ArrayList<MethodDescriptor<?, ?>> methods;
        private ArrayList<MethodDescriptor<?, ?>> wrappedMethods;
        private ArrayList<MethodSemantic> methodSemantics;

        BluePrintBuilder() {
        }

        public BluePrintBuilder serviceDescriptor(ServiceDescriptor serviceDescriptor) {
            this.serviceDescriptor = serviceDescriptor;
            return this;
        }

        public <ReqT, RespT> BluePrintBuilder methodSemantic(MethodDescriptor<ReqT, RespT> methodSemanticKey, MethodSemantic methodSemanticValue) {
            if (this.methods == null) {
                this.methods = new ArrayList();
                this.wrappedMethods = new ArrayList();
                this.methodSemantics = new ArrayList();
            }
            this.methodSemantics.add(methodSemanticValue);
            this.methods.add(methodSemanticKey);
            this.wrappedMethods.add(methodSemanticKey.toBuilder().setRequestMarshaller(this.enhance(methodSemanticKey.getRequestMarshaller())).setResponseMarshaller(this.enhance(methodSemanticKey.getResponseMarshaller())).build());
            return this;
        }

        public BluePrint build() {
            Map<String, MethodDescriptor<?, ?>> wrappedMethods;
            Map<String, MethodDescriptor<?, ?>> methodsMap;
            Map<String, MethodSemantic> methodSemanticMap;
            switch (this.wrappedMethods == null ? 0 : this.wrappedMethods.size()) {
                case 0: {
                    methodSemanticMap = Collections.emptyMap();
                    methodsMap = Collections.emptyMap();
                    wrappedMethods = Collections.emptyMap();
                    break;
                }
                case 1: {
                    MethodDescriptor<?, ?> method = this.methods.get(0);
                    String fullMethodName = method.getFullMethodName();
                    methodSemanticMap = Collections.singletonMap(fullMethodName, this.methodSemantics.get(0));
                    methodsMap = Collections.singletonMap(fullMethodName, method);
                    wrappedMethods = Collections.singletonMap(fullMethodName, this.wrappedMethods.get(0));
                    break;
                }
                default: {
                    methodSemanticMap = new LinkedHashMap(this.wrappedMethods.size() < 0x40000000 ? 1 + this.wrappedMethods.size() + (this.wrappedMethods.size() - 3) / 3 : Integer.MAX_VALUE);
                    methodsMap = new LinkedHashMap(this.methods.size() < 0x40000000 ? 1 + this.methods.size() + (this.methods.size() - 3) / 3 : Integer.MAX_VALUE);
                    wrappedMethods = new LinkedHashMap(this.wrappedMethods.size() < 0x40000000 ? 1 + this.wrappedMethods.size() + (this.wrappedMethods.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.methods.size(); ++$i) {
                        MethodDescriptor<?, ?> method = this.methods.get($i);
                        String fullMethodName = method.getFullMethodName();
                        methodSemanticMap.put(fullMethodName, this.methodSemantics.get($i));
                        methodsMap.put(fullMethodName, method);
                        wrappedMethods.put(fullMethodName, this.wrappedMethods.get($i));
                    }
                    methodSemanticMap = Collections.unmodifiableMap(methodSemanticMap);
                    methodsMap = Collections.unmodifiableMap(methodsMap);
                    wrappedMethods = Collections.unmodifiableMap(wrappedMethods);
                }
            }
            return new BluePrint(this.serviceDescriptor, methodSemanticMap, methodsMap, wrappedMethods);
        }

        private <T> MethodDescriptor.Marshaller<T> enhance(MethodDescriptor.Marshaller<T> marshaller) {
            return new HLCStampedMarshaller<T>(marshaller);
        }
    }

    public static final class WCHStreamingMethod
    implements Streaming {
        public static WCHStreamingMethod getInstance() {
            return new WCHStreamingMethod();
        }

        @Override
        public BalanceMode mode() {
            return BalanceMode.WCHBalanced;
        }

        @Generated
        private WCHStreamingMethod() {
        }
    }

    public static final class WRStreamingMethod
    implements Streaming {
        public static WRStreamingMethod getInstance() {
            return new WRStreamingMethod();
        }

        @Override
        public BalanceMode mode() {
            return BalanceMode.WRBalanced;
        }

        @Generated
        private WRStreamingMethod() {
        }
    }

    public static final class WRRStreamingMethod
    implements Streaming {
        public static WRRStreamingMethod getInstance() {
            return new WRRStreamingMethod();
        }

        @Override
        public BalanceMode mode() {
            return BalanceMode.WRRBalanced;
        }

        @Generated
        private WRRStreamingMethod() {
        }
    }

    public static final class DDStreamingMethod
    implements Streaming {
        public static DDStreamingMethod getInstance() {
            return new DDStreamingMethod();
        }

        @Override
        public BalanceMode mode() {
            return BalanceMode.DDBalanced;
        }

        @Generated
        private DDStreamingMethod() {
        }
    }

    public static final class HRWPipelineUnaryMethod
    implements PipelineUnary {
        public static HRWPipelineUnaryMethod getInstance() {
            return new HRWPipelineUnaryMethod();
        }

        @Override
        public BalanceMode mode() {
            return BalanceMode.WCHBalanced;
        }

        @Generated
        private HRWPipelineUnaryMethod() {
        }
    }

    public static final class WCHPipelineUnaryMethod
    implements PipelineUnary {
        public static WCHPipelineUnaryMethod getInstance() {
            return new WCHPipelineUnaryMethod();
        }

        @Override
        public BalanceMode mode() {
            return BalanceMode.WCHBalanced;
        }

        @Generated
        private WCHPipelineUnaryMethod() {
        }
    }

    public static final class WRPipelineUnaryMethod
    implements PipelineUnary {
        public static WRPipelineUnaryMethod getInstance() {
            return new WRPipelineUnaryMethod();
        }

        @Override
        public BalanceMode mode() {
            return BalanceMode.WRBalanced;
        }

        @Generated
        private WRPipelineUnaryMethod() {
        }
    }

    public static final class WRRPipelineUnaryMethod
    implements PipelineUnary {
        public static WRRPipelineUnaryMethod getInstance() {
            return new WRRPipelineUnaryMethod();
        }

        @Override
        public BalanceMode mode() {
            return BalanceMode.WRRBalanced;
        }

        @Generated
        private WRRPipelineUnaryMethod() {
        }
    }

    public static final class DDPipelineUnaryMethod
    implements PipelineUnary {
        public static DDPipelineUnaryMethod getInstance() {
            return new DDPipelineUnaryMethod();
        }

        @Override
        public BalanceMode mode() {
            return BalanceMode.DDBalanced;
        }

        @Generated
        private DDPipelineUnaryMethod() {
        }
    }

    public static final class WCHUnaryMethod<ReqT>
    implements Unary,
    WCHBalancedReq<ReqT> {
        private final Function<ReqT, String> keyHashFunc;

        @Override
        public String hashKey(ReqT req) {
            return this.keyHashFunc.apply(req);
        }

        @Override
        public BalanceMode mode() {
            return BalanceMode.WCHBalanced;
        }

        @Generated
        WCHUnaryMethod(Function<ReqT, String> keyHashFunc) {
            this.keyHashFunc = keyHashFunc;
        }

        @Generated
        public static <ReqT> WCHUnaryMethodBuilder<ReqT> builder() {
            return new WCHUnaryMethodBuilder();
        }

        @Generated
        public static class WCHUnaryMethodBuilder<ReqT> {
            @Generated
            private Function<ReqT, String> keyHashFunc;

            @Generated
            WCHUnaryMethodBuilder() {
            }

            @Generated
            public WCHUnaryMethodBuilder<ReqT> keyHashFunc(Function<ReqT, String> keyHashFunc) {
                this.keyHashFunc = keyHashFunc;
                return this;
            }

            @Generated
            public WCHUnaryMethod<ReqT> build() {
                return new WCHUnaryMethod<ReqT>(this.keyHashFunc);
            }

            @Generated
            public String toString() {
                return "BluePrint.WCHUnaryMethod.WCHUnaryMethodBuilder(keyHashFunc=" + String.valueOf(this.keyHashFunc) + ")";
            }
        }
    }

    public static final class WRUnaryMethod
    implements Unary {
        public static WRUnaryMethod getInstance() {
            return new WRUnaryMethod();
        }

        @Override
        public BalanceMode mode() {
            return BalanceMode.WRBalanced;
        }

        @Generated
        private WRUnaryMethod() {
        }
    }

    public static final class WRRUnaryMethod
    implements Unary {
        public static WRRUnaryMethod getInstance() {
            return new WRRUnaryMethod();
        }

        @Override
        public BalanceMode mode() {
            return BalanceMode.WRRBalanced;
        }

        @Generated
        private WRRUnaryMethod() {
        }
    }

    public static final class DDUnaryMethod
    implements Unary {
        public static DDUnaryMethod getInstance() {
            return new DDUnaryMethod();
        }

        @Override
        public BalanceMode mode() {
            return BalanceMode.DDBalanced;
        }

        @Generated
        private DDUnaryMethod() {
        }
    }

    public static interface WCHBalancedReq<ReqT> {
        public String hashKey(ReqT var1);
    }

    public static enum BalanceMode {
        DDBalanced,
        WRRBalanced,
        WRBalanced,
        WCHBalanced;

    }

    public static enum MethodType {
        UNARY,
        PIPELINE_UNARY,
        STREAMING;

    }
}

