/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.localengine.metrics;

import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import org.apache.bifromq.basekv.localengine.metrics.GeneralKVSpaceMetric;
import org.apache.bifromq.basekv.localengine.metrics.KVSpaceMeters;

public class KVSpaceOpMeters {
    public final Timer metadataCallTimer;
    public final Timer sizeCallTimer;
    public final Timer existCallTimer;
    public final Timer getCallTimer;
    public final Timer iterNewCallTimer;
    public final Timer iterSeekCallTimer;
    public final Timer iterSeekForPrevCallTimer;
    public final Timer iterSeekToFirstCallTimer;
    public final Timer iterSeekToLastCallTimer;
    public final Timer iterNextCallTimer;
    public final Timer iterPrevCallTimer;
    public final Timer iterRefreshTimer;
    public final Timer batchWriteCallTimer;
    public final DistributionSummary readBytesSummary;
    public final DistributionSummary writeBatchSizeSummary;

    public KVSpaceOpMeters(String id, Tags tags) {
        this.metadataCallTimer = KVSpaceMeters.getTimer(id, GeneralKVSpaceMetric.CallTimer, tags.and("op", "metadata"));
        this.sizeCallTimer = KVSpaceMeters.getTimer(id, GeneralKVSpaceMetric.CallTimer, tags.and("op", "size"));
        this.existCallTimer = KVSpaceMeters.getTimer(id, GeneralKVSpaceMetric.CallTimer, tags.and("op", "exist"));
        this.getCallTimer = KVSpaceMeters.getTimer(id, GeneralKVSpaceMetric.CallTimer, tags.and("op", "get"));
        this.iterNewCallTimer = KVSpaceMeters.getTimer(id, GeneralKVSpaceMetric.CallTimer, tags.and("op", "newitr"));
        this.iterSeekCallTimer = KVSpaceMeters.getTimer(id, GeneralKVSpaceMetric.CallTimer, tags.and("op", "seek"));
        this.iterSeekForPrevCallTimer = KVSpaceMeters.getTimer(id, GeneralKVSpaceMetric.CallTimer, tags.and("op", "pseek"));
        this.iterSeekToFirstCallTimer = KVSpaceMeters.getTimer(id, GeneralKVSpaceMetric.CallTimer, tags.and("op", "fseek"));
        this.iterSeekToLastCallTimer = KVSpaceMeters.getTimer(id, GeneralKVSpaceMetric.CallTimer, tags.and("op", "lseek"));
        this.iterNextCallTimer = KVSpaceMeters.getTimer(id, GeneralKVSpaceMetric.CallTimer, tags.and("op", "next"));
        this.iterPrevCallTimer = KVSpaceMeters.getTimer(id, GeneralKVSpaceMetric.CallTimer, tags.and("op", "prev"));
        this.iterRefreshTimer = KVSpaceMeters.getTimer(id, GeneralKVSpaceMetric.CallTimer, tags.and("op", "refresh"));
        this.batchWriteCallTimer = KVSpaceMeters.getTimer(id, GeneralKVSpaceMetric.CallTimer, tags.and("op", "bwrite"));
        this.readBytesSummary = KVSpaceMeters.getSummary(id, GeneralKVSpaceMetric.ReadBytesDistribution, tags);
        this.writeBatchSizeSummary = KVSpaceMeters.getSummary(id, GeneralKVSpaceMetric.WriteBatchSizeDistribution, tags);
    }

    public void close() {
        this.metadataCallTimer.close();
        this.sizeCallTimer.close();
        this.existCallTimer.close();
        this.getCallTimer.close();
        this.iterNewCallTimer.close();
        this.iterSeekCallTimer.close();
        this.iterSeekForPrevCallTimer.close();
        this.iterSeekToFirstCallTimer.close();
        this.iterSeekToLastCallTimer.close();
        this.iterNextCallTimer.close();
        this.iterPrevCallTimer.close();
        this.iterRefreshTimer.close();
        this.batchWriteCallTimer.close();
        this.readBytesSummary.close();
        this.writeBatchSizeSummary.close();
    }
}

