/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.retain.store;

import com.google.protobuf.ByteString;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Supplier;
import org.apache.bifromq.basekv.proto.Boundary;
import org.apache.bifromq.basekv.store.api.IKVRangeRefreshableReader;
import org.apache.bifromq.basekv.utils.BoundaryUtil;
import org.apache.bifromq.retain.store.TenantStats;
import org.apache.bifromq.retain.store.schema.KVSchemaUtil;

class TenantsStats {
    private final Map<String, TenantStats> retainedSet = new ConcurrentHashMap<String, TenantStats>();
    private final Supplier<IKVRangeRefreshableReader> readerSupplier;
    private final String[] tags;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final StampedLock closeLock = new StampedLock();

    TenantsStats(Supplier<IKVRangeRefreshableReader> readerSupplier, String ... tags) {
        this.readerSupplier = readerSupplier;
        this.tags = tags;
    }

    void increaseTopicCount(String tenantId, int delta) {
        this.retainedSet.compute(tenantId, (k, v) -> {
            if (v == null) {
                v = new TenantStats(tenantId, this.getTenantUsedSpaceProvider(tenantId), this.tags);
            }
            if (v.incrementTopicCount(delta) == 0L) {
                v.destroy();
                return null;
            }
            return v;
        });
    }

    public void toggleMetering(boolean isLeader) {
        this.retainedSet.values().forEach(s -> s.toggleMetering(isLeader));
    }

    private Supplier<Number> getTenantUsedSpaceProvider(String tenantId) {
        return () -> {
            long stamped = this.closeLock.readLock();
            if (this.closed.get()) {
                this.closeLock.unlock(stamped);
                return 0;
            }
            ByteString tenantBeginKey = KVSchemaUtil.tenantBeginKey((String)tenantId);
            try {
                Long l;
                block14: {
                    Boundary tenantBoundary;
                    IKVRangeRefreshableReader reader;
                    block12: {
                        Long l2;
                        block13: {
                            reader = this.readerSupplier.get();
                            try {
                                tenantBoundary = BoundaryUtil.intersect((Boundary)BoundaryUtil.toBoundary((ByteString)tenantBeginKey, (ByteString)BoundaryUtil.upperBound((ByteString)tenantBeginKey)), (Boundary)reader.boundary());
                                if (!BoundaryUtil.isNULLRange((Boundary)tenantBoundary)) break block12;
                                l2 = 0L;
                                if (reader == null) break block13;
                            }
                            catch (Throwable throwable) {
                                if (reader != null) {
                                    try {
                                        reader.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            reader.close();
                        }
                        return l2;
                    }
                    l = reader.size(tenantBoundary);
                    if (reader == null) break block14;
                    reader.close();
                }
                return l;
            }
            finally {
                this.closeLock.unlock(stamped);
            }
        };
    }

    void reset() {
        long stamp = this.closeLock.writeLock();
        try {
            if (!this.closed.get()) {
                this.retainedSet.values().forEach(TenantStats::destroy);
                this.retainedSet.clear();
            }
        }
        finally {
            this.closeLock.unlock(stamp);
        }
    }

    void close() {
        long stamp = this.closeLock.writeLock();
        try {
            if (this.closed.compareAndSet(false, true)) {
                this.retainedSet.values().forEach(TenantStats::destroy);
                this.retainedSet.clear();
            }
        }
        finally {
            this.closeLock.unlock(stamp);
        }
    }
}

