/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basecrdt.core.internal;

import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.bifromq.basecrdt.core.api.AWORSetOperation;
import org.apache.bifromq.basecrdt.core.api.CausalCRDTType;
import org.apache.bifromq.basecrdt.core.api.IAWORSet;
import org.apache.bifromq.basecrdt.core.api.IAWORSetInflater;
import org.apache.bifromq.basecrdt.core.internal.AWORSet;
import org.apache.bifromq.basecrdt.core.internal.AWORSetCoalesceOperation;
import org.apache.bifromq.basecrdt.core.internal.CausalCRDT;
import org.apache.bifromq.basecrdt.core.internal.CausalCRDTInflater;
import org.apache.bifromq.basecrdt.core.internal.DotMap;
import org.apache.bifromq.basecrdt.core.internal.ICoalesceOperation;
import org.apache.bifromq.basecrdt.core.internal.IDotMap;
import org.apache.bifromq.basecrdt.core.internal.IReplicaStateLattice;
import org.apache.bifromq.basecrdt.proto.Replica;

class AWORSetInflater
extends CausalCRDTInflater<IDotMap, AWORSetOperation, IAWORSet>
implements IAWORSetInflater {
    AWORSetInflater(String storeId, Replica replica, IReplicaStateLattice stateLattice, ScheduledExecutorService executor, Duration inflationInterval, String ... tags) {
        super(storeId, replica, stateLattice, executor, inflationInterval, tags);
    }

    @Override
    protected IAWORSet newCRDT(Replica replica, IDotMap dotStore, CausalCRDT.CRDTOperationExecutor<AWORSetOperation> executor) {
        return new AWORSet(replica, () -> dotStore, executor);
    }

    @Override
    public CausalCRDTType type() {
        return CausalCRDTType.aworset;
    }

    @Override
    protected ICoalesceOperation<IDotMap, AWORSetOperation> startCoalescing(AWORSetOperation op) {
        return new AWORSetCoalesceOperation(this.id().getId(), op);
    }

    @Override
    protected Class<? extends IDotMap> dotStoreType() {
        return DotMap.class;
    }
}

