/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.dist.trie;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Stack;
import org.apache.bifromq.dist.trie.ITopicFilterIterator;
import org.apache.bifromq.dist.trie.TopicFilterTrieNode;
import org.apache.bifromq.dist.trie.TopicTrieNode;

public class TopicFilterIterator<V>
implements ITopicFilterIterator<V> {
    private final Stack<TopicFilterTrieNode<V>> traverseStack = new Stack();
    private TopicTrieNode<V> topicTrieRoot;

    @Override
    public void init(TopicTrieNode<V> root) {
        this.topicTrieRoot = root;
        this.seek(Collections.emptyList());
    }

    @Override
    public void close() {
        this.clearTraverseStack();
        this.topicTrieRoot = null;
    }

    @Override
    public void seek(List<String> filterLevels) {
        TopicFilterTrieNode<V> node;
        this.clearTraverseStack();
        this.traverseStack.push(TopicFilterTrieNode.from(this.topicTrieRoot));
        int i = -1;
        block0: while (!this.traverseStack.isEmpty() && i < filterLevels.size()) {
            String levelNameToSeek = i == -1 ? "\u0000" : filterLevels.get(i);
            ++i;
            TopicFilterTrieNode<V> node2 = this.traverseStack.peek();
            String levelName = node2.levelName();
            int cmp = levelNameToSeek.compareTo(levelName);
            if (cmp < 0) break;
            if (cmp == 0) {
                if (i == filterLevels.size()) break;
                String nextLevelNameToSeek = filterLevels.get(i);
                node2.seekChild(nextLevelNameToSeek);
                if (node2.atValidChild()) {
                    this.traverseStack.push(node2.childNode());
                    continue;
                }
                this.popAndRelease();
                if (this.traverseStack.isEmpty()) break;
                while (!this.traverseStack.isEmpty()) {
                    TopicFilterTrieNode<V> parent = this.traverseStack.peek();
                    parent.nextChild();
                    if (parent.atValidChild()) {
                        this.traverseStack.push(parent.childNode());
                        break block0;
                    }
                    this.popAndRelease();
                }
                continue;
            }
            while (!this.traverseStack.isEmpty()) {
                this.popAndRelease();
            }
        }
        while (!this.traverseStack.isEmpty() && (node = this.traverseStack.peek()).backingTopics().isEmpty()) {
            assert (node.atValidChild());
            this.traverseStack.push(node.childNode());
        }
    }

    @Override
    public void seekPrev(List<String> filterLevels) {
        this.clearTraverseStack();
        this.traverseStack.push(TopicFilterTrieNode.from(this.topicTrieRoot));
        int i = -1;
        block0: while (!this.traverseStack.isEmpty() && i < filterLevels.size()) {
            String levelNameToSeek = i == -1 ? "\u0000" : filterLevels.get(i);
            ++i;
            TopicFilterTrieNode<V> node = this.traverseStack.peek();
            String levelName = node.levelName();
            int cmp = levelNameToSeek.compareTo(levelName);
            if (cmp > 0) break;
            if (cmp == 0) {
                if (i == filterLevels.size()) {
                    this.popAndRelease();
                    if (this.traverseStack.isEmpty()) break;
                    while (!this.traverseStack.isEmpty()) {
                        TopicFilterTrieNode<V> parent = this.traverseStack.peek();
                        parent.prevChild();
                        if (parent.atValidChild()) {
                            this.traverseStack.push(parent.childNode());
                            break block0;
                        }
                        if (parent.backingTopics().isEmpty()) {
                            this.popAndRelease();
                            continue;
                        }
                        parent.seekToFirstChild();
                        return;
                    }
                    continue;
                }
                String nextLevelNameToSeek = filterLevels.get(i);
                node.seekPrevChild(nextLevelNameToSeek);
                if (node.atValidChild()) {
                    this.traverseStack.push(node.childNode());
                    continue;
                }
                if (!node.backingTopics().isEmpty()) {
                    node.seekToFirstChild();
                    return;
                }
                this.popAndRelease();
                if (this.traverseStack.isEmpty()) break;
                while (!this.traverseStack.isEmpty()) {
                    TopicFilterTrieNode<V> parent = this.traverseStack.peek();
                    parent.prevChild();
                    if (parent.atValidChild()) {
                        this.traverseStack.push(parent.childNode());
                        break block0;
                    }
                    if (parent.backingTopics().isEmpty()) {
                        this.popAndRelease();
                        continue;
                    }
                    node.seekToFirstChild();
                    return;
                }
                continue;
            }
            while (!this.traverseStack.isEmpty()) {
                this.popAndRelease();
            }
        }
        while (!this.traverseStack.isEmpty()) {
            TopicFilterTrieNode<V> node = this.traverseStack.peek();
            node.seekToLastChild();
            if (node.atValidChild()) {
                this.traverseStack.push(node.childNode());
                continue;
            }
            assert (!node.backingTopics().isEmpty());
            break;
        }
    }

    @Override
    public boolean isValid() {
        return !this.traverseStack.isEmpty();
    }

    @Override
    public void prev() {
        assert (this.traverseStack.isEmpty() || !this.traverseStack.peek().backingTopics().isEmpty());
        while (!this.traverseStack.isEmpty()) {
            this.popAndRelease();
            if (this.traverseStack.isEmpty()) {
                return;
            }
            TopicFilterTrieNode<V> parent = this.traverseStack.peek();
            parent.prevChild();
            if (parent.atValidChild()) {
                TopicFilterTrieNode<V> subNode = parent.childNode();
                this.traverseStack.add(subNode);
                while (!this.traverseStack.isEmpty()) {
                    TopicFilterTrieNode<V> node = this.traverseStack.peek();
                    node.seekToLastChild();
                    if (node.atValidChild()) {
                        this.traverseStack.push(node.childNode());
                        continue;
                    }
                    if (node.backingTopics().isEmpty()) continue;
                    return;
                }
                continue;
            }
            if (parent.backingTopics().isEmpty()) continue;
            return;
        }
    }

    @Override
    public void next() {
        assert (this.traverseStack.isEmpty() || !this.traverseStack.peek().backingTopics().isEmpty());
        while (!this.traverseStack.isEmpty()) {
            TopicFilterTrieNode<V> node = this.traverseStack.peek();
            if (node.atValidChild()) {
                TopicFilterTrieNode<V> subNode = node.childNode();
                this.traverseStack.add(subNode);
                if (subNode.backingTopics().isEmpty()) continue;
                break;
            }
            this.popAndRelease();
            if (this.traverseStack.isEmpty()) continue;
            this.traverseStack.peek().nextChild();
        }
    }

    @Override
    public List<String> key() {
        if (this.traverseStack.isEmpty()) {
            throw new NoSuchElementException();
        }
        TopicFilterTrieNode<V> filterNode = this.traverseStack.peek();
        LinkedList<String> topicFilter = new LinkedList<String>(filterNode.topicFilterPrefix());
        topicFilter.add(filterNode.levelName());
        return topicFilter;
    }

    @Override
    public Map<List<String>, Set<V>> value() {
        if (this.traverseStack.isEmpty()) {
            throw new NoSuchElementException();
        }
        HashMap<List<String>, Set<Set<V>>> value = new HashMap<List<String>, Set<Set<V>>>();
        for (TopicTrieNode<V> topicTrieNode : this.traverseStack.peek().backingTopics()) {
            value.put(topicTrieNode.topic(), topicTrieNode.values());
        }
        return value;
    }

    private void clearTraverseStack() {
        while (!this.traverseStack.isEmpty()) {
            this.popAndRelease();
        }
    }

    private void popAndRelease() {
        TopicFilterTrieNode.release(this.traverseStack.pop());
    }
}

