/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.dist.trie;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.Scheduler;
import com.github.benmanes.caffeine.cache.Ticker;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.bifromq.dist.trie.MTopicFilterTrieNode;
import org.apache.bifromq.dist.trie.NTopicFilterTrieNode;
import org.apache.bifromq.dist.trie.TopicFilterTrieNode;
import org.apache.bifromq.dist.trie.TopicTrieNode;

final class STopicFilterTrieNode<V>
extends TopicFilterTrieNode<V> {
    private static final ConcurrentLinkedDeque<Long> KEYS = new ConcurrentLinkedDeque();
    private static final AtomicLong SEQ = new AtomicLong();
    private static volatile Ticker TICKER = Ticker.systemTicker();
    private static final Cache<Long, STopicFilterTrieNode<?>> POOL = Caffeine.newBuilder().expireAfterAccess(EXPIRE_AFTER).recordStats().scheduler(Scheduler.systemScheduler()).ticker(() -> TICKER.read()).removalListener((key, value, cause) -> {
        KEYS.remove(key);
        if (cause == RemovalCause.EXPIRED || cause == RemovalCause.SIZE) {
            value.recycle();
        }
    }).build();
    private final NavigableSet<String> subLevelNames = new TreeSet<String>();
    private final NavigableMap<String, Set<TopicTrieNode<V>>> subTopicTrieNodes = new TreeMap<String, Set<TopicTrieNode<V>>>();
    private final Set<TopicTrieNode<V>> subWildcardMatchableTopicTrieNodes = new HashSet<TopicTrieNode<V>>();
    private final Set<TopicTrieNode<V>> backingTopics = new HashSet<TopicTrieNode<V>>();
    private String subLevelName;

    STopicFilterTrieNode() {
    }

    static <V> STopicFilterTrieNode<V> borrow(TopicFilterTrieNode<V> parent, Set<TopicTrieNode<V>> siblingTopicTrieNodes) {
        Long key;
        while ((key = KEYS.pollFirst()) != null) {
            STopicFilterTrieNode pooled = (STopicFilterTrieNode)POOL.asMap().remove(key);
            if (pooled == null) continue;
            return pooled.init(parent, siblingTopicTrieNodes);
        }
        STopicFilterTrieNode<V> node = new STopicFilterTrieNode<V>();
        return node.init(parent, siblingTopicTrieNodes);
    }

    static void release(STopicFilterTrieNode<?> node) {
        node.recycle();
        long key = SEQ.incrementAndGet();
        KEYS.offerLast(key);
        POOL.put((Object)key, node);
    }

    static void poolClear() {
        POOL.invalidateAll();
        POOL.cleanUp();
        KEYS.clear();
    }

    static void poolCleanUp() {
        POOL.cleanUp();
    }

    static int poolApproxSize() {
        return KEYS.size();
    }

    static void setTicker(Ticker ticker) {
        TICKER = ticker != null ? ticker : Ticker.systemTicker();
    }

    STopicFilterTrieNode<V> init(TopicFilterTrieNode<V> parent, Set<TopicTrieNode<V>> siblingTopicTrieNodes) {
        assert (siblingTopicTrieNodes != null);
        this.parent = parent;
        this.subLevelName = null;
        this.subLevelNames.clear();
        this.subTopicTrieNodes.clear();
        this.subWildcardMatchableTopicTrieNodes.clear();
        this.backingTopics.clear();
        for (TopicTrieNode<V> sibling : siblingTopicTrieNodes) {
            if (sibling.isUserTopic()) {
                this.backingTopics.add(sibling);
            }
            for (Map.Entry entry : sibling.children().entrySet()) {
                TopicTrieNode subNode = (TopicTrieNode)entry.getValue();
                if (subNode.wildcardMatchable()) {
                    this.subWildcardMatchableTopicTrieNodes.add(subNode);
                }
                this.subTopicTrieNodes.computeIfAbsent(subNode.levelName(), k -> new HashSet()).add(subNode);
                this.subLevelNames.add(subNode.levelName());
            }
        }
        if (!this.backingTopics.isEmpty()) {
            this.subLevelNames.add("#");
        }
        if (!this.subWildcardMatchableTopicTrieNodes.isEmpty()) {
            this.subLevelNames.add("#");
            this.subLevelNames.add("+");
        }
        this.seekChild("");
        return this;
    }

    @Override
    String levelName() {
        return "+";
    }

    @Override
    Set<TopicTrieNode<V>> backingTopics() {
        return this.backingTopics;
    }

    @Override
    void seekChild(String childLevelName) {
        if (!this.subLevelNames.isEmpty()) {
            this.subLevelName = this.subLevelNames.ceiling(childLevelName);
        }
    }

    @Override
    void seekPrevChild(String childLevelName) {
        if (!this.subLevelNames.isEmpty()) {
            this.subLevelName = this.subLevelNames.floor(childLevelName);
        }
    }

    @Override
    void seekToFirstChild() {
        if (!this.subLevelNames.isEmpty()) {
            this.subLevelName = (String)this.subLevelNames.first();
        }
    }

    @Override
    void seekToLastChild() {
        if (!this.subLevelNames.isEmpty()) {
            this.subLevelName = (String)this.subLevelNames.last();
        }
    }

    @Override
    boolean atValidChild() {
        return this.subLevelName != null;
    }

    @Override
    void nextChild() {
        if (this.subLevelName != null) {
            this.subLevelName = this.subLevelNames.higher(this.subLevelName);
        }
    }

    @Override
    void prevChild() {
        if (this.subLevelName != null) {
            this.subLevelName = this.subLevelNames.lower(this.subLevelName);
        }
    }

    @Override
    TopicFilterTrieNode<V> childNode() {
        if (this.subLevelName == null) {
            throw new NoSuchElementException();
        }
        return switch (this.subLevelName) {
            case "#" -> MTopicFilterTrieNode.borrow(this, this.subWildcardMatchableTopicTrieNodes);
            case "+" -> STopicFilterTrieNode.borrow(this, this.subWildcardMatchableTopicTrieNodes);
            default -> NTopicFilterTrieNode.borrow(this, this.subLevelName, (Set)this.subTopicTrieNodes.get(this.subLevelName));
        };
    }

    private void recycle() {
        this.parent = null;
        this.subLevelName = null;
        this.subLevelNames.clear();
        this.subTopicTrieNodes.clear();
        this.subWildcardMatchableTopicTrieNodes.clear();
        this.backingTopics.clear();
    }
}

