/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.store.range;

import java.time.Duration;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.bifromq.basekv.proto.KVRangeMessage;
import org.apache.bifromq.basekv.proto.KVRangeSnapshot;
import org.apache.bifromq.basekv.proto.SnapshotSyncRequest;
import org.apache.bifromq.basekv.store.exception.KVRangeStoreException;
import org.apache.bifromq.basekv.store.range.IKVRange;
import org.apache.bifromq.basekv.store.range.IKVRangeMessenger;
import org.apache.bifromq.basekv.store.range.IKVRangeMetricManager;
import org.apache.bifromq.basekv.store.range.IKVRangeRestoreSession;
import org.apache.bifromq.basekv.store.range.IKVRangeSnapshotReceiver;
import org.apache.bifromq.basekv.store.range.KVRangeSnapshotReceiver;
import org.apache.bifromq.logger.MDCLogger;
import org.slf4j.Logger;

class KVRangeRestorer {
    private static final long PROGRESS_LOG_INTERVAL_NANOS = Duration.ofSeconds(5L).toNanos();
    private final Logger log;
    private final IKVRange range;
    private final IKVRangeMessenger messenger;
    private final IKVRangeMetricManager metricManager;
    private final Executor executor;
    private final int idleTimeSec;
    private final AtomicReference<RestoreSession> currentSession = new AtomicReference();

    KVRangeRestorer(KVRangeSnapshot startSnapshot, IKVRange range, IKVRangeMessenger messenger, IKVRangeMetricManager metricManager, Executor executor, int idleTimeSec, String ... tags) {
        this.range = range;
        this.messenger = messenger;
        this.metricManager = metricManager;
        this.executor = executor;
        this.idleTimeSec = idleTimeSec;
        this.log = MDCLogger.getLogger(KVRangeRestorer.class, (String[])tags);
        RestoreSession initialSession = new RestoreSession(startSnapshot, null);
        initialSession.doneFuture.complete(null);
        this.currentSession.set(initialSession);
    }

    public CompletableFuture<Void> awaitDone() {
        return this.currentSession.get().doneFuture.exceptionally(ex -> null);
    }

    public CompletableFuture<Void> restoreFrom(String leader, KVRangeSnapshot rangeSnapshot) {
        RestoreSession existingSession = this.currentSession.get();
        if (existingSession != null && existingSession.snapshot.equals((Object)rangeSnapshot) && !existingSession.doneFuture.isDone() && Objects.equals(existingSession.leader, leader)) {
            this.log.info("Reuse snapshot restore session: session={}, leader={} \n{}", new Object[]{existingSession.id, existingSession.leader, rangeSnapshot});
            return existingSession.doneFuture;
        }
        RestoreSession session = new RestoreSession(rangeSnapshot, leader);
        RestoreSession prevSession = this.currentSession.getAndSet(session);
        if (prevSession != null && !prevSession.doneFuture.isDone()) {
            this.log.info("Cancel previous restore session: session={}, leader={} \n{}", new Object[]{prevSession.id, prevSession.leader, prevSession.snapshot});
            prevSession.doneFuture.cancel(true);
        }
        CompletableFuture<Void> onDone = session.doneFuture;
        long startNanos = System.nanoTime();
        try {
            IKVRangeRestoreSession restoreSession = this.range.startRestore(rangeSnapshot, (count, bytes) -> {
                session.totalEntries += (long)count;
                session.totalBytes += bytes;
                long now = System.nanoTime();
                if (now - session.lastProgressLogTS >= PROGRESS_LOG_INTERVAL_NANOS) {
                    this.log.info("Restore snapshot progress: sessionId={}, leader={}, totalEntries={}, totalBytes={}, elapsed={}ms", new Object[]{session.id, leader, session.totalEntries, session.totalBytes, TimeUnit.NANOSECONDS.toMillis(now - session.startNanos)});
                    session.lastProgressLogTS = now;
                }
            });
            this.log.info("Restoring from snapshot: session={}, leader={} \n{}", new Object[]{session.id, leader, rangeSnapshot});
            KVRangeSnapshotReceiver receiver = new KVRangeSnapshotReceiver(session.id, rangeSnapshot.getId(), leader, this.messenger, this.metricManager, this.executor, this.idleTimeSec, this.log);
            CompletableFuture<IKVRangeSnapshotReceiver.Result> receiveFuture = receiver.start(restoreSession::put);
            onDone.whenComplete((v, e) -> {
                if (onDone.isCancelled()) {
                    restoreSession.abort();
                    receiveFuture.cancel(true);
                }
            });
            receiveFuture.whenCompleteAsync((result, e) -> {
                if (e != null) {
                    restoreSession.abort();
                    onDone.completeExceptionally(new KVRangeStoreException("Snapshot restore failed", (Throwable)e));
                    return;
                }
                if (result.code() == IKVRangeSnapshotReceiver.Code.DONE) {
                    restoreSession.done();
                    onDone.complete(null);
                    this.log.info("Restored from snapshot: session={}, leader={}, entries={}, bytes={}, cost={}ms", new Object[]{session.id, session.leader, result.totalEntries(), result.totalBytes(), TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos)});
                } else {
                    restoreSession.abort();
                    onDone.completeExceptionally(new KVRangeStoreException("Snapshot restore failed: " + String.valueOf(result)));
                }
            }, this.executor);
            this.log.info("Send snapshot sync request to {} {}", (Object)leader, (Object)(!onDone.isDone() ? 1 : 0));
            if (!onDone.isDone()) {
                this.messenger.send(KVRangeMessage.newBuilder().setRangeId(this.range.id()).setHostStoreId(session.leader).setSnapshotSyncRequest(SnapshotSyncRequest.newBuilder().setSessionId(session.id).setSnapshot(rangeSnapshot).build()).build());
            }
        }
        catch (Throwable t) {
            this.log.error("Unexpected error", t);
        }
        return onDone;
    }

    private static class RestoreSession {
        final String id = UUID.randomUUID().toString();
        final KVRangeSnapshot snapshot;
        final CompletableFuture<Void> doneFuture = new CompletableFuture();
        final String leader;
        long startNanos;
        long lastProgressLogTS;
        long totalEntries;
        long totalBytes;

        private RestoreSession(KVRangeSnapshot snapshot, String leader) {
            this.snapshot = snapshot;
            this.leader = leader;
            this.lastProgressLogTS = this.startNanos = System.nanoTime();
            this.totalEntries = 0L;
            this.totalBytes = 0L;
        }
    }
}

