/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.plugin.subbroker;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.bifromq.plugin.subbroker.ISubBroker;
import org.apache.bifromq.plugin.subbroker.ISubBrokerManager;
import org.apache.bifromq.plugin.subbroker.MonitoredSubBroker;
import org.apache.bifromq.plugin.subbroker.NoInboxSubBroker;
import org.pf4j.PluginManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubBrokerManager
implements ISubBrokerManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SubBrokerManager.class);
    private final AtomicBoolean stopped = new AtomicBoolean();
    private final Map<Integer, ISubBroker> receivers = new HashMap<Integer, ISubBroker>();

    public SubBrokerManager(PluginManager pluginMgr, ISubBroker ... builtInReceivers) {
        for (ISubBroker receiver : builtInReceivers) {
            log.info("Register built-in receiver[{}] with id[{}]", (Object)receiver.getClass().getSimpleName(), (Object)receiver.id());
            this.receivers.put(receiver.id(), new MonitoredSubBroker(receiver));
        }
        List customReceivers = pluginMgr.getExtensions(ISubBroker.class);
        for (ISubBroker customReceiver : customReceivers) {
            if (this.receivers.containsKey(customReceiver.id())) {
                log.warn("Id[{}] is reserved for receiver[{}], skip registering custom receiver[{}]", new Object[]{customReceiver.id(), this.receivers.get(customReceiver.id()).getClass().getName(), customReceiver.getClass().getName()});
                continue;
            }
            log.info("Register custom receiver[{}] with id[{}]", (Object)customReceiver.getClass().getSimpleName(), (Object)customReceiver.id());
            this.receivers.put(customReceiver.id(), new MonitoredSubBroker(customReceiver));
        }
    }

    @Override
    public ISubBroker get(int subBrokerId) {
        return this.receivers.getOrDefault(subBrokerId, NoInboxSubBroker.INSTANCE);
    }

    @Override
    public void close() {
        if (this.stopped.compareAndSet(false, true)) {
            log.debug("Stopping SubBrokerManager");
            this.receivers.values().forEach(ISubBroker::close);
            log.debug("SubBrokerManager stopped");
        }
    }
}

