/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.metrics;

import java.util.concurrent.TimeUnit;
import org.apache.spark.SparkConf;
import org.apache.spark.metrics.MetricsSystem;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.util.matching.Regex;

public final class MetricsSystem$ {
    public static MetricsSystem$ MODULE$;
    private final Regex SINK_REGEX;
    private final Regex SOURCE_REGEX;
    private final TimeUnit MINIMAL_POLL_UNIT;
    private final int MINIMAL_POLL_PERIOD;

    static {
        new MetricsSystem$();
    }

    public Regex SINK_REGEX() {
        return this.SINK_REGEX;
    }

    public Regex SOURCE_REGEX() {
        return this.SOURCE_REGEX;
    }

    public void checkMinimalPollingPeriod(TimeUnit pollUnit, int pollPeriod) {
        long period = this.MINIMAL_POLL_UNIT.convert(pollPeriod, pollUnit);
        if (period < (long)this.MINIMAL_POLL_PERIOD) {
            throw new IllegalArgumentException(new StringBuilder(51).append("Polling period ").append(pollPeriod).append(" ").append((Object)pollUnit).append(" below than minimal polling period ").toString());
        }
    }

    public MetricsSystem createMetricsSystem(String instance, SparkConf conf) {
        return new MetricsSystem(instance, conf);
    }

    private MetricsSystem$() {
        MODULE$ = this;
        this.SINK_REGEX = new StringOps(Predef$.MODULE$.augmentString("^sink\\.(.+)\\.(.+)")).r();
        this.SOURCE_REGEX = new StringOps(Predef$.MODULE$.augmentString("^source\\.(.+)\\.(.+)")).r();
        this.MINIMAL_POLL_UNIT = TimeUnit.SECONDS;
        this.MINIMAL_POLL_PERIOD = 1;
    }
}

